/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.marshalling.ByteBufferInput;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public abstract class AbstractPersistentSessionManager
implements SessionPersistenceManager,
Service<SessionPersistenceManager> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"undertow", "persistent-session-manager"});
    private MarshallerFactory factory;
    private MarshallingConfiguration configuration;
    private final InjectedValue<ModuleLoader> moduleLoaderInjectedValue = new InjectedValue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistSessions(String deploymentName, Map<String, SessionPersistenceManager.PersistentSession> sessionData) {
        try (Marshaller marshaller = this.createMarshaller();){
            HashMap<String, SessionEntry> serializedData = new HashMap<String, SessionEntry>();
            for (Map.Entry<String, SessionPersistenceManager.PersistentSession> sessionEntry : sessionData.entrySet()) {
                HashMap data = new HashMap();
                for (Map.Entry sessionAttribute : sessionEntry.getValue().getSessionData().entrySet()) {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)out));
                        marshaller.writeObject(sessionAttribute.getValue());
                        marshaller.finish();
                        data.put(sessionAttribute.getKey(), out.toByteArray());
                    }
                    catch (Exception e) {
                        UndertowLogger.ROOT_LOGGER.failedToPersistSessionAttribute((String)sessionAttribute.getKey(), sessionAttribute.getValue(), sessionEntry.getKey(), e);
                    }
                }
                serializedData.put(sessionEntry.getKey(), new SessionEntry(sessionEntry.getValue().getExpiration(), data));
            }
            this.persistSerializedSessions(deploymentName, serializedData);
        }
        catch (Exception e) {
            UndertowServletLogger.ROOT_LOGGER.failedToPersistSessions(e);
        }
    }

    protected abstract void persistSerializedSessions(String var1, Map<String, SessionEntry> var2) throws IOException;

    protected abstract Map<String, SessionEntry> loadSerializedSessions(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, SessionPersistenceManager.PersistentSession> loadSessionAttributes(String deploymentName, ClassLoader classLoader) {
        try (Unmarshaller unmarshaller = this.createUnmarshaller();){
            long time = System.currentTimeMillis();
            Map<String, SessionEntry> data = this.loadSerializedSessions(deploymentName);
            if (data == null) return null;
            HashMap<String, SessionPersistenceManager.PersistentSession> ret = new HashMap<String, SessionPersistenceManager.PersistentSession>();
            for (Map.Entry<String, SessionEntry> sessionEntry : data.entrySet()) {
                if (sessionEntry.getValue().expiry.getTime() <= time) continue;
                HashMap session = new HashMap();
                for (Map.Entry sessionAttribute : sessionEntry.getValue().data.entrySet()) {
                    unmarshaller.start((ByteInput)new ByteBufferInput(ByteBuffer.wrap((byte[])sessionAttribute.getValue())));
                    session.put(sessionAttribute.getKey(), unmarshaller.readObject());
                    unmarshaller.finish();
                }
                ret.put(sessionEntry.getKey(), new SessionPersistenceManager.PersistentSession(sessionEntry.getValue().expiry, session));
            }
            HashMap<String, SessionPersistenceManager.PersistentSession> hashMap = ret;
            return hashMap;
        }
        catch (Exception e) {
            UndertowServletLogger.ROOT_LOGGER.failedtoLoadPersistentSessions(e);
        }
        return null;
    }

    protected Marshaller createMarshaller() throws IOException {
        return this.factory.createMarshaller(this.configuration);
    }

    protected Unmarshaller createUnmarshaller() throws IOException {
        return this.factory.createUnmarshaller(this.configuration);
    }

    public void clear(String deploymentName) {
    }

    public synchronized void start(StartContext startContext) throws StartException {
        RiverMarshallerFactory factory = new RiverMarshallerFactory();
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.moduleLoaderInjectedValue.getValue())));
        this.configuration = configuration;
        this.factory = factory;
    }

    public synchronized void stop(StopContext stopContext) {
    }

    public synchronized SessionPersistenceManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ModuleLoader> getModuleLoaderInjectedValue() {
        return this.moduleLoaderInjectedValue;
    }

    protected static final class SessionEntry
    implements Serializable {
        private final Date expiry;
        private final Map<String, byte[]> data;

        private SessionEntry(Date expiry, Map<String, byte[]> data) {
            this.expiry = expiry;
            this.data = data;
        }

        public Date getExpiry() {
            return this.expiry;
        }

        public Map<String, byte[]> getData() {
            return this.data;
        }
    }
}

