/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.protocol.mgmt.support.ManagementChannelShutdownHandle;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRequestTracker;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;

public abstract class AbstractChannelOpenListenerService
implements Service<Void>,
OpenListener {
    protected static final int CHANNEL_SHUTDOWN_TIMEOUT;
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<ManagementChannelRegistryService> registry = new InjectedValue();
    protected final String channelName;
    private final OptionMap optionMap;
    private final Set<ManagementChannelShutdownHandle> handles = Collections.synchronizedSet(new HashSet());
    private volatile ManagementRequestTracker trackerService;
    private volatile boolean closed = true;

    public AbstractChannelOpenListenerService(String channelName, OptionMap optionMap) {
        this.channelName = channelName;
        this.optionMap = optionMap;
    }

    public ServiceName getServiceName(ServiceName endpointName) {
        return RemotingServices.channelServiceName(endpointName, this.channelName);
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public InjectedValue<ManagementChannelRegistryService> getRegistry() {
        return this.registry;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.closed = false;
            RemotingLogger.ROOT_LOGGER.debugf("Registering channel listener for %s", this.channelName);
            ManagementChannelRegistryService registry = (ManagementChannelRegistryService)this.registry.getValue();
            Registration registration = ((Endpoint)this.endpointValue.getValue()).registerService(this.channelName, (OpenListener)this, this.optionMap);
            registry.register(registration);
            this.trackerService = registry.getTrackerService();
        }
        catch (Exception e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotStartChanelListener(e);
        }
    }

    public synchronized void stop(final StopContext context) {
        this.closed = true;
        this.trackerService.prepareShutdown();
        final Set<ManagementChannelShutdownHandle> handlesCopy = this.copyHandles();
        for (ManagementChannelShutdownHandle handle : handlesCopy) {
            handle.shutdown();
        }
        Runnable shutdownTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long end = System.currentTimeMillis() + (long)CHANNEL_SHUTDOWN_TIMEOUT;
                boolean interrupted = Thread.currentThread().isInterrupted();
                try {
                    for (ManagementChannelShutdownHandle handle : handlesCopy) {
                        long remaining = end - System.currentTimeMillis();
                        try {
                            if (!interrupted && !handle.awaitCompletion(remaining, TimeUnit.MILLISECONDS)) {
                                ControllerLogger.ROOT_LOGGER.gracefulManagementChannelHandlerShutdownTimedOut(CHANNEL_SHUTDOWN_TIMEOUT);
                            }
                            AbstractChannelOpenListenerService.this.trackerService.unregisterTracker(handle);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            ControllerLogger.ROOT_LOGGER.gracefulManagementChannelHandlerShutdownFailed((Throwable)e);
                        }
                        catch (Exception e) {
                            ControllerLogger.ROOT_LOGGER.gracefulManagementChannelHandlerShutdownFailed((Throwable)e);
                        }
                        finally {
                            handle.shutdownNow();
                        }
                    }
                }
                finally {
                    context.complete();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        context.asynchronous();
        this.execute(shutdownTask);
    }

    public void channelOpened(Channel channel) {
        if (this.closed) {
            RemotingLogger.ROOT_LOGGER.debugf("server shutting down, closing channel %s.", channel);
            channel.closeAsync();
            return;
        }
        final ManagementChannelShutdownHandle handle = this.handleChannelOpened(channel);
        this.trackerService.registerTracker(handle);
        this.handles.add(handle);
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                AbstractChannelOpenListenerService.this.handles.remove(handle);
                handle.shutdownNow();
                AbstractChannelOpenListenerService.this.trackerService.unregisterTracker(handle);
                RemotingLogger.ROOT_LOGGER.tracef("Handling close for %s", handle);
            }
        });
    }

    public void registrationTerminated() {
        Set<ManagementChannelShutdownHandle> copy = this.copyHandles();
        for (ManagementChannelShutdownHandle channel : copy) {
            channel.shutdownNow();
        }
    }

    protected abstract ManagementChannelShutdownHandle handleChannelOpened(Channel var1);

    protected abstract void execute(Runnable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ManagementChannelShutdownHandle> copyHandles() {
        Set<ManagementChannelShutdownHandle> set = this.handles;
        synchronized (set) {
            return new HashSet<ManagementChannelShutdownHandle>(this.handles);
        }
    }

    static {
        int timeout;
        String prop = null;
        try {
            prop = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.as.management.channel.close.timeout", (String)"15000");
            timeout = Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            ControllerLogger.ROOT_LOGGER.invalidChannelCloseTimeout(e, "jboss.as.management.channel.close.timeout", prop);
            timeout = 15000;
        }
        CHANNEL_SHUTDOWN_TIMEOUT = timeout;
    }
}

