/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import io.reactivex.Flowable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.infinispan.commons.util.ByRef;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PersistenceUtil {
    private static Log log = LogFactory.getLog(PersistenceUtil.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int SEGMENT_NOT_PROVIDED = -1;

    public static KeyFilter notNull(KeyFilter filter) {
        return filter == null ? KeyFilter.ACCEPT_ALL_FILTER : filter;
    }

    @Deprecated
    public static <K, V> int count(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter) {
        return PersistenceUtil.count(acl, filter);
    }

    public static <K, V> int count(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter) {
        Long result = (Long)Flowable.fromPublisher(acl.publishKeys(filter)).count().blockingGet();
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return result.intValue();
    }

    @Deprecated
    public static <K, V> Set<K> toKeySet(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter) {
        return PersistenceUtil.toKeySet(acl, filter);
    }

    public static <K, V> Set<K> toKeySet(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter) {
        if (acl == null) {
            return Collections.emptySet();
        }
        return (Set)Flowable.fromPublisher(acl.publishKeys(filter)).collectInto(new HashSet(), Set::add).blockingGet();
    }

    @Deprecated
    public static <K, V> Set<InternalCacheEntry> toEntrySet(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter, InternalEntryFactory ief) {
        Set<InternalCacheEntry> entrySet = PersistenceUtil.toEntrySet(acl, filter, ief);
        return entrySet;
    }

    public static <K, V> Set<InternalCacheEntry<K, V>> toEntrySet(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter, InternalEntryFactory ief) {
        if (acl == null) {
            return Collections.emptySet();
        }
        return (Set)Flowable.fromPublisher(acl.publishEntries(filter, true, true)).map(me -> ief.create(me.getKey(), me.getValue(), me.getMetadata())).collectInto(new HashSet(), Set::add).blockingGet();
    }

    public static long getExpiryTime(InternalMetadata internalMetadata) {
        return internalMetadata == null ? -1L : internalMetadata.expiryTime();
    }

    public static InternalMetadata internalMetadata(InternalCacheEntry ice) {
        return ice.getMetadata() == null ? null : new InternalMetadataImpl(ice);
    }

    public static InternalMetadata internalMetadata(InternalCacheValue icv) {
        return icv.getMetadata() == null ? null : new InternalMetadataImpl(icv.getMetadata(), icv.getCreated(), icv.getLastUsed());
    }

    public static <K, V> InternalCacheEntry<K, V> loadAndStoreInDataContainer(DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, AtomicReference<Boolean> isLoaded) {
        return PersistenceUtil.loadAndStoreInDataContainer(dataContainer, -1, persistenceManager, key, ctx, timeService, isLoaded);
    }

    public static <K, V> InternalCacheEntry<K, V> loadAndStoreInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, AtomicReference<Boolean> isLoaded) {
        return PersistenceUtil.loadAndComputeInDataContainer(dataContainer, segment, persistenceManager, key, ctx, timeService, null, isLoaded);
    }

    public static <K, V> InternalCacheEntry<K, V> loadAndComputeInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, DataContainer.ComputeAction<K, V> action) {
        return PersistenceUtil.loadAndComputeInDataContainer(dataContainer, segment, persistenceManager, key, ctx, timeService, action, null);
    }

    private static <K, V> InternalCacheEntry<K, V> loadAndComputeInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, DataContainer.ComputeAction<K, V> action, AtomicReference<Boolean> isLoaded) {
        ByRef expired = new ByRef(null);
        DataContainer.ComputeAction computeAction = (k, oldEntry, factory) -> {
            InternalCacheEntry entryToUse;
            block13: {
                if (oldEntry != null) {
                    if (oldEntry.canExpire() && oldEntry.isExpired(timeService.wallClockTime())) {
                        MarshalledEntry loaded = PersistenceUtil.loadAndCheckExpiration(persistenceManager, key, ctx, false);
                        if (loaded != null) {
                            if (isLoaded != null) {
                                isLoaded.set(Boolean.TRUE);
                            }
                            entryToUse = PersistenceUtil.convert(loaded, factory);
                            break block13;
                        } else {
                            if (isLoaded != null) {
                                isLoaded.set(Boolean.FALSE);
                            }
                            expired.set((Object)Boolean.TRUE);
                            return oldEntry;
                        }
                    }
                    if (isLoaded != null) {
                        isLoaded.set(null);
                    }
                    entryToUse = oldEntry;
                } else {
                    MarshalledEntry loaded = PersistenceUtil.loadAndCheckExpiration(persistenceManager, key, ctx, true);
                    if (loaded != null) {
                        if (isLoaded != null) {
                            isLoaded.set(Boolean.TRUE);
                        }
                        entryToUse = PersistenceUtil.convert(loaded, factory);
                    } else {
                        if (isLoaded != null) {
                            isLoaded.set(Boolean.FALSE);
                        }
                        entryToUse = null;
                    }
                }
            }
            if (action != null) {
                return action.compute(k, entryToUse, factory);
            }
            return entryToUse;
        };
        InternalCacheEntry<Object, V> entry = segment != -1 && dataContainer instanceof InternalDataContainer ? ((InternalDataContainer)dataContainer).compute(segment, key, computeAction) : dataContainer.compute(key, computeAction);
        if (expired.get() == Boolean.TRUE) {
            return null;
        }
        return entry;
    }

    public static <K, V> MarshalledEntry<K, V> loadAndCheckExpiration(PersistenceManager persistenceManager, Object key, InvocationContext context, TimeService timeService) {
        return PersistenceUtil.loadAndCheckExpiration(persistenceManager, key, context, true);
    }

    private static <K, V> MarshalledEntry<K, V> loadAndCheckExpiration(PersistenceManager persistenceManager, Object key, InvocationContext context, boolean includeStores) {
        MarshalledEntry loaded = persistenceManager.loadFromAllStores(key, context.isOriginLocal(), includeStores);
        if (trace) {
            log.tracef("Loaded %s for key %s from persistence.", loaded, key);
        }
        return loaded;
    }

    public static <K, V> InternalCacheEntry<K, V> convert(MarshalledEntry<K, V> loaded, InternalEntryFactory factory) {
        InternalMetadata metadata = loaded.getMetadata();
        if (metadata != null) {
            InternalMetadata actual = metadata instanceof InternalMetadataImpl ? ((InternalMetadataImpl)metadata).actual() : metadata;
            return factory.create(loaded.getKey(), loaded.getValue(), actual, metadata.created(), metadata.lifespan(), metadata.lastUsed(), metadata.maxIdle());
        }
        return factory.create(loaded.getKey(), loaded.getValue(), (Metadata)null);
    }
}

