/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.jboss.weld.security.GetDeclaredConstructorsAction;
import org.jboss.weld.security.GetDeclaredFieldsAction;
import org.jboss.weld.security.GetDeclaredMethodsAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static Method[] getDeclaredMethods(Class<?> javaClass) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetDeclaredMethodsAction(javaClass));
        }
        return javaClass.getDeclaredMethods();
    }

    static Field[] getDeclaredFields(Class<?> javaClass) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetDeclaredFieldsAction(javaClass));
        }
        return javaClass.getDeclaredFields();
    }

    static Constructor<?>[] getDeclaredConstructors(Class<?> javaClass) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetDeclaredConstructorsAction(javaClass));
        }
        return javaClass.getDeclaredConstructors();
    }
}

