/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.jca;

import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.jca.core.api.connectionmanager.ConnectionManager;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.connectionmanager.ccm.CachedConnectionManagerImpl;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.security.SubjectFactory;
import org.jboss.jca.core.spi.transaction.ConnectableResource;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.XAResourceStatistics;
import org.jboss.jca.core.spi.transaction.local.LocalXAResource;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.core.spi.transaction.usertx.UserTransactionRegistry;
import org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class NonTxCachedConnectionManagerService
implements Service<CachedConnectionManager> {
    private volatile CachedConnectionManager value;
    private final boolean debug;
    private final boolean error;
    private final boolean ignoreUnknownConnections;

    public NonTxCachedConnectionManagerService(boolean debug, boolean error, boolean ignoreUnknownConnections) {
        this.debug = debug;
        this.error = error;
        this.ignoreUnknownConnections = ignoreUnknownConnections;
    }

    public CachedConnectionManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.value;
    }

    public void start(StartContext context) throws StartException {
        this.value = new CachedConnectionManagerImpl((TransactionIntegration)new NoopTransactionIntegration());
        this.value.setDebug(this.debug);
        this.value.setError(this.error);
        this.value.setIgnoreUnknownConnections(this.ignoreUnknownConnections);
        this.value.start();
        ConnectorLogger.ROOT_LOGGER.debugf("Started CcmService %s", context.getController().getName());
    }

    public void stop(StopContext context) {
        this.value.stop();
        ConnectorLogger.ROOT_LOGGER.debugf("Stopped CcmService %s", context.getController().getName());
    }

    private static class NoopTransactionIntegration
    implements TransactionIntegration {
        private NoopTransactionIntegration() {
        }

        public TransactionManager getTransactionManager() {
            return null;
        }

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return null;
        }

        public UserTransactionRegistry getUserTransactionRegistry() {
            return null;
        }

        public XAResourceRecoveryRegistry getRecoveryRegistry() {
            return null;
        }

        public XATerminator getXATerminator() {
            return null;
        }

        public XAResourceRecovery createXAResourceRecovery(ResourceAdapter rar, ActivationSpec as, String productName, String productVersion) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("createXAResourceRecovery");
        }

        public XAResourceRecovery createXAResourceRecovery(ManagedConnectionFactory mcf, Boolean pad, Boolean override, Boolean wrapXAResource, String recoverUserName, String recoverPassword, String recoverSecurityDomain, SubjectFactory subjectFactory, RecoveryPlugin plugin, XAResourceStatistics xastat) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("createXAResourceRecovery-Security");
        }

        public LocalXAResource createLocalXAResource(ConnectionManager cm, String productName, String productVersion, String jndiName, XAResourceStatistics xastat) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("createLocalXAResource");
        }

        public LocalXAResource createConnectableLocalXAResource(ConnectionManager cm, String productName, String productVersion, String jndiName, ConnectableResource cr, XAResourceStatistics xastat) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("createConnectableLocalXAResource");
        }

        public LocalXAResource createConnectableLocalXAResource(ConnectionManager cm, String productName, String productVersion, String jndiName, ManagedConnection mc, XAResourceStatistics xastat) {
            return null;
        }

        public XAResourceWrapper createXAResourceWrapper(XAResource xares, boolean pad, Boolean override, String productName, String productVersion, String jndiName, boolean firstResource, XAResourceStatistics xastat) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("createXAResourceWrapper");
        }

        public XAResourceWrapper createConnectableXAResourceWrapper(XAResource xares, boolean pad, Boolean override, String productName, String productVersion, String jndiName, ConnectableResource cr, XAResourceStatistics xastat) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("createConnectableXAResourceWrapper");
        }

        public XAResourceWrapper createConnectableXAResourceWrapper(XAResource xares, boolean pad, Boolean override, String productName, String productVersion, String jndiName, ManagedConnection mc, XAResourceStatistics xastat) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("createConnectableXAResourceWrapper");
        }

        public boolean isFirstResource(ManagedConnection mc) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("isFirstResource");
        }

        public boolean isConnectableResource(ManagedConnection mc) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("isConnectableResource");
        }

        public Object getIdentifier(Transaction tx) {
            throw ConnectorLogger.ROOT_LOGGER.noSupportedOperation("getIdentifier");
        }
    }
}

