/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.Map;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyContextPropagatingOnSingleCreateAction
implements BiFunction<Single, SingleObserver, SingleObserver> {
    public SingleObserver apply(Single t1, SingleObserver t2) throws Exception {
        return new ContextCapturerObserver(t2);
    }

    static final class ContextCapturerObserver<T>
    implements SingleObserver<T> {
        final Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap();
        final SingleObserver<T> actual;

        public ContextCapturerObserver(SingleObserver<T> actual) {
            this.actual = actual;
        }

        public void onError(Throwable e) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onError(e);
            ResteasyProviderFactory.removeContextDataLevel();
        }

        public void onSuccess(T value) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onSuccess(value);
            ResteasyProviderFactory.removeContextDataLevel();
        }

        public void onSubscribe(Disposable d) {
            ResteasyProviderFactory.pushContextDataMap(this.contextDataMap);
            this.actual.onSubscribe(d);
            ResteasyProviderFactory.removeContextDataLevel();
        }
    }
}

