/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.mgmt.HostInfo;
import org.jboss.dmr.ModelNode;

public class ReadMasterDomainModelUtil {
    public static final String DOMAIN_RESOURCE_ADDRESS = "domain-resource-address";
    public static final String DOMAIN_RESOURCE_MODEL = "domain-resource-model";
    public static final String DOMAIN_RESOURCE_PROPERTIES = "domain-resource-properties";
    public static final String ORDERED_CHILD_TYPES_PROPERTY = "ordered-child-types";
    private final Set<PathElement> newRootResources = new HashSet<PathElement>();
    private volatile List<ModelNode> describedResources;

    private ReadMasterDomainModelUtil() {
    }

    static ReadMasterDomainModelUtil readMasterDomainResourcesForInitialConnect(Transformers transformers, Transformers.TransformationInputs transformationInputs, Transformers.ResourceIgnoredTransformationRegistry ignoredTransformationRegistry, Resource domainRoot) throws OperationFailedException {
        Resource transformedResource = transformers.transformRootResource(transformationInputs, domainRoot, ignoredTransformationRegistry);
        ReadMasterDomainModelUtil util = new ReadMasterDomainModelUtil();
        util.describedResources = util.describeAsNodeList(PathAddress.EMPTY_ADDRESS, transformedResource, false);
        return util;
    }

    public List<ModelNode> getDescribedResources() {
        return this.describedResources;
    }

    private List<ModelNode> describeAsNodeList(PathAddress rootAddress, Resource resource, boolean isRuntimeChange) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        this.describe(rootAddress, resource, list, isRuntimeChange);
        return list;
    }

    private void describe(PathAddress base, Resource resource, List<ModelNode> nodes, boolean isRuntimeChange) {
        if (resource.isProxy() || resource.isRuntime()) {
            return;
        }
        if (base.size() >= 1 && base.getElement(0).getKey().equals("host")) {
            return;
        }
        if (base.size() == 1) {
            this.newRootResources.add(base.getLastElement());
        }
        ModelNode description = new ModelNode();
        description.get(DOMAIN_RESOURCE_ADDRESS).set(base.toModelNode());
        description.get(DOMAIN_RESOURCE_MODEL).set(resource.getModel());
        Set orderedChildren = resource.getOrderedChildTypes();
        if (orderedChildren.size() > 0) {
            ModelNode orderedChildTypes = description.get(new String[]{DOMAIN_RESOURCE_PROPERTIES, ORDERED_CHILD_TYPES_PROPERTY});
            for (String type : orderedChildren) {
                orderedChildTypes.add(type);
            }
        }
        nodes.add(description);
        for (String childType : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                this.describe(base.append(new PathElement[]{entry.getPathElement()}), (Resource)entry, nodes, isRuntimeChange);
            }
        }
    }

    static Resource createResourceFromDomainModelOp(ModelNode result, Set<String> extensions) {
        Resource root = Resource.Factory.create();
        for (ModelNode model : result.asList()) {
            PathElement element;
            PathAddress resourceAddress = PathAddress.pathAddress((ModelNode)model.require(DOMAIN_RESOURCE_ADDRESS));
            if (resourceAddress.size() == 1 && (element = resourceAddress.getElement(0)).getKey().equals("extension") && !extensions.contains(element.getValue())) {
                extensions.add(element.getValue());
            }
            Resource resource = root;
            ListIterator i = resourceAddress.iterator();
            if (!i.hasNext()) {
                resource.getModel().set(model.require(DOMAIN_RESOURCE_MODEL));
            }
            while (i.hasNext()) {
                PathElement e = (PathElement)i.next();
                if (resource.hasChild(e)) {
                    resource = resource.getChild(e);
                } else {
                    Resource nr;
                    if (model.hasDefined(new String[]{DOMAIN_RESOURCE_PROPERTIES, ORDERED_CHILD_TYPES_PROPERTY})) {
                        List list = model.get(new String[]{DOMAIN_RESOURCE_PROPERTIES, ORDERED_CHILD_TYPES_PROPERTY}).asList();
                        HashSet<String> orderedChildTypes = new HashSet<String>(list.size());
                        for (ModelNode type : list) {
                            orderedChildTypes.add(type.asString());
                        }
                        nr = Resource.Factory.create((boolean)false, orderedChildTypes);
                    } else {
                        nr = Resource.Factory.create();
                    }
                    resource.registerChild(e, nr);
                    resource = nr;
                }
                if (i.hasNext()) continue;
                resource.getModel().set(model.require(DOMAIN_RESOURCE_MODEL));
            }
        }
        return root;
    }

    public static RequiredConfigurationHolder populateHostResolutionContext(HostInfo hostInfo, Resource root, ExtensionRegistry extensionRegistry) {
        RequiredConfigurationHolder rc = new RequiredConfigurationHolder();
        for (IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo info : hostInfo.getServerConfigInfos()) {
            ReadMasterDomainModelUtil.processServerConfig(root, rc, info, extensionRegistry);
        }
        return rc;
    }

    static void processServerConfig(Resource root, RequiredConfigurationHolder requiredConfigurationHolder, IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo serverConfig, ExtensionRegistry extensionRegistry) {
        Set serverGroups = requiredConfigurationHolder.serverGroups;
        Set socketBindings = requiredConfigurationHolder.socketBindings;
        String sbg = serverConfig.getSocketBindingGroup();
        if (sbg != null && !socketBindings.contains(sbg)) {
            ReadMasterDomainModelUtil.processSocketBindingGroup(root, sbg, requiredConfigurationHolder);
        }
        String groupName = serverConfig.getServerGroup();
        PathElement groupElement = PathElement.pathElement((String)"server-group", (String)groupName);
        if (!serverGroups.contains(groupName) && root.hasChild(groupElement)) {
            Resource serverGroup = root.getChild(groupElement);
            ModelNode groupModel = serverGroup.getModel();
            serverGroups.add(groupName);
            if (groupModel.hasDefined("socket-binding-group")) {
                String socketBindingGroup = groupModel.get("socket-binding-group").asString();
                ReadMasterDomainModelUtil.processSocketBindingGroup(root, socketBindingGroup, requiredConfigurationHolder);
            }
            String profileName = groupModel.get("profile").asString();
            ReadMasterDomainModelUtil.processProfile(root, profileName, requiredConfigurationHolder, extensionRegistry);
        }
    }

    static void processHostModel(RequiredConfigurationHolder holder, Resource domain, Resource hostModel, ExtensionRegistry extensionRegistry) {
        Set serverGroups = holder.serverGroups;
        for (Resource.ResourceEntry entry : hostModel.getChildren("server-config")) {
            ModelNode model = entry.getModel();
            String serverGroup = model.get("group").asString();
            if (!serverGroups.contains(serverGroup)) {
                serverGroups.add(serverGroup);
            }
            if (model.hasDefined("socket-binding-group")) {
                String socketBindingGroup = model.get("socket-binding-group").asString();
                ReadMasterDomainModelUtil.processSocketBindingGroup(domain, socketBindingGroup, holder);
            }
            ReadMasterDomainModelUtil.processServerGroup(holder, serverGroup, domain, extensionRegistry);
        }
    }

    private static void processServerGroup(RequiredConfigurationHolder holder, String group, Resource domain, ExtensionRegistry extensionRegistry) {
        PathElement groupElement = PathElement.pathElement((String)"server-group", (String)group);
        if (!domain.hasChild(groupElement)) {
            return;
        }
        Resource serverGroup = domain.getChild(groupElement);
        ModelNode model = serverGroup.getModel();
        if (model.hasDefined("socket-binding-group")) {
            String socketBindingGroup = model.get("socket-binding-group").asString();
            ReadMasterDomainModelUtil.processSocketBindingGroup(domain, socketBindingGroup, holder);
        }
        String profile = model.get("profile").asString();
        ReadMasterDomainModelUtil.processProfile(domain, profile, holder, extensionRegistry);
    }

    private static void processProfile(Resource domain, String profile, RequiredConfigurationHolder holder, ExtensionRegistry extensionRegistry) {
        Set profiles = holder.profiles;
        Set extensions = holder.extensions;
        if (profiles.contains(profile)) {
            return;
        }
        profiles.add(profile);
        PathElement profileElement = PathElement.pathElement((String)"profile", (String)profile);
        if (domain.hasChild(profileElement)) {
            Resource resource = domain.getChild(profileElement);
            HashSet<String> subsystems = new HashSet<String>();
            Set availableExtensions = extensionRegistry.getExtensionModuleNames();
            for (Resource.ResourceEntry subsystem : resource.getChildren("subsystem")) {
                subsystems.add(subsystem.getName());
            }
            for (String extension : availableExtensions) {
                if (extensions.contains(extension)) continue;
                for (String subsystem : extensionRegistry.getAvailableSubsystems(extension).keySet()) {
                    if (!subsystems.contains(subsystem)) continue;
                    extensions.add(extension);
                }
            }
            if (resource.getModel().hasDefined("includes")) {
                for (ModelNode include : resource.getModel().get("includes").asList()) {
                    ReadMasterDomainModelUtil.processProfile(domain, include.asString(), holder, extensionRegistry);
                }
            }
        }
    }

    private static void processSocketBindingGroup(Resource domain, String socketBindingGroup, RequiredConfigurationHolder holder) {
        Resource resource;
        Set socketBindingGroups = holder.socketBindings;
        if (socketBindingGroups.contains(socketBindingGroup)) {
            return;
        }
        socketBindingGroups.add(socketBindingGroup);
        PathElement socketBindingGroupElement = PathElement.pathElement((String)"socket-binding-group", (String)socketBindingGroup);
        if (domain.hasChild(socketBindingGroupElement) && (resource = domain.getChild(socketBindingGroupElement)).getModel().hasDefined("includes")) {
            for (ModelNode include : resource.getModel().get("includes").asList()) {
                ReadMasterDomainModelUtil.processSocketBindingGroup(domain, include.asString(), holder);
            }
        }
        ControllerLogger.ROOT_LOGGER.tracef("Recorded need for socket-binding-group %s", (Object)socketBindingGroup);
    }

    public static Transformers.ResourceIgnoredTransformationRegistry createHostIgnoredRegistry(final HostInfo hostInfo, final RequiredConfigurationHolder rc) {
        return new Transformers.ResourceIgnoredTransformationRegistry(){

            public boolean isResourceTransformationIgnored(PathAddress address) {
                if (hostInfo.isResourceTransformationIgnored(address)) {
                    return true;
                }
                if (address.size() == 1 && hostInfo.isIgnoreUnaffectedConfig()) {
                    String type;
                    PathElement element = address.getElement(0);
                    switch (type = element.getKey()) {
                        case "extension": {
                            return false;
                        }
                        case "profile": {
                            if (rc.getProfiles().contains(element.getValue())) break;
                            return true;
                        }
                        case "server-group": {
                            if (rc.getServerGroups().contains(element.getValue())) break;
                            return true;
                        }
                        case "socket-binding-group": {
                            if (rc.getSocketBindings().contains(element.getValue())) break;
                            return true;
                        }
                    }
                }
                return false;
            }
        };
    }

    public static Transformers.ResourceIgnoredTransformationRegistry createServerIgnoredRegistry(final RequiredConfigurationHolder rc, final Transformers.ResourceIgnoredTransformationRegistry delegate) {
        return new Transformers.ResourceIgnoredTransformationRegistry(){

            public boolean isResourceTransformationIgnored(PathAddress address) {
                int length = address.size();
                if (length == 0) {
                    return false;
                }
                if (length >= 1) {
                    String type;
                    if (delegate.isResourceTransformationIgnored(address)) {
                        return true;
                    }
                    PathElement element = address.getElement(0);
                    switch (type = element.getKey()) {
                        case "extension": {
                            return false;
                        }
                        case "profile": {
                            if (!rc.getProfiles().contains(element.getValue())) break;
                            return false;
                        }
                        case "server-group": {
                            if (!rc.getServerGroups().contains(element.getValue())) break;
                            return false;
                        }
                        case "socket-binding-group": {
                            if (!rc.getSocketBindings().contains(element.getValue())) break;
                            return false;
                        }
                    }
                }
                return true;
            }
        };
    }

    public static class RequiredConfigurationHolder {
        private final Set<String> extensions = new HashSet<String>();
        private final Set<String> profiles = new HashSet<String>();
        private final Set<String> serverGroups = new HashSet<String>();
        private final Set<String> socketBindings = new HashSet<String>();

        public Set<String> getExtensions() {
            return this.extensions;
        }

        public Set<String> getProfiles() {
            return this.profiles;
        }

        public Set<String> getServerGroups() {
            return this.serverGroups;
        }

        public Set<String> getSocketBindings() {
            return this.socketBindings;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RequiredConfigurationHolder{");
            builder.append("extensions=").append(this.extensions);
            builder.append("profiles=").append(this.profiles).append(", ");
            builder.append("server-groups=").append(this.serverGroups).append(", ");
            builder.append("socket-bindings=").append(this.socketBindings).append("}");
            return builder.toString();
        }
    }
}

