/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.ProviderAttributeDefinition;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class ProviderDefinitions {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setAttributeGroup("configuration")).setAlternatives(new String[]{"configuration"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", FileAttributeDefinitions.RELATIVE_TO).setAttributeGroup("configuration")).setRequires(new String[]{"path"})).setRestartAllServices()).build();
    static final SimpleMapAttributeDefinition CONFIGURATION = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("configuration", ModelType.STRING, true).setAttributeGroup("configuration")).setAllowExpression(true)).setAlternatives(new String[]{"path", "argument"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ARGUMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("argument", ModelType.STRING, true).setAttributeGroup("configuration")).setRequires(new String[]{"class-names"})).setAlternatives(new String[]{"path", "configuration"})).setAllowExpression(true)).setRestartAllServices()).build();
    private static final AggregateComponentDefinition<Provider[]> AGGREGATE_PROVIDERS = AggregateComponentDefinition.create(Provider[].class, "aggregate-providers", "providers", Capabilities.PROVIDERS_RUNTIME_CAPABILITY, ProviderDefinitions::aggregate, false);
    static final ListAttributeDefinition REFERENCES = AGGREGATE_PROVIDERS.getReferencesAttribute();

    ProviderDefinitions() {
    }

    static AggregateComponentDefinition<Provider[]> getAggregateProvidersDefinition() {
        return AGGREGATE_PROVIDERS;
    }

    static ResourceDefinition getProviderLoaderDefinition(boolean serverOrHostController) {
        AttributeDefinition[] attributes = new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE, ClassLoadingAttributeDefinitions.CLASS_NAMES, PATH, RELATIVE_TO, ARGUMENT, CONFIGURATION};
        TrivialAddHandler<Provider[]> add = new TrivialAddHandler<Provider[]>(Provider[].class, attributes, Capabilities.PROVIDERS_RUNTIME_CAPABILITY){

            @Override
            protected boolean dependOnProviderRegistration() {
                return false;
            }

            @Override
            protected TrivialService.ValueSupplier<Provider[]> getValueSupplier(ServiceBuilder<Provider[]> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                Properties properties;
                String[] classNames;
                final String module = ClassLoadingAttributeDefinitions.MODULE.resolveModelAttribute(context, model).asStringOrNull();
                ModelNode classNamesNode = ClassLoadingAttributeDefinitions.CLASS_NAMES.resolveModelAttribute(context, model);
                if (classNamesNode.isDefined()) {
                    List values = classNamesNode.asList();
                    classNames = new String[values.size()];
                    for (int i = 0; i < classNames.length; ++i) {
                        classNames[i] = ((ModelNode)values.get(i)).asString();
                    }
                } else {
                    classNames = null;
                }
                final String path = PATH.resolveModelAttribute(context, model).asStringOrNull();
                final String relativeTo = RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
                final String argument = ARGUMENT.resolveModelAttribute(context, model).asStringOrNull();
                ModelNode configuration = CONFIGURATION.resolveModelAttribute(context, model);
                if (configuration.isDefined()) {
                    properties = new Properties();
                    for (String s : configuration.keys()) {
                        properties.setProperty(s, configuration.require(s).asString());
                    }
                } else {
                    properties = null;
                }
                final InjectedValue pathManager = new InjectedValue();
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                return new TrivialService.ValueSupplier<Provider[]>(){
                    private volatile PathManager.Callback.Handle handle = null;

                    @Override
                    public Provider[] get() throws StartException {
                        Supplier configSupplier = properties != null ? ProviderDefinitions.getConfigurationSupplier(properties) : (path != null ? ProviderDefinitions.getConfigurationSupplier(this.resolveConfigLocation()) : null);
                        try {
                            ArrayList<Object> loadedProviders;
                            ArrayList<ExceptionConsumer> deferred = new ArrayList<ExceptionConsumer>();
                            ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(module));
                            if (classNames != null) {
                                loadedProviders = new ArrayList(classNames.length);
                                for (String className : classNames) {
                                    Constructor constructor;
                                    Class<Provider> providerClazz = classLoader.loadClass(className).asSubclass(Provider.class);
                                    if (argument != null) {
                                        constructor = SecurityActions.doPrivileged(() -> providerClazz.getConstructor(String.class));
                                        loadedProviders.add(constructor.newInstance(argument));
                                        continue;
                                    }
                                    if (configSupplier != null) {
                                        try {
                                            constructor = SecurityActions.doPrivileged(() -> providerClazz.getConstructor(InputStream.class));
                                            loadedProviders.add(constructor.newInstance(configSupplier.get()));
                                        }
                                        catch (NoSuchMethodException ignored) {
                                            Provider provider = providerClazz.newInstance();
                                            loadedProviders.add(provider);
                                            deferred.add(provider::load);
                                        }
                                        continue;
                                    }
                                    loadedProviders.add(providerClazz.newInstance());
                                }
                            } else {
                                loadedProviders = new ArrayList<Object>();
                                ServiceLoader<Provider> loader = ServiceLoader.load(Provider.class, classLoader);
                                Iterator<Provider> iterator = loader.iterator();
                                while (true) {
                                    try {
                                        while (iterator.hasNext()) {
                                            Provider p = iterator.next();
                                            if (configSupplier != null) {
                                                deferred.add(p::load);
                                            }
                                            loadedProviders.add(p);
                                        }
                                    }
                                    catch (RuntimeException | ServiceConfigurationError e) {
                                        ElytronSubsystemMessages.ROOT_LOGGER.tracef(e, "Failed to initialize a security provider", new Object[0]);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            for (ExceptionConsumer current : deferred) {
                                current.accept(configSupplier.get());
                            }
                            Object[] providers = loadedProviders.toArray(new Provider[loadedProviders.size()]);
                            if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                                ElytronSubsystemMessages.ROOT_LOGGER.tracef("Loaded providers %s", Arrays.toString(providers));
                            }
                            return providers;
                        }
                        catch (PrivilegedActionException e) {
                            throw new StartException(e.getCause());
                        }
                        catch (Exception e) {
                            throw new StartException((Throwable)e);
                        }
                    }

                    @Override
                    public void dispose() {
                        if (this.handle != null) {
                            this.handle.remove();
                            this.handle = null;
                        }
                    }

                    private File resolveConfigLocation() {
                        File resolvedPath;
                        if (relativeTo != null) {
                            PathManager pm = (PathManager)pathManager.getValue();
                            resolvedPath = new File(pm.resolveRelativePathEntry(path, relativeTo));
                            this.handle = pm.registerCallback(relativeTo, new PathManager.Callback(){

                                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                                    if (!eventContext.isResourceServiceRestartAllowed()) {
                                        eventContext.reloadRequired();
                                    }
                                }

                                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                                }
                            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
                        } else {
                            resolvedPath = new File(path);
                        }
                        return resolvedPath;
                    }
                };
            }
        };
        TrivialResourceDefinition.Builder builder = TrivialResourceDefinition.builder().setPathKey("provider-loader").setAddHandler(add).setAttributes(attributes).setRuntimeCapabilities(Capabilities.PROVIDERS_RUNTIME_CAPABILITY);
        if (serverOrHostController) {
            builder.addReadOnlyAttribute((AttributeDefinition)ProviderAttributeDefinition.LOADED_PROVIDERS, new LoadedProvidersAttributeHandler());
        }
        return builder.build();
    }

    private static Provider[] aggregate(Provider[] ... providers) {
        int length = 0;
        for (Provider[] current : providers) {
            length += current.length;
        }
        Provider[] combined = new Provider[length];
        int startPos = 0;
        for (Provider[] current : providers) {
            System.arraycopy(current, 0, combined, startPos, current.length);
            startPos += current.length;
        }
        return combined;
    }

    private static Supplier<InputStream> getConfigurationSupplier(File location) throws StartException {
        try {
            byte[] configuration = Files.readAllBytes(location.toPath());
            return () -> new ByteArrayInputStream(configuration);
        }
        catch (IOException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    private static Supplier<InputStream> getConfigurationSupplier(Properties properties) throws StartException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            properties.store(baos, "");
            byte[] configuration = baos.toByteArray();
            return () -> new ByteArrayInputStream(configuration);
        }
        catch (IOException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    private static class LoadedProvidersAttributeHandler
    extends ElytronRuntimeOnlyHandler {
        private LoadedProvidersAttributeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName providerLoaderName = context.getCapabilityServiceName("org.wildfly.security.providers", context.getCurrentAddressValue(), Provider[].class);
            ServiceController<Provider[]> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), providerLoaderName, Provider[].class);
            if (serviceContainer.getState() != ServiceController.State.UP) {
                return;
            }
            ProviderAttributeDefinition.populateProviders(context.getResult(), (Provider[])serviceContainer.getValue());
        }
    }
}

