/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.lang.reflect.Field;
import org.jacorb.ir.Contained;
import org.jacorb.ir.IDLType;
import org.jacorb.ir.TypeCodeUtil;
import org.jacorb.orb.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ConstantDefOperations;
import org.omg.CORBA.ConstantDescription;
import org.omg.CORBA.ConstantDescriptionHelper;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.ContainedPackage.Description;
import org.omg.CORBA.Container;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.Repository;
import org.omg.CORBA.TypeCode;
import org.omg.PortableServer.POA;
import org.slf4j.Logger;

public class ConstantDef
extends Contained
implements ConstantDefOperations {
    private Field field;
    private TypeCode typeCode;
    private org.omg.CORBA.IDLType type_def;
    private Any value;
    private ConstantDescription description;
    private boolean defined = false;
    org.omg.CORBA.Contained myContainer;
    private Logger logger;
    private POA poa;

    public ConstantDef(Field field, Container _defined_in, Repository _containing_repository, Logger logger, POA poa) {
        this.logger = logger;
        this.poa = poa;
        this.def_kind = DefinitionKind.dk_Constant;
        this.containing_repository = _containing_repository;
        this.defined_in = _defined_in;
        this.field = field;
        this.name(field.getName());
        this.version = "1.0";
        this.myContainer = ContainedHelper.narrow(this.defined_in);
        if (this.myContainer == null) {
            throw new INTF_REPOS("Constant should be in an interface!");
        }
        String def_in_id = this.myContainer.id();
        this.id = def_in_id.substring(0, def_in_id.lastIndexOf(":")) + "/" + this.name + ":" + this.version;
        this.absolute_name = this.myContainer.absolute_name() + "::" + this.name;
        try {
            this.typeCode = TypeCodeUtil.getTypeCode(field.getType(), null, this.logger);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("New ConstantDef " + this.absolute_name());
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.logger.error("Error: ConstantDef " + this.absolute_name() + " could not be created!", cnfe);
        }
    }

    public ConstantDef(Class c, Container _defined_in, Repository ir, Logger logger, POA poa) {
        this.logger = logger;
        this.poa = poa;
        this.def_kind = DefinitionKind.dk_Constant;
        this.containing_repository = ir;
        this.defined_in = _defined_in;
        this.myContainer = ContainedHelper.narrow(this.defined_in);
        try {
            this.field = c.getDeclaredField("value");
            this.version = "1.0";
            String classId = c.getName();
            if (classId.indexOf(46) > 0) {
                this.name(classId.substring(classId.lastIndexOf(46) + 1));
                String path = classId.substring(0, classId.lastIndexOf(46));
                this.id = "IDL:" + path.replace('.', '/') + "/" + this.name + ":" + this.version;
                this.absolute_name = this.myContainer.absolute_name() + "::" + this.name;
            } else {
                this.name(classId);
                this.defined_in = this.containing_repository;
                this.id = "IDL:" + this.name + ":" + this.version;
                this.absolute_name = "::" + this.name;
            }
            this.typeCode = TypeCodeUtil.getTypeCode(this.field.getType(), null, this.logger);
        }
        catch (Exception e) {
            logger.debug("unexpected exception", e);
            throw new INTF_REPOS(2600, CompletionStatus.COMPLETED_NO);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New ConstantDef " + this.absolute_name());
        }
    }

    @Override
    void define() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ConstantDef " + this.absolute_name() + " defining.");
        }
        this.value = (Any)this.orb.create_any();
        this.type_def = IDLType.create(this.typeCode, this.containing_repository, this.logger, this.poa);
        if (this.typeCode == null) {
            throw new INTF_REPOS("typeCode is null!");
        }
        if (this.type_def == null) {
            throw new INTF_REPOS("type_def is null!");
        }
        try {
            this.value.insert(this.typeCode, this.field.get(null));
        }
        catch (Exception e) {
            this.logger.debug("unexpected exception", e);
        }
        this.defined = true;
    }

    @Override
    public TypeCode type() {
        return this.typeCode;
    }

    @Override
    public org.omg.CORBA.Any value() {
        return this.value;
    }

    @Override
    public void value(org.omg.CORBA.Any _value) {
        this.value = (Any)_value;
    }

    @Override
    public org.omg.CORBA.IDLType type_def() {
        return this.type_def;
    }

    @Override
    public void type_def(org.omg.CORBA.IDLType a) {
        this.type_def = a;
    }

    ConstantDescription describe_constant() {
        if (!this.defined) {
            throw new INTF_REPOS("ConstantDef " + this.name + " not defined!");
        }
        if (this.description == null) {
            String def_in = null;
            def_in = this.myContainer == null ? "Global" : this.myContainer.id();
            this.description = new ConstantDescription(this.name, this.id, def_in, this.version, this.typeCode, this.value);
        }
        return this.description;
    }

    @Override
    public Description describe() {
        org.omg.CORBA.Any a = this.orb.create_any();
        ConstantDescriptionHelper.insert(a, this.describe_constant());
        return new Description(DefinitionKind.dk_Constant, a);
    }

    @Override
    public void destroy() {
    }
}

