/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.slf4j.Logger;

public class ParsedIOR {
    private Profile effectiveProfile = null;
    private final List<Profile> profiles = new ArrayList<Profile>();
    private TaggedComponentList components = new TaggedComponentList();
    private ProfileSelector profileSelector;
    protected boolean endianness = false;
    private String ior_str = null;
    private IOR ior = null;
    private final ORB orb;
    private CodeSetComponentInfo cs_info = null;
    private Integer orbTypeId = null;
    private final Logger logger;
    private String iorTypeIdName = null;
    private boolean isImRIor = false;
    private boolean isNameServiceIor = false;
    private String corbaNameOriginalObjRef = null;

    public static IOR createObjectIOR(Profile profile) {
        return ParsedIOR.createObjectIOR((ORBSingleton)org.omg.CORBA.ORBSingleton.init(), profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOR createObjectIOR(ORBSingleton orb, Profile profile) {
        String repId = "IDL:omg.org/CORBA/Object:1.0";
        TaggedComponentList components = new TaggedComponentList();
        CDROutputStream out = new CDROutputStream(orb);
        try {
            out.beginEncapsulatedArray();
            out.write_long(1245790976);
            components.addComponent(new TaggedComponent(0, out.getBufferCopy()));
        }
        finally {
            out.close();
        }
        ArrayList<TaggedProfile> taggedProfileList = new ArrayList<TaggedProfile>();
        TaggedProfileHolder tp = new TaggedProfileHolder();
        TaggedComponentSeqHolder tcs = new TaggedComponentSeqHolder();
        tcs.value = components.asArray();
        profile.marshal(tp, tcs);
        taggedProfileList.add(tp.value);
        TaggedProfile[] tps = new TaggedProfile[taggedProfileList.size()];
        taggedProfileList.toArray(tps);
        return new IOR(repId, tps);
    }

    public static IOR createObjectIOR(Profile[] profiles) {
        return ParsedIOR.createObjectIOR((ORBSingleton)org.omg.CORBA.ORBSingleton.init(), profiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOR createObjectIOR(ORBSingleton orb, Profile[] profiles) {
        String repId = "IDL:omg.org/CORBA/Object:1.0";
        ArrayList<TaggedProfile> taggedProfileList = new ArrayList<TaggedProfile>();
        for (int count = 0; count < profiles.length; ++count) {
            if (profiles[count] == null) continue;
            TaggedComponentList components = new TaggedComponentList();
            CDROutputStream out = new CDROutputStream(orb);
            try {
                out.beginEncapsulatedArray();
                out.write_long(1245790976);
                components.addComponent(new TaggedComponent(0, out.getBufferCopy()));
            }
            finally {
                out.close();
            }
            TaggedProfileHolder tp = new TaggedProfileHolder();
            TaggedComponentSeqHolder tcs = new TaggedComponentSeqHolder();
            tcs.value = components.asArray();
            profiles[count].marshal(tp, tcs);
            taggedProfileList.add(tp.value);
        }
        TaggedProfile[] tps = new TaggedProfile[taggedProfileList.size()];
        taggedProfileList.toArray(tps);
        return new IOR(repId, tps);
    }

    public static byte[] extractObjectKey(TargetAddress addr, ORB orb) {
        TaggedProfile tp = null;
        switch (addr.discriminator()) {
            case 0: {
                return addr.object_key();
            }
            case 1: {
                tp = new TaggedProfile(addr.profile().tag, addr.profile().profile_data);
                break;
            }
            case 2: {
                IORAddressingInfo info = addr.ior();
                tp = new TaggedProfile(info.ior.profiles[info.selected_profile_index].tag, info.ior.profiles[info.selected_profile_index].profile_data);
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid value for TargetAddress discriminator");
            }
        }
        TaggedProfileHolder profile = new TaggedProfileHolder(tp);
        Factories profileFactory = orb.getTransportManager().getFactories(tp.tag);
        if (profileFactory != null) {
            return profileFactory.demarshal_profile(profile, new TaggedComponentSeqHolder()).get_object_key();
        }
        return null;
    }

    public String getCodebaseComponent() {
        return this.getStringComponent(25);
    }

    private ParsedIOR(ORB orb) {
        this.orb = orb;
        this.logger = this.orb.getConfiguration().getLogger("org.jacorb.orb.parsedior");
    }

    public ParsedIOR(ORB orb, String object_reference) throws IllegalArgumentException {
        this(orb);
        this.parse(object_reference);
    }

    public ParsedIOR(ORB orb, IOR ior) {
        this(orb);
        this.decode(ior);
    }

    public boolean equals(java.lang.Object other) {
        if (other == null) {
            return false;
        }
        return other instanceof ParsedIOR && ((ParsedIOR)other).getIORString().equals(this.getIORString()) && this.effectiveProfile != null && this.effectiveProfile.is_match(((ParsedIOR)other).effectiveProfile);
    }

    public int hashCode() {
        return this.getIORString().hashCode();
    }

    private void decode(IOR _ior) {
        block3: for (int i = 0; i < _ior.profiles.length; ++i) {
            int tag = _ior.profiles[i].tag;
            switch (tag) {
                case 1: {
                    this.components = new TaggedComponentList(_ior.profiles[i].profile_data);
                    continue block3;
                }
                default: {
                    Factories factories = this.orb.getTransportManager().getFactories(tag);
                    if (factories != null) {
                        TaggedProfileHolder tp = new TaggedProfileHolder(_ior.profiles[i]);
                        this.profiles.add(factories.demarshal_profile(tp, new TaggedComponentSeqHolder()));
                        continue block3;
                    }
                    if (!this.logger.isDebugEnabled()) continue block3;
                    this.logger.debug("No transport available for profile tag " + tag);
                    continue block3;
                }
            }
        }
        this.ior = _ior;
        this.setIorTypeIdName();
        this.setEffectiveProfile();
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs_info;
    }

    public Integer getORBTypeId() {
        return this.orbTypeId;
    }

    public IOR getIOR() {
        return this.ior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIORString() {
        if (this.ior_str == null) {
            try {
                CDROutputStream out = new CDROutputStream(this.orb);
                try {
                    out.beginEncapsulatedArray();
                    IORHelper.write(out, this.ior);
                    byte[] bytes = out.getBufferCopy();
                    StringBuffer sb = new StringBuffer("IOR:");
                    for (int j = 0; j < bytes.length; ++j) {
                        ObjectUtil.appendHex(sb, bytes[j] >> 4 & 0xF);
                        ObjectUtil.appendHex(sb, bytes[j] & 0xF);
                    }
                    this.ior_str = sb.toString();
                }
                finally {
                    out.close();
                }
            }
            catch (Exception e) {
                this.logger.error("Error in building IIOP-IOR", e);
                throw new UNKNOWN("Error in building IIOP-IOR");
            }
        }
        return this.ior_str;
    }

    public byte[] get_object_key() {
        return this.effectiveProfile.get_object_key();
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public Profile getEffectiveProfile() {
        return this.effectiveProfile;
    }

    private void setEffectiveProfile() {
        this.effectiveProfile = this.getProfileSelector().selectProfile(this.profiles, this.orb.getClientConnectionManager());
        if (this.effectiveProfile != null) {
            this.cs_info = (CodeSetComponentInfo)this.getComponent(1, CodeSetComponentInfoHelper.class);
            this.orbTypeId = this.getLongComponent(0);
        }
    }

    public Profile getNextEffectiveProfile() {
        Profile lastProfile = this.effectiveProfile;
        this.effectiveProfile = this.getProfileSelector().selectNextProfile(this.profiles, lastProfile);
        if (this.effectiveProfile != null && this.effectiveProfile != lastProfile) {
            this.cs_info = (CodeSetComponentInfo)this.getComponent(1, CodeSetComponentInfoHelper.class);
            this.orbTypeId = this.getLongComponent(0);
        }
        return this.effectiveProfile;
    }

    private void setIorTypeIdName() {
        String iorTypeId = this.getTypeId();
        int colon = iorTypeId.lastIndexOf(":");
        if (colon > 0) {
            this.iorTypeIdName = iorTypeId.substring(0, colon);
        }
        if (this.iorTypeIdName != null) {
            if (this.iorTypeIdName.equals("IDL:org/jacorb/imr/ImplementationRepository")) {
                this.isImRIor = true;
            } else if (this.iorTypeIdName.equals("IDL:ImplementationRepository/Locator")) {
                this.isImRIor = true;
            } else if (this.iorTypeIdName.equals("IDL:omg.org/CosNaming/NamingContextExt")) {
                this.isNameServiceIor = true;
            }
        }
        if (!this.isImRIor && !this.isNameServiceIor) {
            for (Profile p : this.profiles) {
                this.iorTypeIdName = CorbaLoc.parseKey(p.get_object_key());
                if (this.iorTypeIdName == null) continue;
                if (this.iorTypeIdName.lastIndexOf("NameService") >= 0) {
                    this.isNameServiceIor = true;
                    continue;
                }
                if (this.iorTypeIdName.lastIndexOf("ImplementationRepository") < 0 && this.iorTypeIdName.lastIndexOf("ImplRepo_Service") < 0 && this.iorTypeIdName.lastIndexOf("the_ImR/ImRPOA.ImR") < 0) continue;
                this.isImRIor = true;
            }
        }
    }

    public String getTypeIdName() {
        return this.iorTypeIdName;
    }

    public boolean isImRIor() {
        return this.isImRIor;
    }

    public boolean isNameServiceIor() {
        return this.isNameServiceIor;
    }

    public boolean useCorbaName() {
        return this.corbaNameOriginalObjRef != null;
    }

    public String getCorbaNameOriginalObjRef() {
        return this.corbaNameOriginalObjRef;
    }

    public String getTypeId() {
        return this.ior.type_id;
    }

    public String getIDString() {
        StringBuffer sb = new StringBuffer(this.getTypeId());
        sb.append(":");
        byte[] bytes = this.get_object_key();
        for (int j = 0; j < bytes.length; ++j) {
            ObjectUtil.appendHex(sb, bytes[j] >> 4 & 0xF);
            ObjectUtil.appendHex(sb, bytes[j] & 0xF);
        }
        return sb.toString();
    }

    public TaggedComponentList getMultipleComponents() {
        return this.components;
    }

    public boolean isNull() {
        return ParsedIOR.isNull(this.ior);
    }

    public static boolean isNull(IOR ior) {
        return "".equals(ior.type_id) && ior.profiles.length == 0;
    }

    private void parse(String object_reference) throws IllegalArgumentException {
        if (object_reference == null) {
            throw new IllegalArgumentException("Null object reference");
        }
        if (object_reference.startsWith("IOR:")) {
            this.parse_stringified_ior(object_reference);
        } else if (object_reference.startsWith("corbaloc:")) {
            this.parse_corbaloc(object_reference);
        } else if (object_reference.startsWith("corbaname:")) {
            this.parse_corbaname(object_reference);
        } else if (object_reference.startsWith("resource:")) {
            this.parse_resource(object_reference.substring(9));
        } else if (object_reference.startsWith("jndi:")) {
            this.parse_jndi(object_reference.substring(5));
        } else {
            String content;
            block15: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to resolve URL/IOR from: " + object_reference);
                }
                content = null;
                try {
                    content = ObjectUtil.readURL(object_reference);
                }
                catch (IOException ioe) {
                    if (!this.logger.isDebugEnabled()) break block15;
                    this.logger.debug("Error reading IOR/URL: ", ioe);
                }
            }
            if (content == null) {
                throw new BAD_PARAM("Invalid or unreadable URL/IOR: " + object_reference);
            }
            this.parse(content);
        }
        this.ior_str = this.getIORString();
    }

    private void parse_stringified_ior(String object_reference) {
        int length = object_reference.length();
        int cnt = (length - 4) / 2;
        if (length % 2 != 0) {
            throw new BAD_PARAM("Odd number of characters within object reference");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int j = 0; j < cnt; ++j) {
            int i1;
            char c1 = object_reference.charAt(j * 2 + 4);
            char c2 = object_reference.charAt(j * 2 + 5);
            int n = c1 >= 'a' ? 10 + c1 - 97 : (i1 = c1 >= 'A' ? 10 + c1 - 65 : c1 - 48);
            int i2 = c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48);
            bos.write(i1 * 16 + i2);
        }
        CDRInputStream in_ = this.orb == null ? new CDRInputStream(org.omg.CORBA.ORBSingleton.init(), bos.toByteArray()) : new CDRInputStream(this.orb, bos.toByteArray());
        this.endianness = in_.read_boolean();
        if (this.endianness) {
            in_.setLittleEndian(true);
        }
        try {
            IOR _ior = IORHelper.read(in_);
            this.decode(_ior);
        }
        catch (MARSHAL e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid IOR", e);
            }
            throw new BAD_PARAM("Invalid IOR " + e, 10, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parse_corbaloc(String object_reference) {
        CorbaLoc corbaLoc = new CorbaLoc(this.orb, object_reference);
        IOR ior = null;
        if (corbaLoc.rir()) {
            try {
                Object obj = this.orb.resolve_initial_references(corbaLoc.getKeyString());
                if (obj == null) {
                    throw new IllegalArgumentException("Unable to resolve reference for " + corbaLoc.getKeyString());
                }
                ior = ((Delegate)((ObjectImpl)obj)._get_delegate()).getIOR();
            }
            catch (Exception e) {
                this.logger.error("Invalid corbaloc URL " + corbaLoc.getKeyString(), e);
                throw new IllegalArgumentException("Invalid corbaloc: URL");
            }
        } else {
            if (corbaLoc.profileList.length == 0) {
                return;
            }
            for (int count = 0; count < corbaLoc.profileList.length; ++count) {
                corbaLoc.profileList[count].set_object_key(corbaLoc.getKey());
            }
            ior = ParsedIOR.createObjectIOR((ORBSingleton)this.orb, corbaLoc.profileList);
        }
        this.decode(ior);
    }

    private void parse_corbaname(String object_reference) {
        String corbaloc = "corbaloc:";
        String name = "";
        int colon = object_reference.indexOf(58);
        int pound = object_reference.indexOf(35);
        this.corbaNameOriginalObjRef = object_reference;
        if (pound == -1) {
            corbaloc = corbaloc + object_reference.substring(colon + 1);
        } else {
            corbaloc = corbaloc + object_reference.substring(colon + 1, pound);
            name = object_reference.substring(pound + 1);
        }
        if (corbaloc.indexOf(47) == -1) {
            corbaloc = corbaloc + "/NameService";
        }
        try {
            NamingContextExt n = NamingContextExtHelper.narrow(this.orb.string_to_object(corbaloc));
            IOR ior = null;
            if (name.length() > 0) {
                Object target = n.resolve_str(name);
                ior = ((Delegate)((ObjectImpl)target)._get_delegate()).getIOR();
            } else {
                ior = ((Delegate)((ObjectImpl)((java.lang.Object)n))._get_delegate()).getIOR();
            }
            this.decode(ior);
        }
        catch (Exception e) {
            this.logger.error("Invalid object reference", e);
            throw new IllegalArgumentException("Invalid object reference: " + object_reference);
        }
    }

    private void parse_resource(String resourceName) {
        URL url;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to resolve URL/IOR from resource: " + resourceName);
        }
        if ((url = ObjectUtil.getResource(resourceName)) == null) {
            throw new IllegalArgumentException("Failed to get resource: " + resourceName);
        }
        try {
            String content = ObjectUtil.readURL(url.toString());
            this.parse(content);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read resource: " + resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse_jndi(String jndiName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to resolve JNDI/IOR from name: " + jndiName);
        }
        try {
            Class<?> initialContextClazz = Class.forName("javax.naming.InitialContext");
            java.lang.Object initialContext = initialContextClazz.newInstance();
            try {
                Class[] types = new Class[]{String.class};
                java.lang.Object[] params = new java.lang.Object[]{jndiName};
                Method method = initialContextClazz.getMethod("lookup", types);
                java.lang.Object result = method.invoke(initialContext, params);
                if (result == null) {
                    throw new IllegalArgumentException("Null JNDI/IOR: " + jndiName);
                }
                this.parse(result.toString());
            }
            finally {
                Method closeMethod = initialContextClazz.getMethod("close", null);
                closeMethod.invoke(initialContext, (java.lang.Object[])null);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to lookup JNDI/IOR: " + jndiName + ": " + ex);
        }
    }

    private java.lang.Object getComponent(int tag, Class helper) {
        java.lang.Object result = null;
        if (this.effectiveProfile instanceof ProfileBase && ((ProfileBase)this.effectiveProfile).getComponents() != null) {
            result = ((ProfileBase)this.effectiveProfile).getComponent(tag, helper);
        }
        if (result != null) {
            return result;
        }
        return this.components.getComponent(tag, helper);
    }

    private Integer getLongComponent(int tag) {
        return (Integer)this.getComponent(tag, LongHelper.class);
    }

    private String getStringComponent(int tag) {
        return (String)this.getComponent(tag, StringHelper.class);
    }

    public static boolean isParsableProtocol(String check) {
        return check.startsWith("IOR:") || check.startsWith("corbaloc:") || check.startsWith("corbaname:") || check.startsWith("resource:") || check.startsWith("jndi:") || check.startsWith("file:") || check.startsWith("http:");
    }

    public void setProfileSelector(ProfileSelector sel) {
        this.profileSelector = sel;
        this.setEffectiveProfile();
    }

    private ProfileSelector getProfileSelector() {
        if (this.profileSelector == null) {
            return this.orb.getTransportManager().getProfileSelector();
        }
        return this.profileSelector;
    }

    static class StringHelper {
        StringHelper() {
        }

        public static String read(InputStream in) {
            return in.read_string();
        }
    }

    static class LongHelper {
        LongHelper() {
        }

        public static Integer read(InputStream in) {
            return in.read_long();
        }
    }
}

