/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.nio.NIOConnection;
import org.jacorb.util.SelectorRequest;
import org.jacorb.util.SelectorRequestCallback;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.Profile;

public class ClientNIOConnection
extends NIOConnection
implements Configurable {
    private int noOfRetries = 5;
    private int retryInterval = 0;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.noOfRetries = configuration.getAttributeAsInteger("jacorb.retries", 5);
        this.retryInterval = configuration.getAttributeAsInteger("jacorb.retry_interval", 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connect(Profile server_profile, long timeout) {
        long nanoDeadline;
        long l = nanoDeadline = timeout == 0L ? Long.MAX_VALUE : System.nanoTime() + timeout * 1000000L;
        if (!this.is_connected()) {
            if (!(server_profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + server_profile.getClass());
            }
            this.profile = (IIOPProfile)server_profile;
            if (this.isDebugEnabled) {
                this.logger.debug("Trying to establish an NIO client connection with timeout " + timeout);
            }
            int retryCount = 0;
            for (retryCount = 0; retryCount < this.noOfRetries; ++retryCount) {
                try {
                    SocketChannel myChannel;
                    this.connectChannel(nanoDeadline);
                    ClientNIOConnection clientNIOConnection = this;
                    synchronized (clientNIOConnection) {
                        myChannel = this.channel;
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + myChannel.socket().getLocalPort() + (timeout == 0L ? "" : " Timeout: " + timeout));
                    }
                    clientNIOConnection = this;
                    synchronized (clientNIOConnection) {
                        this.failedWriteAttempts = 0;
                    }
                    this.setConnected(true);
                    return;
                }
                catch (TIMEOUT ex) {
                    this.profile = null;
                    throw ex;
                }
                catch (IOException ex) {
                    if (this.isDebugEnabled) {
                        this.logger.debug("Exception connecting {}", (Object)ex.getMessage(), (Object)ex);
                    }
                    if (retryCount >= this.noOfRetries - 1) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Retrying attempt " + retryCount + " to connect to " + this.connection_info);
                    }
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException i) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (retryCount == this.noOfRetries) {
                this.profile = null;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        SocketChannel myChannel;
        if (!this.is_connected()) {
            return;
        }
        ClientNIOConnection clientNIOConnection = this;
        synchronized (clientNIOConnection) {
            myChannel = this.channel;
        }
        try {
            if (myChannel != null) {
                myChannel.close();
            }
            this.setConnected(false);
            if (this.in_stream != null) {
                this.in_stream.close();
            }
            if (this.out_stream != null) {
                this.out_stream.close();
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
            }
        }
        catch (IOException ex) {
            if (this.isDebugEnabled) {
                this.logger.debug("Exception when closing the channel", ex);
            }
            throw this.handleCommFailure(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connectChannel(long nanoDeadline) throws IOException {
        ArrayList<ProtocolAddressBase> addressList = new ArrayList<ProtocolAddressBase>();
        addressList.add(((IIOPProfile)this.profile).getAddress());
        addressList.addAll(((IIOPProfile)this.profile).getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        Exception exception = null;
        while (addressIterator.hasNext()) {
            SocketChannel myChannel;
            block14: {
                myChannel = null;
                try {
                    myChannel = SocketChannel.open();
                    myChannel.configureBlocking(false);
                    IIOPAddress address = (IIOPAddress)addressIterator.next();
                    String ipAddress = address.getIP();
                    int port = address.getPort();
                    this.connection_info = ipAddress.indexOf(58) == -1 ? ipAddress + ":" + port : "[" + ipAddress + "]:" + port;
                    if (this.isDebugEnabled) {
                        this.logger.debug("Trying to connect to " + this.connection_info);
                    }
                    myChannel.connect(new InetSocketAddress(ipAddress, port));
                    SelectorRequest request = new SelectorRequest(SelectorRequest.Type.CONNECT, myChannel, new ConnectCallback(), nanoDeadline);
                    this.selectorManager.add(request);
                    request.waitOnCompletion(nanoDeadline);
                    if (request.status == SelectorRequest.Status.IOERROR) {
                        throw new TRANSIENT("unable to connect");
                    }
                    if (request.status == SelectorRequest.Status.EXPIRED || !request.isFinalized()) {
                        throw new TIMEOUT("connection timeout expired");
                    }
                    if (request.status == SelectorRequest.Status.FAILED || request.status == SelectorRequest.Status.SHUTDOWN || request.status == SelectorRequest.Status.CLOSED) {
                        throw new IOException("SelectorManager is corrupted");
                    }
                    if (!myChannel.isConnected()) break block14;
                    ClientNIOConnection clientNIOConnection = this;
                    synchronized (clientNIOConnection) {
                        this.channel = myChannel;
                    }
                    exception = null;
                    break;
                }
                catch (Exception ex) {
                    exception = ex;
                }
            }
            if (myChannel == null) continue;
            myChannel.close();
        }
        if (exception != null) {
            if (exception instanceof TIMEOUT) {
                throw (TIMEOUT)exception;
            }
            if (exception instanceof TRANSIENT) {
                throw (TRANSIENT)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Unexpected exception occured: " + exception.toString());
        }
    }

    private class ConnectCallback
    extends SelectorRequestCallback {
        private ConnectCallback() {
        }

        @Override
        public boolean call(SelectorRequest request) {
            SocketChannel myChannel = request.channel;
            if (ClientNIOConnection.this.isDebugEnabled) {
                ClientNIOConnection.this.logger.debug("Connect callback. Request status: " + request.status.toString());
            }
            try {
                if (request.status == SelectorRequest.Status.READY) {
                    myChannel.finishConnect();
                    if (ClientNIOConnection.this.isDebugEnabled) {
                        ClientNIOConnection.this.logger.debug("Connection establishment finished");
                    }
                }
            }
            catch (Exception ex) {
                request.setStatus(SelectorRequest.Status.IOERROR);
                ClientNIOConnection.this.logger.error("Exception while finishing connection {} ", (Object)ex.getMessage(), (Object)ex);
            }
            return false;
        }
    }
}

