/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;

public class SwingUncaughtExceptionHandlerItem
extends JPanel {
    private final JScrollPane scrStackTrace;
    private final JTextPane txtExceptionClass;
    private final JTextPane txtMessage;
    private final JButton btnShowStack;
    private final JTextArea txtStackTrace;
    private final JLabel lblCausedBy;

    public SwingUncaughtExceptionHandlerItem(Throwable e, Thread t) {
        this.setLayout(new MigLayout("", "0[grow,fill]0", "0[]0[]0[16px::200px,grow,fill]5[top]0"));
        this.setFocusable(false);
        this.txtExceptionClass = new JTextPane();
        this.txtExceptionClass.setFont(new Font("Dialog", 1, 15));
        this.txtExceptionClass.setMinimumSize(new Dimension(0, 20));
        this.txtExceptionClass.setEditable(false);
        this.txtExceptionClass.setOpaque(false);
        this.add((Component)this.txtExceptionClass, "cell 0 0,grow");
        this.txtMessage = new JTextPane();
        this.txtMessage.setFont(new Font("Dialog", 0, 11));
        this.txtMessage.setMinimumSize(new Dimension(0, 20));
        this.txtMessage.setEditable(false);
        this.txtMessage.setOpaque(false);
        this.add((Component)this.txtMessage, "cell 0 1,grow, hidemode 3");
        this.btnShowStack = new JButton("...");
        this.btnShowStack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUncaughtExceptionHandlerItem.this.scrStackTrace.setVisible(!SwingUncaughtExceptionHandlerItem.this.scrStackTrace.isVisible());
                for (Container x = SwingUncaughtExceptionHandlerItem.this.scrStackTrace.getParent(); x != null; x = x.getParent()) {
                    ((Component)x).validate();
                }
            }
        });
        this.btnShowStack.setMinimumSize(new Dimension(16, 16));
        this.btnShowStack.setMaximumSize(new Dimension(16, 16));
        this.btnShowStack.setPreferredSize(new Dimension(16, 16));
        this.btnShowStack.setFont(new Font("Dialog", 0, 10));
        this.add((Component)this.btnShowStack, "flowx,cell 0 2,top");
        this.scrStackTrace = new JScrollPane();
        this.scrStackTrace.setBorder(null);
        this.scrStackTrace.setOpaque(false);
        this.scrStackTrace.setMinimumSize(new Dimension(0, 0));
        this.scrStackTrace.setVisible(false);
        this.add((Component)this.scrStackTrace, "cell 0 2, hidemode 3, shrink");
        this.txtStackTrace = new JTextArea();
        this.txtStackTrace.setFont(new Font("Monospaced", 0, 10));
        this.txtStackTrace.setEditable(false);
        this.txtStackTrace.setMinimumSize(new Dimension(0, 0));
        this.txtStackTrace.setOpaque(false);
        this.scrStackTrace.setViewportView(this.txtStackTrace);
        this.lblCausedBy = new JLabel(">>");
        this.lblCausedBy.setMaximumSize(new Dimension(20, 20));
        this.lblCausedBy.setMinimumSize(new Dimension(20, 20));
        this.lblCausedBy.setFont(new Font("Dialog", 0, 10));
        this.add((Component)this.lblCausedBy, "cell 0 3");
        if (e == null) {
            e = new NullPointerException("Testando 1,2,3...");
        }
        this.txtExceptionClass.setText(e.getClass().getName());
        if (e.getMessage() == null || e.getMessage().trim().isEmpty()) {
            this.txtMessage.setVisible(false);
        } else {
            this.txtMessage.setText(e.getMessage());
        }
        StringBuilder st = new StringBuilder();
        if (t != null) {
            st.append("Thread " + t.getName() + " (" + t.getId() + ")");
        }
        for (Field f : e.getClass().getFields()) {
            try {
                if (st.length() > 1) {
                    st.append("\n");
                }
                st.append("* ");
                st.append(f.getName());
                st.append("=");
                Object val = f.get(e);
                if (val != null) {
                    st.append(val);
                    continue;
                }
                st.append("null");
            }
            catch (Throwable x) {
                // empty catch block
            }
        }
        for (StackTraceElement ste : e.getStackTrace()) {
            if (st.length() > 1) {
                st.append("\n");
            }
            st.append("em ");
            st.append(ste.getClassName());
            st.append(".");
            st.append(ste.getMethodName());
            if (ste.getFileName() == null || ste.getFileName().isEmpty()) continue;
            st.append("(" + ste.getFileName());
            if (ste.getLineNumber() >= 0) {
                st.append(":" + ste.getLineNumber());
            }
            st.append(")");
        }
        this.txtStackTrace.setText(st.toString());
        if (e.getCause() != null) {
            this.add((Component)new SwingUncaughtExceptionHandlerItem(e.getCause(), null), "cell 0 3");
        } else {
            this.lblCausedBy.setVisible(false);
        }
    }
}

