/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.logins;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.ConnectionProvider;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;

public class LoginsPanel
extends JPanel {
    private final ConnectionProvider connectionProvider;
    private final JTable loginTable;
    private final DefaultTableModel loginTableModel;
    private static final String[] columnNames = new String[]{"Entidade", "Login ID"};
    private final JTextField txtFilter;

    public LoginsPanel(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        this.setLayout(new MigLayout("", "[grow]", "[][grow]"));
        JLabel label = new JLabel("Filtro");
        this.add((Component)label, "flowx,cell 0 0");
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1,grow");
        this.loginTableModel = new DefaultTableModel(new Object[0][], columnNames);
        this.loginTable = new JTable(this.loginTableModel);
        scrollPane.setViewportView(this.loginTable);
        this.txtFilter = new JTextField();
        this.add((Component)this.txtFilter, "cell 0 0, grow");
        this.txtFilter.setColumns(10);
        JButton btnFindLogins = new JButton("Consultar");
        this.add((Component)btnFindLogins, "cell 0 0");
        btnFindLogins.addActionListener(this.getLoginSearchActionListener());
    }

    private ActionListener getLoginSearchActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagedConnection cnn = LoginsPanel.this.connectionProvider.getConnectionToUse();
                cnn.setContextCurrentConnection();
                try {
                    LoginInfo[] infos = cnn.getContext().getLoginRegistry().getAllLogins();
                    Object[][] res = new Object[infos.length][];
                    for (int i = 0; i < infos.length; ++i) {
                        res[i] = new String[]{infos[i].entity, infos[i].id};
                    }
                    LoginsPanel.this.loginTableModel.setDataVector(res, columnNames);
                }
                catch (ServiceFailure e1) {
                    e1.printStackTrace(System.err);
                    return;
                }
                catch (UnauthorizedOperation e1) {
                    e1.printStackTrace(System.err);
                }
            }
        };
    }
}

