/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import tecgraf.openbus.browser.scs_offers.AsyncExpandableLoadingNodeBean;
import tecgraf.openbus.browser.scs_offers.NodeWithTreeReference;
import tecgraf.openbus.browser.scs_offers.RefreshableNode;
import tecgraf.openbus.browser.scs_offers.SCSTree;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ErrorNodeBean;

public abstract class AsyncExpandableTreeNode
extends NodeWithTreeReference
implements RefreshableNode {
    private LoadingState loadingState = LoadingState.UNLOADED;
    protected final DefaultTreeModel myModel;

    protected abstract List<DefaultMutableTreeNode> loadChildren() throws Exception;

    protected abstract String getLoadingDescription();

    private final synchronized void assertLoaded() {
        if (this.loadingState == LoadingState.UNLOADED) {
            this.doLoad();
        }
    }

    public AsyncExpandableTreeNode(SCSTree tree) {
        super(tree);
        this.myModel = (DefaultTreeModel)tree.getModel();
    }

    @Override
    public void refreshNode() {
        Runnable refresh = new Runnable(){

            @Override
            public void run() {
                AsyncExpandableTreeNode.this.assertLoaded();
                if (AsyncExpandableTreeNode.this.loadingState != LoadingState.LOADING) {
                    AsyncExpandableTreeNode.this.removeAllChildren();
                    AsyncExpandableTreeNode.this.loadingState = LoadingState.UNLOADED;
                    AsyncExpandableTreeNode.this.doLoad();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            refresh.run();
        } else {
            SwingUtilities.invokeLater(refresh);
        }
    }

    private synchronized void doLoad() {
        this.loadingState = LoadingState.LOADING;
        final AsyncExpandableLoadingNodeBean loadingBean = new AsyncExpandableLoadingNodeBean(System.currentTimeMillis(), this.getLoadingDescription());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AsyncExpandableTreeNode.this.setOnlyChild(new DefaultMutableTreeNode(loadingBean));
            }
        });
        new Thread(){

            @Override
            public void run() {
                try {
                    loadingBean.setStartTimestamp(System.currentTimeMillis());
                    final List<DefaultMutableTreeNode> res = AsyncExpandableTreeNode.this.loadChildren();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AsyncExpandableTreeNode.this.removeAllChildren();
                                for (DefaultMutableTreeNode node : res) {
                                    AsyncExpandableTreeNode.this.add(node);
                                }
                                AsyncExpandableTreeNode.this.myModel.nodeStructureChanged(AsyncExpandableTreeNode.this);
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                    });
                    AsyncExpandableTreeNode.this.loadingState = LoadingState.LOADED;
                }
                catch (Throwable e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AsyncExpandableTreeNode.this.setOnlyChild(new DefaultMutableTreeNode(new ErrorNodeBean(e)));
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                    });
                    AsyncExpandableTreeNode.this.loadingState = LoadingState.ERROR;
                }
            }
        }.start();
    }

    private void setOnlyChild(DefaultMutableTreeNode child) {
        this.removeAllChildren();
        this.add(child);
        this.myModel.nodeStructureChanged(this);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.assertLoaded();
        return super.getChildAt(childIndex);
    }

    @Override
    public int getChildCount() {
        this.assertLoaded();
        return super.getChildCount();
    }

    @Override
    public int getIndex(TreeNode node) {
        this.assertLoaded();
        return super.getIndex(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.loadingState == LoadingState.LOADED && this.children.isEmpty();
    }

    public Enumeration<?> children() {
        this.assertLoaded();
        return super.children();
    }

    public static enum LoadingState {
        UNLOADED,
        LOADING,
        LOADED,
        ERROR;

    }
}

