/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.ConnectionProvider;
import tecgraf.openbus.browser.LRUComboBox;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.OpenbusBrowser;
import tecgraf.openbus.browser.TipPanel;
import tecgraf.openbus.browser.TipPanelInterface;
import tecgraf.openbus.browser.scs_offers.FindServicesQueryControlInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithHelpTipInterface;
import tecgraf.openbus.browser.scs_offers.SCSTreeAndDetailsComponent;
import tecgraf.openbus.browser.scs_offers.ServiceOfferRegistryObserversPool;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

public final class OfferRegistryPanel
extends JPanel
implements FindServicesQueryControlInterface {
    private static final char LRU_PROP_DIV_CHAR = '\u00a3';
    private static final ImageIcon IMAGE_TIP_HIDE = new ImageIcon(OpenbusBrowser.class.getResource("tip-hide.png"));
    private static final ImageIcon IMAGE_TIP_SHOW = new ImageIcon(OpenbusBrowser.class.getResource("tip-open.png"));
    private static final ImageIcon IMAGE_TREE_EXPAND = new ImageIcon(OfferRegistryPanel.class.getResource("tree_expand.png"));
    private static final ImageIcon IMAGE_TREE_CONTRACT = new ImageIcon(OfferRegistryPanel.class.getResource("tree_contract.png"));
    private static final ImageIcon IMAGE_TREE_SEARCH = new ImageIcon(OfferRegistryPanel.class.getResource("tree_search.png"));
    private final ConnectionProvider connectionProvider;
    private final JTable propertyTable;
    private static final String[] columnNames = new String[]{"Propriedade", "Valor"};
    private final DefaultTableModel propertyTableModel = new DefaultTableModel(new Object[][]{{"", ""}}, columnNames){
        Class<?>[] columnTypes;
        {
            this.columnTypes = new Class[]{String.class, String.class};
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    };
    private volatile boolean cmbPropertyNameResizing = false;
    private final Preferences persistedPrefs = Preferences.userNodeForPackage(this.getClass());
    private final LRUComboBox cmbPropertyName;
    private final JButton btnFindOffers;
    private final LRUComboBox cmbLRU;
    private JLabel lblFilter;
    private ManagedConnection currentConnectionUsed = null;
    private boolean filterIsShowingFilterText = true;
    private final SCSTreeAndDetailsComponent scsTreeAndDetails;
    private TipPanel tipPanel;
    private JButton btnClearFilter;
    private JLabel tipHiderLabel;
    private DefaultCellEditor propCellEditor;

    public OfferRegistryPanel(ConnectionProvider argConnectionProvider) {
        this.connectionProvider = argConnectionProvider;
        this.setLayout(new MigLayout("", "0[grow]0", "0[grow]0"));
        ServiceOfferRegistryObserversPool.getSingleton().setConnectionProvider(argConnectionProvider);
        JSplitPane mainSplit = new JSplitPane(0);
        mainSplit.setContinuousLayout(true);
        mainSplit.setOneTouchExpandable(true);
        this.add((Component)mainSplit, "cell 0 0, grow");
        JPanel pnlFindOffers = new JPanel();
        pnlFindOffers.setBorder(new TitledBorder(null, "FindOffers:", 4, 2, null, null));
        pnlFindOffers.setLayout(new MigLayout("", "0[grow]0", "0[grow][]0"));
        JScrollPane scrPropertyTable = new JScrollPane();
        pnlFindOffers.add((Component)scrPropertyTable, "cell 0 0,alignx left,aligny top, grow");
        mainSplit.setTopComponent(pnlFindOffers);
        mainSplit.setDividerLocation(100);
        this.cmbPropertyName = new LRUComboBox();
        this.cmbPropertyName.setEditable(true);
        this.cmbPropertyName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (OfferRegistryPanel.this.cmbPropertyName.getSelectedItem() == null) {
                    return;
                }
                if (OfferRegistryPanel.this.cmbPropertyName.getSelectedItem().toString().trim().isEmpty()) {
                    return;
                }
                DefaultComboBoxModel model = (DefaultComboBoxModel)OfferRegistryPanel.this.cmbPropertyName.getModel();
                int pos = model.getIndexOf(OfferRegistryPanel.this.cmbPropertyName.getSelectedItem());
                if (pos == -1) {
                    OfferRegistryPanel.this.cmbPropertyName.addLRUItem(OfferRegistryPanel.this.cmbPropertyName.getSelectedItem().toString());
                    OfferRegistryPanel.this.persistedPrefs.put("propLRU", OfferRegistryPanel.this.cmbPropertyName.getLRUJoinedText());
                }
            }
        });
        this.cmbPropertyName.setSaveHandler(new Runnable(){

            @Override
            public void run() {
                OfferRegistryPanel.this.persistedPrefs.put("propLRU", OfferRegistryPanel.this.cmbPropertyName.getLRUJoinedText());
            }
        });
        this.cmbPropertyName.loadLRUJoinedText(this.persistedPrefs.get("propLRU", ""));
        for (String v : new String[]{"openbus.offer.id", "openbus.offer.login", "openbus.offer.entity", "openbus.offer.timestamp", "openbus.offer.year", "openbus.offer.month", "openbus.offer.day", "openbus.offer.hour", "openbus.offer.minute", "openbus.offer.second", "openbus.component.name", "openbus.component.version.major", "openbus.component.version.minor", "openbus.component.version.patch", "openbus.component.facet", "openbus.component.interface"}) {
            this.cmbPropertyName.addLRUItem(v);
        }
        this.propertyTable = new JTable();
        this.propertyTable.setModel(this.propertyTableModel);
        this.propertyTable.setSurrendersFocusOnKeystroke(true);
        this.propertyTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                OfferRegistryPanel.this.reinferRowNumbers();
                String lruText = OfferRegistryPanel.this.getLRUText();
                int posInLRU = lruText != null && !lruText.trim().isEmpty() ? ((DefaultComboBoxModel)OfferRegistryPanel.this.cmbLRU.getModel()).getIndexOf(lruText) : -1;
                if (posInLRU != OfferRegistryPanel.this.cmbLRU.getSelectedIndex()) {
                    OfferRegistryPanel.this.cmbLRU.setSelectedIndex(posInLRU);
                }
            }
        });
        this.propertyTable.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                if (!OfferRegistryPanel.this.propertyTable.isEditing() && e.getKeyCode() == 127) {
                    e.consume();
                    OfferRegistryPanel.this.cmbPropertyNameResizing = true;
                    try {
                        for (int col : OfferRegistryPanel.this.propertyTable.getSelectedColumns()) {
                            for (int row : OfferRegistryPanel.this.propertyTable.getSelectedRows()) {
                                OfferRegistryPanel.this.propertyTableModel.setValueAt("", row, col);
                            }
                        }
                    }
                    finally {
                        OfferRegistryPanel.this.cmbPropertyNameResizing = false;
                        OfferRegistryPanel.this.reinferRowNumbers();
                    }
                }
            }
        });
        this.propCellEditor = new DefaultCellEditor(this.cmbPropertyName);
        this.configurePropColumnModel();
        this.propertyTable.setCellSelectionEnabled(true);
        this.propertyTable.setSelectionMode(0);
        scrPropertyTable.setViewportView(this.propertyTable);
        JLabel lblLRU = new JLabel("LRU:");
        pnlFindOffers.add((Component)lblLRU, "cell 0 1,alignx left");
        this.cmbLRU = new LRUComboBox();
        this.cmbLRU.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.cmbLRU.setMinimumSize(new Dimension(0, 20));
        lblLRU.setLabelFor(this.cmbLRU);
        pnlFindOffers.add((Component)this.cmbLRU, "cell 0 1,alignx left, grow");
        this.cmbLRU.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (OfferRegistryPanel.this.cmbLRU.getSelectedItem() == null) {
                    return;
                }
                if (!OfferRegistryPanel.this.getLRUText().equals(OfferRegistryPanel.this.cmbLRU.getSelectedItem().toString())) {
                    OfferRegistryPanel.this.configureByLRUText(OfferRegistryPanel.this.cmbLRU.getSelectedItem().toString());
                }
            }
        });
        this.btnClearFilter = new JButton("Limpar");
        this.btnClearFilter.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        pnlFindOffers.add((Component)this.btnClearFilter, "cell 0 1,alignx");
        this.btnFindOffers = new JButton("Consultar");
        this.btnFindOffers.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        pnlFindOffers.add((Component)this.btnFindOffers, "cell 0 1,alignx");
        this.scsTreeAndDetails = new SCSTreeAndDetailsComponent();
        this.scsTreeAndDetails.setFindServicesQueryControlInterface(this);
        JPanel resultPanel = new JPanel();
        resultPanel.setLayout(new BorderLayout());
        resultPanel.add((Component)this.scsTreeAndDetails, "Center");
        this.scsTreeAndDetails.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath sel = OfferRegistryPanel.this.scsTreeAndDetails.getTree().getSelectionPath();
                NodeWithHelpTipInterface help = null;
                if (sel != null) {
                    DefaultMutableTreeNode n;
                    if (sel.getLastPathComponent() instanceof NodeWithHelpTipInterface) {
                        help = (NodeWithHelpTipInterface)sel.getLastPathComponent();
                    } else if (sel.getLastPathComponent() instanceof DefaultMutableTreeNode && (n = (DefaultMutableTreeNode)sel.getLastPathComponent()).getUserObject() != null && n.getUserObject() instanceof NodeWithHelpTipInterface) {
                        help = (NodeWithHelpTipInterface)n.getUserObject();
                    }
                }
                if (help != null) {
                    help.configureHelpTip(OfferRegistryPanel.this.tipPanel);
                } else {
                    OfferRegistryPanel.this.configureDefaultTip(OfferRegistryPanel.this.tipPanel);
                }
            }
        });
        JPanel resultsFilterPanel = new JPanel();
        resultPanel.add((Component)resultsFilterPanel, "North");
        resultsFilterPanel.setLayout(new MigLayout("", "1[][]1", "1[]1"));
        JButton btnContract = new JButton(IMAGE_TREE_CONTRACT);
        btnContract.setToolTipText("Contrair todos os resultados da \u00e1rvore abaixo.");
        btnContract.setMinimumSize(new Dimension(16, 16));
        btnContract.setMaximumSize(new Dimension(16, 16));
        btnContract.setPreferredSize(new Dimension(16, 16));
        btnContract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < OfferRegistryPanel.this.scsTreeAndDetails.getTree().getRowCount(); ++i) {
                    OfferRegistryPanel.this.scsTreeAndDetails.getTree().collapseRow(i);
                }
            }
        });
        resultsFilterPanel.add((Component)btnContract, "cell 0 0");
        JButton btnExpand = new JButton(IMAGE_TREE_EXPAND);
        btnExpand.setToolTipText("Expandir todo o resultado at\u00e9 as ofertas.");
        btnExpand.setMinimumSize(new Dimension(16, 16));
        btnExpand.setMaximumSize(new Dimension(16, 16));
        btnExpand.setPreferredSize(new Dimension(16, 16));
        btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < OfferRegistryPanel.this.scsTreeAndDetails.getTree().getRowCount(); ++i) {
                    if (OfferRegistryPanel.this.scsTreeAndDetails.getTree().getPathForRow(i).getPathCount() >= 4) continue;
                    OfferRegistryPanel.this.scsTreeAndDetails.getTree().expandRow(i);
                }
            }
        });
        resultsFilterPanel.add((Component)btnExpand, "cell 0 0");
        JButton btnTreeSearch = new JButton(IMAGE_TREE_SEARCH);
        btnTreeSearch.setToolTipText("Localizar texto nas ofertas (voc\u00ea pode clicar na \u00e1rvore e come\u00e7ar a digitar, tamb\u00e9m). N\u00e3o busca em n\u00f3s do DataService.");
        btnTreeSearch.setMinimumSize(new Dimension(16, 16));
        btnTreeSearch.setMaximumSize(new Dimension(16, 16));
        btnTreeSearch.setPreferredSize(new Dimension(16, 16));
        btnTreeSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferRegistryPanel.this.scsTreeAndDetails.showSearchField();
            }
        });
        resultsFilterPanel.add((Component)btnTreeSearch, "cell 0 0");
        this.lblFilter = new JLabel("Fa\u00e7a uma consulta");
        this.lblFilter.setMinimumSize(new Dimension(0, 0));
        this.lblFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OfferRegistryPanel.this.filterIsShowingFilterText = !OfferRegistryPanel.this.filterIsShowingFilterText;
                OfferRegistryPanel.this.setFilterTextAndTooltip();
            }
        });
        resultsFilterPanel.add((Component)this.lblFilter, "cell 1 0");
        mainSplit.setBottomComponent(resultPanel);
        this.tipHiderLabel = new JLabel(IMAGE_TIP_SHOW);
        this.tipHiderLabel.setOpaque(true);
        this.tipHiderLabel.setAlignmentX(0.0f);
        this.tipHiderLabel.setVerticalAlignment(0);
        this.tipHiderLabel.setHorizontalAlignment(2);
        this.tipHiderLabel.setAlignmentY(0.5f);
        this.tipHiderLabel.setBackground(this.getBackground().darker());
        this.tipHiderLabel.setMinimumSize(new Dimension(0, 12));
        this.tipHiderLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 12));
        this.tipHiderLabel.setCursor(new Cursor(12));
        this.tipHiderLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                    e.consume();
                    OfferRegistryPanel.this.tipPanel.setVisible(!OfferRegistryPanel.this.tipPanel.isVisible());
                    OfferRegistryPanel.this.configureTipVisibility();
                    OfferRegistryPanel.this.persistedPrefs.putBoolean("tipPanelVisible", OfferRegistryPanel.this.tipPanel.isVisible());
                    OfferRegistryPanel.this.validate();
                    OfferRegistryPanel.this.repaint();
                }
            }
        });
        this.tipPanel = new TipPanel();
        this.tipPanel.setVisible(this.persistedPrefs.getBoolean("tipPanelVisible", true));
        this.scsTreeAndDetails.addPanelToBottomDetails(this.tipHiderLabel);
        this.scsTreeAndDetails.addPanelToBottomDetails(this.tipPanel);
        this.configureTipVisibility();
        this.btnClearFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferRegistryPanel.this.propertyTableModel.setDataVector(new Object[][]{{"", ""}}, columnNames);
                OfferRegistryPanel.this.configurePropColumnModel();
            }
        });
        this.btnFindOffers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OfferRegistryPanel.this.connectionProvider.getConnectionToUse() == null) {
                    JOptionPane.showMessageDialog(OfferRegistryPanel.this, "Selecione um login!", "Sem login", 0);
                    return;
                }
                OfferRegistryPanel.this.currentConnectionUsed = OfferRegistryPanel.this.connectionProvider.getConnectionToUse();
                ServiceProperty[] propertyFilter = OfferRegistryPanel.this.getPropertiesFromTable();
                OfferRegistryPanel.this.scsTreeAndDetails.setCurrentPropertyFilter(propertyFilter);
                OfferRegistryPanel.this.setFilterTextAndTooltip();
                OfferRegistryPanel.this.scsTreeAndDetails.startSearch(OfferRegistryPanel.this.currentConnectionUsed, propertyFilter);
                String lru = OfferRegistryPanel.this.getLRUText(propertyFilter);
                if (lru != null && !lru.trim().isEmpty()) {
                    OfferRegistryPanel.this.cmbLRU.addLRUItem(lru);
                    OfferRegistryPanel.this.cmbLRU.setSelectedItem(lru);
                    OfferRegistryPanel.this.persistedPrefs.put("lru", OfferRegistryPanel.this.cmbLRU.getLRUJoinedText());
                }
            }
        });
        this.btnFindOffers.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.consume();
                    JPopupMenu opt = new JPopupMenu();
                    ButtonGroup autoLoadTypeGroup = new ButtonGroup();
                    JRadioButtonMenuItem mnuNoAutoLoad = new JRadioButtonMenuItem("N\u00e3o fazer busca automaticamente na primeira conex\u00e3o.");
                    autoLoadTypeGroup.add(mnuNoAutoLoad);
                    JRadioButtonMenuItem mnuAllAutoLoad = new JRadioButtonMenuItem("Fazer busca sem filtro automaticamente na primeira conex\u00e3o.");
                    autoLoadTypeGroup.add(mnuAllAutoLoad);
                    JRadioButtonMenuItem mnuLastAutoLoad = new JRadioButtonMenuItem("Fazer busca com \u00faltimo filtro automaticamente na primeira conex\u00e3o.");
                    autoLoadTypeGroup.add(mnuLastAutoLoad);
                    String prefVal = OfferRegistryPanel.this.persistedPrefs.get("autoLoad", "last");
                    if ("off".equals(prefVal)) {
                        mnuNoAutoLoad.setSelected(true);
                    } else if ("all".equals(prefVal)) {
                        mnuAllAutoLoad.setSelected(true);
                    } else if ("last".equals(prefVal)) {
                        mnuLastAutoLoad.setSelected(true);
                    }
                    opt.add(mnuNoAutoLoad);
                    opt.add(mnuAllAutoLoad);
                    opt.add(mnuLastAutoLoad);
                    mnuNoAutoLoad.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OfferRegistryPanel.this.persistedPrefs.put("autoLoad", "off");
                        }
                    });
                    mnuAllAutoLoad.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OfferRegistryPanel.this.persistedPrefs.put("autoLoad", "all");
                        }
                    });
                    mnuLastAutoLoad.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OfferRegistryPanel.this.persistedPrefs.put("autoLoad", "last");
                        }
                    });
                    JCheckBoxMenuItem mnuDefaultExpanded = new JCheckBoxMenuItem("Expandir os n\u00f3s das ofertas na \u00e1rvore");
                    mnuDefaultExpanded.setSelected(OfferRegistryPanel.this.persistedPrefs.getBoolean("isOffersDefaultExpanded", false));
                    mnuDefaultExpanded.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            OfferRegistryPanel.this.persistedPrefs.putBoolean("isOffersDefaultExpanded", ((JCheckBoxMenuItem)arg0.getSource()).isSelected());
                        }
                    });
                    opt.add(mnuDefaultExpanded);
                    opt.show(OfferRegistryPanel.this.btnFindOffers, 0, OfferRegistryPanel.this.btnFindOffers.getHeight() + 2);
                }
            }
        });
        this.btnFindOffers.setToolTipText("Executar consulta. Clique com o bot\u00e3o direito para op\u00e7\u00f5es.");
        this.cmbLRU.setSaveHandler(new Runnable(){

            @Override
            public void run() {
                OfferRegistryPanel.this.persistedPrefs.put("lru", OfferRegistryPanel.this.cmbLRU.getLRUJoinedText());
            }
        });
        this.cmbLRU.loadLRUJoinedText(this.persistedPrefs.get("lru", ""));
        this.configureDefaultTip(this.tipPanel);
        argConnectionProvider.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                String prefVal = OfferRegistryPanel.this.persistedPrefs.get("autoLoad", "last");
                if (!"off".equals(prefVal) && OfferRegistryPanel.this.connectionProvider.getConnectionToUse() != null && OfferRegistryPanel.this.connectionProvider.getConnectionToUse().getState().equals((Object)ManagedConnection.ConnectionState.AUTENTICATED) && OfferRegistryPanel.this.currentConnectionUsed == null) {
                    if ("all".equals(prefVal)) {
                        OfferRegistryPanel.this.btnClearFilter.doClick();
                    } else if ("last".equals(prefVal) && OfferRegistryPanel.this.cmbLRU.getModel().getSize() > 0) {
                        OfferRegistryPanel.this.cmbLRU.setSelectedIndex(0);
                    }
                    OfferRegistryPanel.this.btnFindOffers.doClick();
                }
            }
        });
    }

    private void configurePropColumnModel() {
        this.propertyTable.getColumnModel().getColumn(0).setCellEditor(this.propCellEditor);
        this.propertyTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new JTextField()));
        ((DefaultCellEditor)this.propertyTable.getColumnModel().getColumn(0).getCellEditor()).setClickCountToStart(1);
        ((DefaultCellEditor)this.propertyTable.getColumnModel().getColumn(1).getCellEditor()).setClickCountToStart(1);
    }

    private void configureTipVisibility() {
        if (this.tipPanel.isVisible() && this.tipHiderLabel.getIcon() != IMAGE_TIP_HIDE) {
            this.tipHiderLabel.setIcon(IMAGE_TIP_HIDE);
        } else if (this.tipHiderLabel.getIcon() != IMAGE_TIP_SHOW) {
            this.tipHiderLabel.setIcon(IMAGE_TIP_SHOW);
        }
    }

    private void configureDefaultTip(TipPanelInterface tipPanel) {
        tipPanel.setTips(new String[]{"Feito um login, fa\u00e7a uma busca no servi\u00e7o de registro de ofertas preenchendo a tabela acima e clicando em \"Consultar\"", "As propriedades padr\u00e3o do OpenBus j\u00e1 est\u00e3o pr\u00e9-definidas na caixa de sele\u00e7\u00e3o acess\u00edvel pela tabela de crit\u00e9rios de busca.", "Aqui ir\u00e3o aparecer dicas de uso referentes ao n\u00f3 da \u00e1rvore de resultados que voc\u00ea selecionou. Use '<' e '>' daqui da esquerda para ver as demais dicas dispon\u00edveis no contexto.", "Use a barra cinza logo acima para ocultar esta ajuda ou faz\u00ea-la reaparecer.", "As listas LRU v\u00e3o se lembrar do que voc\u00ea fez recentemente e facilitar para voc\u00ea repetir algo. Mas se voc\u00ea quiser que as listas LRU \"se esque\u00e7am\" das suas \u00faltimas a\u00e7\u00f5es, basta clicar com o bot\u00e3o direito sobre elas.", "Se voc\u00ea fizer mais de um login simultaneamente, voc\u00ea pode escolher qual deles usar para realizar a sua consulta no servi\u00e7o de ofertas selecionando pelo radiobutton associado, l\u00e1 em cima.", "Apenas depois de voc\u00ea fazer alguma consulta, o servi\u00e7o de ofertas ser\u00e1 monitorado para lhe indicar em tempo real quando novas ofertas forem feitas, assim como quando as ofertas forem removidas, sem que voc\u00ea precise ficar clicando em 'consultar' repetidamente para dar 'refresh' na \u00e1rvore.", "Se voc\u00ea n\u00e3o quiser que esta aplica\u00e7\u00e3o fa\u00e7a login e uma busca automaticamente ao iniciar, clique com o bot\u00e3o direito do mouse sobre os bot\u00f5es [Login] e [Consultar]", "Poupe tempo! Se seu \u00faltimo login foi feito com chave privada, ao reiniciar a aplica\u00e7\u00e3o o login ser\u00e1 feito automaticamente, assim como uma primeira consulta. Para desativar este recurso, clique com o bot\u00e3o direito sobre os bot\u00f5es [Login] e [Consultar]"}, new String[]{"Problem?!"});
    }

    private void setFilterTextAndTooltip() {
        String text;
        String tooltip;
        String filterText = this.scsTreeAndDetails.getCurrentPropertyFilter() == null || this.scsTreeAndDetails.getCurrentPropertyFilter().length == 0 ? "Todas as ofertas dispon\u00edveis" : "Filtro: " + this.getLRUText(this.scsTreeAndDetails.getCurrentPropertyFilter()).replaceAll(Pattern.quote(String.valueOf('\u00a3')), ", ");
        String cnnText = this.currentConnectionUsed == null ? "Fa\u00e7a uma consulta" : this.currentConnectionUsed.getEntity() + "@" + this.currentConnectionUsed.getHost() + ":" + this.currentConnectionUsed.getPort();
        if (this.filterIsShowingFilterText) {
            tooltip = cnnText;
            text = filterText;
        } else {
            tooltip = filterText;
            text = cnnText;
        }
        if (ServiceOfferRegistryObserversPool.getServiceOfferObserversSystemPropertyValue()) {
            tooltip = "(Usando observadores do servi\u00e7o de registro) " + tooltip;
            text = "(Ao Vivo) " + text;
        }
        if (!text.equals(this.lblFilter.getText())) {
            this.lblFilter.setText(text);
        }
        if (!tooltip.equals(this.lblFilter.getToolTipText())) {
            this.lblFilter.setToolTipText(tooltip);
        }
    }

    private ServiceProperty[] getPropertiesFromTable() {
        ArrayList<ServiceProperty> res = new ArrayList<ServiceProperty>(this.propertyTableModel.getRowCount());
        for (int i = 0; i < this.propertyTableModel.getRowCount(); ++i) {
            boolean rowEmpty;
            boolean bl = rowEmpty = OfferRegistryPanel.isEmpty(this.propertyTableModel.getValueAt(i, 0)) && OfferRegistryPanel.isEmpty(this.propertyTableModel.getValueAt(i, 1));
            if (rowEmpty) continue;
            res.add(new ServiceProperty(OfferRegistryPanel.toStringNZ(this.propertyTableModel.getValueAt(i, 0)), OfferRegistryPanel.toStringNZ(this.propertyTableModel.getValueAt(i, 1))));
        }
        Collections.sort(res, new Comparator<ServiceProperty>(){

            @Override
            public int compare(ServiceProperty o1, ServiceProperty o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return res.toArray(new ServiceProperty[0]);
    }

    private static final String toStringNZ(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinferRowNumbers() {
        if (this.cmbPropertyNameResizing) {
            return;
        }
        this.cmbPropertyNameResizing = true;
        try {
            int maxRowFilled;
            block3: while (true) {
                maxRowFilled = 0;
                for (int i = 0; i < this.propertyTableModel.getRowCount(); ++i) {
                    boolean rowEmpty;
                    boolean bl = rowEmpty = OfferRegistryPanel.isEmpty(this.propertyTableModel.getValueAt(i, 0)) && OfferRegistryPanel.isEmpty(this.propertyTableModel.getValueAt(i, 1));
                    if (rowEmpty && i < this.propertyTableModel.getRowCount() - 1) {
                        this.propertyTableModel.removeRow(i);
                        continue block3;
                    }
                    if (rowEmpty) continue;
                    maxRowFilled = i;
                }
                break;
            }
            while (this.propertyTableModel.getRowCount() < maxRowFilled + 2) {
                this.propertyTableModel.addRow(new Object[]{"", ""});
            }
            while (this.propertyTableModel.getRowCount() > maxRowFilled + 2) {
                this.propertyTableModel.removeRow(this.propertyTableModel.getRowCount() - 1);
            }
        }
        finally {
            this.cmbPropertyNameResizing = false;
        }
    }

    private static final boolean isEmpty(Object val) {
        if (val == null) {
            return true;
        }
        if (val.toString().isEmpty()) {
            return true;
        }
        return val.toString().trim().isEmpty();
    }

    private final String getLRUText() {
        return this.getLRUText(this.getPropertiesFromTable());
    }

    private final String getLRUText(ServiceProperty[] props) {
        StringBuilder res = new StringBuilder();
        for (ServiceProperty p : props) {
            if (res.length() > 0) {
                res.append('\u00a3');
            }
            res.append(p.name);
            res.append("=");
            res.append(p.value);
        }
        return res.toString();
    }

    private final void configureByLRUText(String lruText) {
        String[] props = lruText.split(Pattern.quote(String.valueOf('\u00a3')));
        Object[][] newData = new Object[props.length][];
        for (int i = 0; i < props.length; ++i) {
            newData[i] = props[i].split("=", 2);
        }
        this.propertyTableModel.setDataVector(newData, columnNames);
        this.configurePropColumnModel();
    }

    @Override
    public void addCriteria(final String property, final String value) {
        if (property == null) {
            throw new NullPointerException("property \u00e9 nulo");
        }
        if (value == null) {
            throw new NullPointerException("value \u00e9 nulo");
        }
        if (property.trim().isEmpty() && value.trim().isEmpty()) {
            return;
        }
        for (ServiceProperty prop : this.getPropertiesFromTable()) {
            if (!prop.name.equals(property) || !prop.value.equals(value)) continue;
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OfferRegistryPanel.this.propertyTableModel.addRow(new Object[]{property, value});
            }
        });
    }

    @Override
    public boolean isOffersDefaultExpanded() {
        return this.persistedPrefs.getBoolean("isOffersDefaultExpanded", false);
    }
}

