/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.scs_offers.AsyncExpandableTreeNode;
import tecgraf.openbus.browser.scs_offers.FindServicesQueryControlInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithSearchCapability;
import tecgraf.openbus.browser.scs_offers.NodeWithTreeReference;
import tecgraf.openbus.browser.scs_offers.SCSTree;
import tecgraf.openbus.browser.scs_offers.ServiceOfferRegistryObserversPool;
import tecgraf.openbus.browser.scs_offers.TreeStructureBuilder;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ServiceOfferNode;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

public class SCSTreeAndDetailsComponent
extends JComponent {
    private static final long serialVersionUID = 182205186035813454L;
    private final JSplitPane resultSplit;
    private final SCSTree resultTree;
    private final JProgressBar loadProgressBar;
    private final JPanel detailsPanel;
    private final JPanel detailsSplit;
    private ServiceProperty[] currentPropertyFilter = null;
    private final TreeStructureBuilder treeStructureBuilder;
    private final JTextField txtSearch;
    private final JLabel lblOutOfQueryEntrance;
    private final JLabel lblOutOfQueryRemoval;
    private final AtomicInteger outOfQueryEntranceCounter = new AtomicInteger(0);
    private final AtomicInteger outOfQueryEntranceAnimCountdown = new AtomicInteger(0);
    private final AtomicInteger outOfQueryRemovalCounter = new AtomicInteger(0);
    private final AtomicInteger outOfQueryRemovalAnimCountdown = new AtomicInteger(0);
    private FindServicesQueryControlInterface findServicesQueryControlInterfaceImpl = null;
    private final ServiceOfferRegistryObserversPool.ServiceOfferRegistryObserversPoolListener serviceOfferRegistryObserversPoolListener = new ServiceOfferRegistryObserversPool.ServiceOfferRegistryObserversPoolListener(){

        @Override
        public void offerRegistered(ManagedConnection cnn, ServiceOfferDesc offer) {
            if (SCSTreeAndDetailsComponent.this.currentPropertyFilter != null && SCSTreeAndDetailsComponent.this.currentPropertyFilter.length > 0) {
                for (ServiceProperty filter : SCSTreeAndDetailsComponent.this.currentPropertyFilter) {
                    boolean found = false;
                    for (ServiceProperty prop : offer.properties) {
                        if (!prop.name.equals(filter.name) || !prop.value.equals(filter.value)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return;
                }
            }
            SCSTreeAndDetailsComponent.this.resultTree.addServiceOffer(cnn, offer, (NodeWithTreeReference)SCSTreeAndDetailsComponent.this.resultTree.getModel().getRoot());
        }
    };
    private final TreeStructureBuilder.TreeLoadStatusListener myTreeLoadStatusListener = new TreeStructureBuilder.TreeLoadStatusListener(){

        @Override
        public void startedQuery() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SCSTreeAndDetailsComponent.this.loadProgressBar.setIndeterminate(true);
                    SCSTreeAndDetailsComponent.this.loadProgressBar.setVisible(true);
                    SCSTreeAndDetailsComponent.this.loadProgressBar.setMaximum(0);
                    SCSTreeAndDetailsComponent.this.loadProgressBar.setMinimum(0);
                    SCSTreeAndDetailsComponent.this.loadProgressBar.setValue(0);
                    SCSTreeAndDetailsComponent.this.loadProgressBar.setVisible(true);
                    SCSTreeAndDetailsComponent.this.loadProgressBar.setString("Interrogando Openbus...");
                }
            });
        }

        @Override
        public void startedProcessing(final int total) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (total == 0) {
                        SCSTreeAndDetailsComponent.this.loadProgressBar.setVisible(false);
                        JOptionPane.showMessageDialog(SCSTreeAndDetailsComponent.this, "Nada foi encontrado com este crit\u00e9rio", "OfferRegistry", 1);
                    } else {
                        SCSTreeAndDetailsComponent.this.loadProgressBar.setIndeterminate(false);
                        SCSTreeAndDetailsComponent.this.loadProgressBar.setMaximum(total);
                        SCSTreeAndDetailsComponent.this.loadProgressBar.setValue(0);
                        SCSTreeAndDetailsComponent.this.loadProgressBar.setString("Interrogando oferta 0/" + total + "...");
                    }
                }
            });
        }

        @Override
        public void setProgress(final int progress) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (progress == SCSTreeAndDetailsComponent.this.loadProgressBar.getMaximum()) {
                        SCSTreeAndDetailsComponent.this.loadProgressBar.setVisible(false);
                    } else {
                        SCSTreeAndDetailsComponent.this.loadProgressBar.setValue(progress);
                        SCSTreeAndDetailsComponent.this.loadProgressBar.setString("Interrogando oferta " + progress + "/" + SCSTreeAndDetailsComponent.this.loadProgressBar.getMaximum() + "...");
                    }
                }
            });
        }

        @Override
        public void error(final Throwable error) {
            error.printStackTrace(System.err);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SCSTreeAndDetailsComponent.this.loadProgressBar.setVisible(false);
                    JOptionPane.showMessageDialog(SCSTreeAndDetailsComponent.this, "Erro consultando Openbus: " + error.getClass().getName() + ": " + error.getMessage(), "Erro", 0);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void outOfQueryNewOffer() {
            AtomicInteger atomicInteger = SCSTreeAndDetailsComponent.this.outOfQueryEntranceAnimCountdown;
            synchronized (atomicInteger) {
                SCSTreeAndDetailsComponent.this.outOfQueryEntranceCounter.incrementAndGet();
                SCSTreeAndDetailsComponent.this.outOfQueryEntranceAnimCountdown.set(50);
            }
            if (!SCSTreeAndDetailsComponent.this.animTimer.isRunning()) {
                SCSTreeAndDetailsComponent.this.animTimer.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void outOfQueryRemovedOffer() {
            AtomicInteger atomicInteger = SCSTreeAndDetailsComponent.this.outOfQueryRemovalAnimCountdown;
            synchronized (atomicInteger) {
                SCSTreeAndDetailsComponent.this.outOfQueryRemovalCounter.incrementAndGet();
                SCSTreeAndDetailsComponent.this.outOfQueryRemovalAnimCountdown.set(50);
            }
            if (!SCSTreeAndDetailsComponent.this.animTimer.isRunning()) {
                SCSTreeAndDetailsComponent.this.animTimer.start();
            }
        }
    };
    private final Timer animTimer = new Timer(100, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean removalVisible;
            boolean entranceVisible;
            if (SCSTreeAndDetailsComponent.this.getParent() == null || !SCSTreeAndDetailsComponent.this.isVisible()) {
                return;
            }
            AtomicInteger atomicInteger = SCSTreeAndDetailsComponent.this.outOfQueryEntranceAnimCountdown;
            synchronized (atomicInteger) {
                boolean bl = entranceVisible = SCSTreeAndDetailsComponent.this.outOfQueryEntranceAnimCountdown.get() > 0;
                if (SCSTreeAndDetailsComponent.this.lblOutOfQueryEntrance.isVisible() != entranceVisible) {
                    SCSTreeAndDetailsComponent.this.lblOutOfQueryEntrance.setVisible(entranceVisible);
                }
                if (entranceVisible) {
                    String outOfQueryEntranceString = "+" + SCSTreeAndDetailsComponent.this.outOfQueryEntranceCounter.get();
                    if (!outOfQueryEntranceString.equals(SCSTreeAndDetailsComponent.this.lblOutOfQueryEntrance.getText())) {
                        SCSTreeAndDetailsComponent.this.lblOutOfQueryEntrance.setText(outOfQueryEntranceString);
                    }
                    Color entranceColor = new Color(0.0f, 0.0f, 0.0f, (float)SCSTreeAndDetailsComponent.this.outOfQueryEntranceAnimCountdown.getAndDecrement() / 50.0f);
                    if (!SCSTreeAndDetailsComponent.this.lblOutOfQueryEntrance.getForeground().equals(entranceColor)) {
                        SCSTreeAndDetailsComponent.this.lblOutOfQueryEntrance.setForeground(entranceColor);
                    }
                } else {
                    SCSTreeAndDetailsComponent.this.outOfQueryEntranceCounter.set(0);
                }
            }
            AtomicInteger atomicInteger2 = SCSTreeAndDetailsComponent.this.outOfQueryRemovalAnimCountdown;
            synchronized (atomicInteger2) {
                boolean bl = removalVisible = SCSTreeAndDetailsComponent.this.outOfQueryRemovalAnimCountdown.get() > 0;
                if (SCSTreeAndDetailsComponent.this.lblOutOfQueryRemoval.isVisible() != removalVisible) {
                    SCSTreeAndDetailsComponent.this.lblOutOfQueryRemoval.setVisible(removalVisible);
                }
                if (removalVisible) {
                    String outOfQueryremovalString = "-" + SCSTreeAndDetailsComponent.this.outOfQueryRemovalCounter.get();
                    if (!outOfQueryremovalString.equals(SCSTreeAndDetailsComponent.this.lblOutOfQueryRemoval.getText())) {
                        SCSTreeAndDetailsComponent.this.lblOutOfQueryRemoval.setText(outOfQueryremovalString);
                    }
                    Color removalColor = new Color(0.0f, 0.0f, 0.0f, (float)SCSTreeAndDetailsComponent.this.outOfQueryRemovalAnimCountdown.getAndDecrement() / 50.0f);
                    if (!SCSTreeAndDetailsComponent.this.lblOutOfQueryRemoval.getForeground().equals(removalColor)) {
                        SCSTreeAndDetailsComponent.this.lblOutOfQueryRemoval.setForeground(removalColor);
                    }
                } else {
                    SCSTreeAndDetailsComponent.this.outOfQueryRemovalCounter.set(0);
                }
            }
            if (!entranceVisible && !removalVisible) {
                SCSTreeAndDetailsComponent.this.animTimer.stop();
            }
        }
    });
    private final FindServicesQueryControlInterface queryControlDelegate = new FindServicesQueryControlInterface(){

        @Override
        public void addCriteria(String property, String value) {
            if (SCSTreeAndDetailsComponent.this.getQueryControlImpl() != null) {
                SCSTreeAndDetailsComponent.this.getQueryControlImpl().addCriteria(property, value);
            }
        }

        @Override
        public boolean isOffersDefaultExpanded() {
            if (SCSTreeAndDetailsComponent.this.getQueryControlImpl() != null) {
                return SCSTreeAndDetailsComponent.this.getQueryControlImpl().isOffersDefaultExpanded();
            }
            return false;
        }
    };

    public SCSTreeAndDetailsComponent() {
        this.resultTree = new SCSTree(this);
        this.treeStructureBuilder = new TreeStructureBuilder(this.queryControlDelegate, this.resultTree, this.myTreeLoadStatusListener);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ServiceOfferRegistryObserversPool.getSingleton().removeListener(SCSTreeAndDetailsComponent.this.serviceOfferRegistryObserversPoolListener);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ServiceOfferRegistryObserversPool.getSingleton().addListener(SCSTreeAndDetailsComponent.this.serviceOfferRegistryObserversPoolListener);
            }
        });
        final JScrollPane scrTree = new JScrollPane(this.resultTree);
        this.loadProgressBar = new JProgressBar(0);
        JLayeredPane resultLayers = new JLayeredPane();
        resultLayers.setLayout(new LayoutManager(){

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return scrTree.getPreferredSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(350, 0);
            }

            @Override
            public void layoutContainer(Container parent) {
                scrTree.setBounds(parent.getBounds());
                SCSTreeAndDetailsComponent.this.txtSearch.setBounds(new Rectangle(parent.getWidth() - 170, 3, 150, 20));
                SCSTreeAndDetailsComponent.this.loadProgressBar.setBounds(new Rectangle(10, parent.getBounds().height - 25, parent.getWidth() - 20, 15));
                SCSTreeAndDetailsComponent.this.lblOutOfQueryEntrance.setBounds(new Rectangle(5, parent.getBounds().height - 50, 60, 32));
                SCSTreeAndDetailsComponent.this.lblOutOfQueryRemoval.setBounds(new Rectangle(parent.getBounds().width - 80, parent.getBounds().height - 50, 60, 32));
            }
        });
        this.txtSearch = new JTextField();
        this.txtSearch.setToolTipText("Digite o que quer encontrar para que seja localizado na \u00e1rvore para voc\u00ea. N\u00f3s de DataService n\u00e3o ser\u00e3o buscados.");
        this.txtSearch.setVisible(false);
        this.txtSearch.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.txtSearch.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SCSTreeAndDetailsComponent.this.txtSearch.setVisible(false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                SCSTreeAndDetailsComponent.this.contractAllResultTree();
            }
        });
        this.txtSearch.addKeyListener(this.getSearchKeyListener());
        this.txtSearch.getDocument().addDocumentListener(this.getSearchDocumentListener());
        this.resultTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    SCSTreeAndDetailsComponent.this.showSearchField();
                    SCSTreeAndDetailsComponent.this.txtSearch.dispatchEvent(e);
                    e.consume();
                }
            }
        });
        this.lblOutOfQueryEntrance = new JLabel("+0");
        this.lblOutOfQueryEntrance.setFont(new Font("Monospaced", 1, 16));
        this.lblOutOfQueryEntrance.setOpaque(false);
        this.lblOutOfQueryEntrance.setVisible(false);
        this.lblOutOfQueryEntrance.setForeground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.lblOutOfQueryRemoval = new JLabel("-0");
        this.lblOutOfQueryRemoval.setFont(new Font("Monospaced", 1, 16));
        this.lblOutOfQueryRemoval.setOpaque(false);
        this.lblOutOfQueryRemoval.setVisible(false);
        this.lblOutOfQueryRemoval.setForeground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.lblOutOfQueryRemoval.setAlignmentX(1.0f);
        this.lblOutOfQueryRemoval.setHorizontalAlignment(4);
        resultLayers.add(scrTree);
        resultLayers.setLayer(scrTree, 0);
        resultLayers.add((Component)this.loadProgressBar, 0);
        resultLayers.setLayer(this.loadProgressBar, 1);
        resultLayers.add((Component)this.lblOutOfQueryEntrance, 0);
        resultLayers.setLayer(this.lblOutOfQueryEntrance, 2);
        resultLayers.add((Component)this.lblOutOfQueryRemoval, 0);
        resultLayers.setLayer(this.lblOutOfQueryRemoval, 2);
        resultLayers.add((Component)this.txtSearch, 0);
        resultLayers.setLayer(this.txtSearch, 3);
        this.loadProgressBar.setVisible(false);
        this.loadProgressBar.setIndeterminate(true);
        this.loadProgressBar.setStringPainted(true);
        this.loadProgressBar.setFont(new Font("Monospaced", 0, 9));
        this.loadProgressBar.setToolTipText("Executando consulta...");
        this.detailsSplit = new JPanel();
        this.detailsSplit.setLayout(new MigLayout("", "0[grow]0", "0[grow]0"));
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new MigLayout("", "0[grow, fill]0", "0[grow, fill]0"));
        this.detailsSplit.add((Component)this.detailsPanel, "flowy, cell 0 0, grow, gap 0");
        this.resultSplit = new JSplitPane(1);
        this.resultSplit.setOneTouchExpandable(true);
        this.resultSplit.setContinuousLayout(true);
        this.resultSplit.setLeftComponent(resultLayers);
        this.resultSplit.setRightComponent(this.detailsSplit);
        this.resultSplit.setDividerLocation(350);
        this.setLayout(new BorderLayout());
        this.add((Component)this.resultSplit, "Center");
    }

    private DocumentListener getSearchDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SCSTreeAndDetailsComponent.this.doSeachInTree();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SCSTreeAndDetailsComponent.this.doSeachInTree();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SCSTreeAndDetailsComponent.this.doSeachInTree();
            }
        };
    }

    private void doSeachInTree() {
        SwingUtilities.invokeLater(new Runnable(){
            DefaultTreeModel model;
            String textToSearch;
            {
                this.model = (DefaultTreeModel)SCSTreeAndDetailsComponent.this.resultTree.getModel();
                this.textToSearch = null;
            }

            @Override
            public void run() {
                this.textToSearch = SCSTreeAndDetailsComponent.this.txtSearch.getText().trim().toLowerCase();
                if (this.textToSearch.isEmpty()) {
                    SCSTreeAndDetailsComponent.this.contractAllResultTree();
                    return;
                }
                if (SCSTreeAndDetailsComponent.this.resultTree.getSelectionRows() != null && SCSTreeAndDetailsComponent.this.resultTree.getSelectionRows().length > 0 && !SCSTreeAndDetailsComponent.this.nodeHasText(SCSTreeAndDetailsComponent.this.resultTree.getPathForRow(SCSTreeAndDetailsComponent.this.resultTree.getSelectionRows()[0]), this.textToSearch)) {
                    SCSTreeAndDetailsComponent.this.resultTree.clearSelection();
                }
                this.doSearchInTree(new TreePath(this.model.getRoot()));
            }

            private boolean doSearchInTree(TreePath path) {
                boolean myRes = false;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node != this.model.getRoot() && SCSTreeAndDetailsComponent.this.nodeHasText(path, this.textToSearch)) {
                    SCSTreeAndDetailsComponent.this.doSelectOnSearch(path);
                    myRes = true;
                }
                boolean childRes = false;
                if (!(node instanceof AsyncExpandableTreeNode)) {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        childRes |= this.doSearchInTree(path.pathByAddingChild(node.getChildAt(i)));
                    }
                }
                if (!childRes && node != this.model.getRoot()) {
                    SCSTreeAndDetailsComponent.this.resultTree.collapsePath(path);
                }
                return myRes || childRes;
            }
        });
    }

    private boolean nodeHasText(TreePath path, String textToSearch) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.toString().toLowerCase().contains(textToSearch)) {
            return true;
        }
        if (node instanceof NodeWithSearchCapability && ((NodeWithSearchCapability)((Object)node)).hasString(textToSearch)) {
            return true;
        }
        return node.getUserObject() != null && node.getUserObject() instanceof NodeWithSearchCapability && ((NodeWithSearchCapability)node.getUserObject()).hasString(textToSearch);
    }

    private void doSelectOnSearch(TreePath path) {
        this.resultTree.expandPath(path.getParentPath());
        if (this.resultTree.getSelectionCount() == 0) {
            this.resultTree.setSelectionPath(path);
            Rectangle bounds = this.resultTree.getPathBounds(path);
            bounds.x = 0;
            this.resultTree.scrollRectToVisible(bounds);
        }
    }

    private KeyListener getSearchKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    SCSTreeAndDetailsComponent.this.txtSearch.setVisible(false);
                }
                if (e.getKeyCode() == 40 || e.getKeyCode() == 10) {
                    e.consume();
                    SCSTreeAndDetailsComponent.this.doSearchForNext(1);
                }
                if (e.getKeyCode() == 38) {
                    e.consume();
                    SCSTreeAndDetailsComponent.this.doSearchForNext(-1);
                }
            }
        };
    }

    protected void doSearchForNext(int interval) {
        if (this.resultTree.getSelectionRows() == null || this.resultTree.getSelectionRows().length == 0) {
            this.doSeachInTree();
            return;
        }
        int selectedRow = this.resultTree.getSelectionRows()[0];
        int currentRow = selectedRow + interval;
        if (currentRow < 0) {
            currentRow = this.resultTree.getRowCount() + currentRow;
        } else if (currentRow >= this.resultTree.getRowCount()) {
            currentRow -= this.resultTree.getRowCount();
        }
        String textToSearch = this.txtSearch.getText().trim().toLowerCase();
        while (currentRow != selectedRow) {
            TreePath path = this.resultTree.getPathForRow(currentRow);
            if (this.nodeHasText(path, textToSearch)) {
                this.resultTree.setSelectionPath(path);
                Rectangle bounds = this.resultTree.getPathBounds(path);
                bounds.x = 0;
                this.resultTree.scrollRectToVisible(bounds);
                return;
            }
            if ((currentRow += interval) < 0) {
                currentRow = this.resultTree.getRowCount() + currentRow;
                continue;
            }
            if (currentRow < this.resultTree.getRowCount()) continue;
            currentRow -= this.resultTree.getRowCount();
        }
    }

    public void showSearchField() {
        this.txtSearch.setVisible(true);
        this.txtSearch.requestFocus();
        this.doSeachInTree();
    }

    void setDetails(JPanel details) {
        this.detailsPanel.removeAll();
        if (details != null) {
            this.detailsPanel.add((Component)details, "cell 0 0, grow");
        }
        this.detailsPanel.validate();
        this.detailsPanel.repaint();
    }

    public FindServicesQueryControlInterface getQueryControlImpl() {
        return this.findServicesQueryControlInterfaceImpl;
    }

    public void setFindServicesQueryControlInterface(FindServicesQueryControlInterface impl) {
        this.findServicesQueryControlInterfaceImpl = impl;
    }

    public SCSTree getTree() {
        return this.resultTree;
    }

    protected void addPanelToBottomDetails(Component component) {
        this.detailsSplit.add(component, "cell 0 0,grow, gapy 0, hidemode 3");
    }

    public ServiceProperty[] getCurrentPropertyFilter() {
        return this.currentPropertyFilter;
    }

    public void setCurrentPropertyFilter(ServiceProperty[] currentPropertyFilter) {
        this.currentPropertyFilter = currentPropertyFilter;
    }

    public void removeOffer(ServiceOfferNode serviceOfferNode) {
        this.treeStructureBuilder.removeOffer(serviceOfferNode);
    }

    protected void addServiceOffer(ManagedConnection cnn, ServiceOfferDesc service, NodeWithTreeReference root) {
        this.treeStructureBuilder.addServiceOffer(cnn, service, root);
    }

    public void startSearch(Connection cnn, ServiceProperty[] filter) {
        ((DefaultTreeModel)this.resultTree.getModel()).setRoot(new NodeWithTreeReference(this.resultTree, "SCS"));
        this.treeStructureBuilder.startLoadingTree(cnn, filter);
    }

    private void contractAllResultTree() {
        for (int i = 0; i < this.resultTree.getRowCount(); ++i) {
            this.resultTree.collapseRow(i);
        }
    }
}

