/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.browser.ConnectionProvider;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.scs_offers.ServiceOfferManagedBean;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferObserver;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferObserverHelper;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferObserverPOA;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferObserverSubscription;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistryObserver;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistryObserverHelper;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistryObserverPOA;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistryObserverSubscription;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOffer;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

final class ServiceOfferRegistryObserversPool {
    private static final String SERVICE_OFFER_OBSERVERS_KEY = "serviceOfferObservers";
    static final Logger logger = Logger.getLogger(ServiceOfferRegistryObserversPool.class.toString());
    private static final ServiceOfferRegistryObserversPool singleton = new ServiceOfferRegistryObserversPool();
    ConnectionProvider connectionProvider = null;
    private OfferRegistryObserver offerRegistryObserver = null;
    private OfferObserver offerObserver = null;
    private final HashMap<String, BusObserverPoolBean> busSubscriptions = new HashMap(4);
    private final CopyOnWriteArrayList<ServiceOfferRegistryObserversPoolListener> offerRegistryListeners = new CopyOnWriteArrayList();
    private ORB orb;
    private final OfferRegistryObserverPOA offerRegistryObserverPOA = new OfferRegistryObserverPOA(){

        @Override
        public void offerRegistered(ServiceOfferDesc offer) {
            OpenBusContext ctx = ServiceOfferRegistryObserversPool.this.getOpenBusContext();
            ManagedConnection myCnn = ServiceOfferRegistryObserversPool.this.connectionProvider.getManagedConnectionOf(ctx.getCurrentConnection());
            for (ServiceOfferRegistryObserversPoolListener l : ServiceOfferRegistryObserversPool.this.offerRegistryListeners) {
                try {
                    l.offerRegistered(myCnn, offer);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exce\u00e7\u00e3o ignorada ao chamar listener interno do servi\u00e7o de ofertas.", e);
                }
            }
        }
    };
    private final OfferObserverPOA offerObserverPOA = new OfferObserverPOA(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removed(ServiceOfferDesc offer) {
            BusObserverPoolBean busBean;
            OpenBusContext ctx = ServiceOfferRegistryObserversPool.this.getOpenBusContext();
            Map<java.lang.Object, java.lang.Object> map = ServiceOfferRegistryObserversPool.this.busSubscriptions;
            synchronized (map) {
                busBean = (BusObserverPoolBean)ServiceOfferRegistryObserversPool.this.busSubscriptions.get(ctx.getCurrentConnection().busid());
            }
            if (busBean == null) {
                logger.warning("OfferObserver.removed() chamado sem que eu tenha um busid criado: busid=" + ctx.getCurrentConnection().busid());
                return;
            }
            map = busBean.controlledBeans;
            synchronized (map) {
                ServiceOfferManagedBean myBean = busBean.getControlledBean(offer.ref);
                if (myBean == null) {
                    throw new IllegalStateException("Oferta n\u00e3o identificada no pool: " + offer.ref);
                }
                myBean.notifyRemoved();
                myBean.offerObserverSubscription = null;
                busBean.controlledBeans.remove(offer.ref);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertiesChanged(ServiceOfferDesc offer) {
            BusObserverPoolBean busBean;
            OpenBusContext ctx = ServiceOfferRegistryObserversPool.this.getOpenBusContext();
            HashMap hashMap = ServiceOfferRegistryObserversPool.this.busSubscriptions;
            synchronized (hashMap) {
                busBean = (BusObserverPoolBean)ServiceOfferRegistryObserversPool.this.busSubscriptions.get(ctx.getCurrentConnection().busid());
            }
            ServiceOfferManagedBean myBean = busBean.getControlledBean(offer.ref);
            if (myBean == null) {
                throw new IllegalStateException("Oferta n\u00e3o identificada no pool: " + offer.ref);
            }
            myBean.notifyChanged();
        }
    };
    private final ManagedConnection.LogoffSyncListener connectionObserver = new ManagedConnection.LogoffSyncListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preLogoff(ManagedConnection cnn) {
            if (cnn.getState() == ManagedConnection.ConnectionState.DISCONNECTING) {
                cnn.setContextCurrentConnection();
                int connectionsWithSameBusID = ServiceOfferRegistryObserversPool.this.connectionProvider.getNumActiveConnectionsOfBusID(cnn.busid());
                logger.fine("desconectando: Conex\u00f5es com o mesmo busid=" + connectionsWithSameBusID);
                if (connectionsWithSameBusID == 1) {
                    HashMap hashMap = ServiceOfferRegistryObserversPool.this.busSubscriptions;
                    synchronized (hashMap) {
                        BusObserverPoolBean busBean = (BusObserverPoolBean)ServiceOfferRegistryObserversPool.this.busSubscriptions.remove(cnn.busid());
                        if (busBean != null) {
                            busBean.clearSubscriptions();
                        }
                    }
                }
            }
        }
    };

    private ServiceOfferRegistryObserversPool() {
    }

    public static final ServiceOfferRegistryObserversPool getSingleton() {
        return singleton;
    }

    private final void startup(ORB orb) {
        if (this.orb != null) {
            throw new IllegalStateException("N\u00e3o posso inicializar duas vezes!");
        }
        logger.fine("Startup(orb=" + System.identityHashCode(orb) + ")");
        this.orb = orb;
        try {
            POA poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            Object offerRegistryObserverObject = poa.servant_to_reference(this.offerRegistryObserverPOA);
            this.offerRegistryObserver = OfferRegistryObserverHelper.narrow(offerRegistryObserverObject);
            Object offerObserverObject = poa.servant_to_reference(this.offerObserverPOA);
            this.offerObserver = OfferObserverHelper.narrow(offerObserverObject);
        }
        catch (Exception e1) {
            throw new IllegalStateException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceOfferManagedBean addNewServiceOfferBean(Connection cnn, ServiceOffer serviceOffer) throws ServiceFailure {
        ServiceOfferManagedBean res;
        if (!ServiceOfferRegistryObserversPool.getServiceOfferObserversSystemPropertyValue()) {
            ServiceOfferManagedBean newBean = new ServiceOfferManagedBean(this, null, serviceOffer, null);
            return newBean;
        }
        ManagedConnection.setContextCurrentConnection(cnn);
        ServiceOfferRegistryObserversPool newBean = this;
        synchronized (newBean) {
            if (this.orb == null) {
                this.startup(cnn.orb());
            }
        }
        BusObserverPoolBean busBean = this.getBusObserverPoolBean(cnn);
        Map<ServiceOffer, WeakReference<ServiceOfferManagedBean>> map = busBean.controlledBeans;
        synchronized (map) {
            res = busBean.getControlledBean(serviceOffer);
            if (res == null) {
                OfferObserverSubscription offerObserverSubscription = serviceOffer.subscribeObserver(this.offerObserver);
                logger.fine("Listener de oferta criado: " + offerObserverSubscription.toString());
                ServiceOfferManagedBean newBean2 = new ServiceOfferManagedBean(this, busBean, serviceOffer, offerObserverSubscription);
                busBean.controlledBeans.put(serviceOffer, new WeakReference<ServiceOfferManagedBean>(newBean2));
                res = newBean2;
            }
        }
        if (cnn instanceof ManagedConnection) {
            ManagedConnection mCnn = (ManagedConnection)cnn;
            mCnn.removeLogoffSyncListener(this.connectionObserver);
            mCnn.addLogoffSyncListener(this.connectionObserver);
        }
        return res;
    }

    public static final boolean getServiceOfferObserversSystemPropertyValue() {
        String propertyValue = System.getProperty(SERVICE_OFFER_OBSERVERS_KEY);
        if (propertyValue == null) {
            return true;
        }
        return (propertyValue = propertyValue.toLowerCase().trim()).equals("on") || propertyValue.equals("true") || propertyValue.equals("1") || propertyValue.equals("yes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BusObserverPoolBean getBusObserverPoolBean(Connection cnn) throws ServiceFailure {
        HashMap<String, BusObserverPoolBean> hashMap = this.busSubscriptions;
        synchronized (hashMap) {
            BusObserverPoolBean busBean = this.busSubscriptions.get(cnn.busid());
            if (busBean == null) {
                busBean = new BusObserverPoolBean();
                busBean.busId = cnn.busid();
                ServiceProperty[] genericFilter = new ServiceProperty[]{new ServiceProperty("openbus.component.facet", "IComponent")};
                busBean.subscription = ManagedConnection.getContext(cnn).getOfferRegistry().subscribeObserver(this.offerRegistryObserver, genericFilter);
                logger.fine("Registrado observador do busid=" + cnn.busid());
                this.busSubscriptions.put(cnn.busid(), busBean);
            }
            return busBean;
        }
    }

    private OpenBusContext getOpenBusContext() {
        OpenBusContext ctx;
        try {
            ctx = (OpenBusContext)((java.lang.Object)this.orb.resolve_initial_references("OpenBusContext"));
        }
        catch (InvalidName e) {
            throw new IllegalStateException("Isto realmente n\u00e3o deveria ter acontecido. Comece a rezar.", e);
        }
        return ctx;
    }

    public void addListener(ServiceOfferRegistryObserversPoolListener listener) {
        this.offerRegistryListeners.add(listener);
    }

    public void removeListener(ServiceOfferRegistryObserversPoolListener listener) {
        this.offerRegistryListeners.remove(listener);
    }

    protected void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public static final String getOfferID(ServiceOffer offer) {
        ServiceProperty[] properties = offer.properties();
        if (properties == null) {
            return null;
        }
        for (ServiceProperty p : properties) {
            if (p == null || !"openbus.offer.id".equals(p.name)) continue;
            return p.value;
        }
        return null;
    }

    public static interface ServiceOfferRegistryObserversPoolListener {
        public void offerRegistered(ManagedConnection var1, ServiceOfferDesc var2);
    }

    final class BusObserverPoolBean {
        String busId;
        OfferRegistryObserverSubscription subscription;
        public final Map<ServiceOffer, WeakReference<ServiceOfferManagedBean>> controlledBeans = new WeakHashMap<ServiceOffer, WeakReference<ServiceOfferManagedBean>>();

        BusObserverPoolBean() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceOfferManagedBean getControlledBean(ServiceOffer key) {
            Map<ServiceOffer, WeakReference<ServiceOfferManagedBean>> map = this.controlledBeans;
            synchronized (map) {
                WeakReference<ServiceOfferManagedBean> wBean = this.controlledBeans.get(key);
                if (wBean == null) {
                    return null;
                }
                return (ServiceOfferManagedBean)wBean.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearSubscriptions() {
            ServiceOffer[] monitoredOffers;
            if (this.subscription != null) {
                logger.fine("Removendo listener do busid=" + this.busId);
                try {
                    this.subscription.remove();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exce\u00e7\u00e3o ignorada ao remover listener do servi\u00e7o de ofertas.", e);
                }
                this.subscription = null;
            }
            Map<ServiceOffer, WeakReference<ServiceOfferManagedBean>> map = this.controlledBeans;
            synchronized (map) {
                monitoredOffers = this.controlledBeans.keySet().toArray(new ServiceOffer[0]);
            }
            for (ServiceOffer o : monitoredOffers) {
                ServiceOfferManagedBean bean = this.getControlledBean(o);
                if (bean == null) continue;
                try {
                    bean.removeSubscriber();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exce\u00e7\u00e3o ignorada ao remover listener de oferta.", e);
                }
            }
            map = this.controlledBeans;
            synchronized (map) {
                this.controlledBeans.clear();
            }
        }
    }
}

