/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.omg.CORBA.Object;
import scs.core.IMetaInterface;
import scs.core.IMetaInterfaceHelper;
import scs.core.IReceptacles;
import scs.core.ReceptacleDescription;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.SlowRequester;
import tecgraf.openbus.browser.TipPanelInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithDetailsInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithDropBehaviorInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithHelpTipInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;
import tecgraf.openbus.browser.scs_offers.RefreshableNode;
import tecgraf.openbus.browser.scs_offers.basic_nodes.FacetNodeBean;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ReceptacleNodeDetailsPanel;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;

public final class ReceptacleNodeBean
implements NodeWithDropBehaviorInterface,
RefreshableNode,
NodeWithIconsInterface,
NodeWithDetailsInterface,
NodeWithHelpTipInterface {
    private final ServiceOfferDesc service;
    private ReceptacleDescription receptacleDescription;
    private final IReceptacles iReceptacles;
    private final Connection cnn;
    private WeakReference<ReceptacleNodeDetailsPanel> detailsPanel = null;
    private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("receptacle.png"));

    public ReceptacleNodeBean(Connection cnn, ServiceOfferDesc service, ReceptacleDescription receptacleDescription, IReceptacles iReceptacles) {
        this.cnn = cnn;
        this.service = service;
        this.receptacleDescription = receptacleDescription;
        this.iReceptacles = iReceptacles;
    }

    public final ReceptacleDescription getReceptacleDescription() {
        return this.receptacleDescription;
    }

    public IReceptacles getIReceptacles() {
        return this.iReceptacles;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.receptacleDescription.name);
        res.append("(");
        res.append(this.receptacleDescription.interface_name);
        res.append(")");
        if (this.receptacleDescription.is_multiplex) {
            res.append("(multiplex)");
        }
        res.append("[");
        res.append(this.receptacleDescription.connections.length);
        res.append("]");
        return res.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.receptacleDescription == null ? 0 : this.receptacleDescription.hashCode());
        return result;
    }

    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceptacleNodeBean)) {
            return false;
        }
        ReceptacleNodeBean other = (ReceptacleNodeBean)obj;
        if (this.receptacleDescription == null) {
            if (other.receptacleDescription != null) {
                return false;
            }
        } else {
            if (!this.receptacleDescription.name.equals(other.receptacleDescription.name)) {
                return false;
            }
            if (!this.receptacleDescription.interface_name.equals(other.receptacleDescription.interface_name)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int accept(DataFlavor dataFlavor) {
        if (FacetNodeBean.FACET_DESCRIPTION_DATA_FLAVOR.equals(dataFlavor)) {
            if (dataFlavor.getHumanPresentableName() == null || dataFlavor.getHumanPresentableName().trim().isEmpty()) {
                return 3;
            }
            return dataFlavor.getHumanPresentableName().equals(this.receptacleDescription.interface_name) ? 3 : 0;
        }
        return 0;
    }

    @Override
    public boolean doDrop(final Transferable transferable) throws Exception {
        if (!transferable.isDataFlavorSupported(FacetNodeBean.FACET_DESCRIPTION_DATA_FLAVOR)) {
            return false;
        }
        SlowRequester.run(new SlowRequester.SlowRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                try {
                    ManagedConnection.setContextCurrentConnection(ReceptacleNodeBean.this.cnn);
                    FacetNodeBean.TransferableFacetDescription facetDescription = (FacetNodeBean.TransferableFacetDescription)transferable.getTransferData(FacetNodeBean.FACET_DESCRIPTION_DATA_FLAVOR);
                    Object facet_ref = ReceptacleNodeBean.this.cnn.orb().string_to_object(facetDescription.ior);
                    ReceptacleNodeBean.this.iReceptacles.connect(((ReceptacleNodeBean)ReceptacleNodeBean.this).receptacleDescription.name, facet_ref);
                }
                finally {
                    ReceptacleNodeBean.this.refreshNode();
                }
            }
        }, true);
        return true;
    }

    @Override
    public void refreshNode() throws Exception {
        ManagedConnection.setContextCurrentConnection(this.cnn);
        Object metaInterfaceObject = this.service.service_ref.getFacetByName("IMetaInterface");
        IMetaInterface metaInterface = IMetaInterfaceHelper.narrow(metaInterfaceObject);
        this.receptacleDescription = metaInterface.getReceptaclesByName(new String[]{this.receptacleDescription.name})[0];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ReceptacleNodeDetailsPanel)ReceptacleNodeBean.this.getDetailsPanel()).reloadConnectionList();
            }
        });
    }

    @Override
    public Icon getClosedIcon() {
        return icon;
    }

    @Override
    public Icon getLeafIcon() {
        return icon;
    }

    @Override
    public Icon getOpenedIcon() {
        return icon;
    }

    @Override
    public JPanel getDetailsPanel() {
        ReceptacleNodeDetailsPanel res = null;
        if (this.detailsPanel != null) {
            res = (ReceptacleNodeDetailsPanel)this.detailsPanel.get();
        }
        if (res == null) {
            res = new ReceptacleNodeDetailsPanel(this.cnn, this);
            this.detailsPanel = new WeakReference<ReceptacleNodeDetailsPanel>(res);
        }
        return res;
    }

    @Override
    public void configureHelpTip(TipPanelInterface tipPanel) {
        tipPanel.setTips(new String[]{"Para conectar a faceta a um recept\u00e1culo que a suporte, voc\u00ea pode arrastar o n\u00f3 da \u00e1rvore at\u00e9 um n\u00f3 do recept\u00e1culo desejado.", "Para conectar a faceta a um recept\u00e1culo, voc\u00ea pode \"copiar e colar\" o n\u00f3 da faceta no n\u00f3 do recept\u00e1culo."}, new String[]{"N\u00e3o desconecte os recept\u00e1culos dos coleguinhas."});
    }
}

