/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.scs_offers.FindServicesQueryControlInterface;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;

final class ServiceOfferNodeDetailsPanel
extends JPanel {
    private final ServiceOfferDesc offerDesc;
    private final JTable propTable;
    private final FindServicesQueryControlInterface queryControl;

    public ServiceOfferNodeDetailsPanel(FindServicesQueryControlInterface queryControl, ServiceOfferDesc offerDesc) {
        this.queryControl = queryControl;
        this.offerDesc = offerDesc;
        this.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(0, 0));
        JScrollPane scrPropTable = new JScrollPane();
        this.add((Component)scrPropTable, "cell 0 0,grow");
        this.propTable = new JTable();
        this.refresh();
        scrPropTable.setViewportView(this.propTable);
        this.propTable.addMouseListener(this.getPropTableMouseListener());
    }

    public void refresh() {
        this.propTable.setModel(new DefaultTableModel(this.getPropertiesForTable(), new String[]{"Propriedade", "Valor"}){
            Class<?>[] columnTypes;
            boolean[] columnEditables;
            {
                this.columnTypes = new Class[]{String.class, String.class};
                this.columnEditables = new boolean[]{false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return this.columnEditables[column];
            }
        });
    }

    private MouseListener getPropTableMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && ServiceOfferNodeDetailsPanel.this.queryControl != null) {
                    if (ServiceOfferNodeDetailsPanel.this.propTable.getSelectedRows() == null || ServiceOfferNodeDetailsPanel.this.propTable.getSelectedRows().length == 0) {
                        return;
                    }
                    JPopupMenu propertyPopup = new JPopupMenu();
                    propertyPopup.add(ServiceOfferNodeDetailsPanel.this.getAddCriteriaItem(ServiceOfferNodeDetailsPanel.this.propTable.getSelectedRows()));
                    propertyPopup.show(ServiceOfferNodeDetailsPanel.this.propTable, e.getX(), e.getY());
                }
            }
        };
    }

    protected JMenuItem getAddCriteriaItem(final int[] selectedRows) {
        JMenuItem res = new JMenuItem(selectedRows.length == 1 ? "Adicionar propriedade ao crit\u00e9rio" : "Adicionar propriedades ao crit\u00e9rio");
        res.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int row : selectedRows) {
                    int mRow = ServiceOfferNodeDetailsPanel.this.propTable.getRowSorter() != null ? ServiceOfferNodeDetailsPanel.this.propTable.getRowSorter().convertRowIndexToModel(row) : row;
                    ServiceOfferNodeDetailsPanel.this.queryControl.addCriteria(ServiceOfferNodeDetailsPanel.this.propTable.getModel().getValueAt(mRow, 0).toString(), ServiceOfferNodeDetailsPanel.this.propTable.getModel().getValueAt(mRow, 1).toString());
                }
            }
        });
        return res;
    }

    private Object[][] getPropertiesForTable() {
        Object[][] res = new Object[this.offerDesc.properties.length][];
        for (int i = 0; i < this.offerDesc.properties.length; ++i) {
            res[i] = new Object[]{this.offerDesc.properties[i].name, this.offerDesc.properties[i].value};
        }
        return res;
    }
}

