/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.RequestInfo;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.security.Cryptography;

abstract class InterceptorImpl
extends LocalObject
implements Interceptor {
    protected static final byte BUS_MAJOR_VERSION = 2;
    protected static final byte BUS_MINOR_VERSION = 0;
    protected static final int HASH_VALUE_SIZE = 32;
    protected static final byte[] NULL_HASH_VALUE = new byte[32];
    protected static final int ENCRYPTED_BLOCK_SIZE = 256;
    protected static final byte[] NULL_ENCRYPTED_BLOCK = new byte[256];
    protected static final SignedCallChain NULL_SIGNED_CALL_CHAIN = new SignedCallChain(NULL_ENCRYPTED_BLOCK, new byte[0]);
    protected static final byte[] LEGACY_ENCRYPTED_BLOCK = new byte[256];
    protected static final byte[] LEGACY_HASH = new byte[32];
    private String name;
    private ORBMediator mediator;

    protected InterceptorImpl(String name, ORBMediator mediator) {
        this.name = name;
        this.mediator = mediator;
        Arrays.fill(LEGACY_ENCRYPTED_BLOCK, (byte)-1);
        Arrays.fill(LEGACY_HASH, (byte)-1);
    }

    @Override
    public String name() {
        return this.name;
    }

    protected final ORBMediator getMediator() {
        return this.mediator;
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] generateCredentialDataHash(RequestInfo ri, byte[] secret, int ticket) {
        try {
            MessageDigest hashAlgorithm;
            Cryptography crypto = Cryptography.getInstance();
            MessageDigest messageDigest = hashAlgorithm = crypto.getHashAlgorithm();
            synchronized (messageDigest) {
                hashAlgorithm.update((byte)2);
                hashAlgorithm.update((byte)0);
                hashAlgorithm.update(secret);
                ByteBuffer ticketBuffer = ByteBuffer.allocate(4);
                ticketBuffer.order(ByteOrder.LITTLE_ENDIAN);
                ticketBuffer.putInt(ticket);
                ticketBuffer.flip();
                hashAlgorithm.update(ticketBuffer);
                byte[] operationBytes = ri.operation().getBytes(Cryptography.CHARSET);
                hashAlgorithm.update(operationBytes);
                return hashAlgorithm.digest();
            }
        }
        catch (CryptographyException e) {
            String message = "Falha inesperada ao calcular o hash da credencial";
            throw new INTERNAL(message);
        }
    }

    protected CallChain unmarshallSignedChain(SignedCallChain chain, Logger logger) {
        try {
            Any any = this.getMediator().getCodec().decode_value(chain.encoded, CallChainHelper.type());
            CallChain callChain = CallChainHelper.extract(any);
            return callChain;
        }
        catch (FormatMismatch e) {
            String message = "Falha inesperada ao decodificar a cadeia";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        catch (TypeMismatch e) {
            String message = "Falha inesperada ao decodificar a cadeia";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }
}

