/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.data_service.core.v1_01;

import java.io.UnsupportedEncodingException;
import tecgraf.openbus.data_service.core.v1_01.InvalidDataKey;

public final class DataKeyWrapper {
    private static final String VERSION = "v1_01";
    private static final String CHARSET_NAME = "ISO-8859-1";
    private static final String SEPARATOR = ";";
    private static final int ELEMENTS_COUNT = 4;
    private byte[] key;
    private String systemDeploymentId;
    private String dataSourceId;
    private String dataId;

    public DataKeyWrapper(byte[] key) throws InvalidDataKey {
        if (key == null) {
            throw new IllegalArgumentException("A chave n\u00e3o pode ser nula.");
        }
        try {
            String keyString = new String(key, CHARSET_NAME);
            String[] splittedKeyString = keyString.split(SEPARATOR);
            if (splittedKeyString.length != 4) {
                throw new InvalidDataKey(new byte[][]{key});
            }
            if (!splittedKeyString[0].equals(VERSION)) {
                throw new InvalidDataKey(new byte[][]{key});
            }
            this.systemDeploymentId = splittedKeyString[1];
            this.dataSourceId = splittedKeyString[2];
            this.dataId = splittedKeyString[3];
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidDataKey(new byte[][]{key});
        }
        this.key = new byte[key.length];
        System.arraycopy(key, 0, this.key, 0, key.length);
    }

    public DataKeyWrapper(String systemDeploymentId, String dataSourceId, String dataId) throws InvalidDataKey {
        if (systemDeploymentId == null || systemDeploymentId.equals("")) {
            throw new IllegalArgumentException("O identificador da implanta\u00e7\u00e3o do sistema de origem do dado n\u00e3o pode ser nulo ou vazio.");
        }
        if (dataSourceId == null || dataSourceId.equals("")) {
            throw new IllegalArgumentException("O identificador da fonte do dado n\u00e3o pode ser nulo ou vazio.");
        }
        if (dataId == null || dataId.equals("")) {
            throw new IllegalArgumentException("O identificador real do dado n\u00e3o pode ser nulo ou vazio.");
        }
        this.systemDeploymentId = systemDeploymentId;
        this.dataSourceId = dataSourceId;
        this.dataId = dataId;
        StringBuilder builder = new StringBuilder();
        builder.append(VERSION);
        builder.append(SEPARATOR);
        builder.append(this.systemDeploymentId);
        builder.append(SEPARATOR);
        builder.append(this.dataSourceId);
        builder.append(SEPARATOR);
        builder.append(this.dataId);
        try {
            this.key = builder.toString().getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidDataKey();
        }
    }

    public String getSystemDeploymentId() {
        return this.systemDeploymentId;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public byte[] getKey() {
        return this.key;
    }
}

