/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.etf.ListenEndpoint;
import org.jacorb.orb.etf.ListenerBase;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirServerReplyListener;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.ServerRequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.poa.except.ParentIsHolding;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.ETF.Connection;
import org.omg.ETF.Factories;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.ETF._HandleLocalBase;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.slf4j.Logger;

public class BasicAdapter
extends _HandleLocalBase
implements Configurable {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private MessageReceptorPool receptor_pool = null;
    private final ServerRequestListener request_listener;
    private ReplyListener reply_listener = null;
    private final TransportManager transport_manager;
    private final GIOPConnectionManager giop_connection_manager;
    private Configuration configuration = null;
    private Logger logger = null;
    private final ORB orb;

    BasicAdapter(ORB orb, org.jacorb.poa.POA poa, TransportManager transport_manager, GIOPConnectionManager giop_connection_manager) {
        this.orb = orb;
        this.transport_manager = transport_manager;
        this.giop_connection_manager = giop_connection_manager;
        this.request_listener = new ServerRequestListener(orb, poa);
    }

    @Override
    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("org.jacorb.orb.basic");
        this.receptor_pool = new MessageReceptorPool("server", "ServerMessageReceptor", myConfiguration);
        this.request_listener.configure(this.configuration);
        this.reply_listener = new NoBiDirServerReplyListener();
        for (Factories factories : this.getListenerFactories()) {
            ListenEndpoint.Protocol p = ListenEndpoint.Protocol.mapProfileTag(factories.profile_tag());
            Iterator<ListenEndpoint> it = this.transport_manager.getListenEndpoints(p).iterator();
            while (it.hasNext()) {
                Listener listener = factories.create_listener(null, 0, (short)0);
                ListenEndpoint le = it.next();
                if (listener instanceof ListenerBase) {
                    ((ListenerBase)listener).setListenEndpoint(le);
                }
                if (listener instanceof Configurable) {
                    ((Configurable)((Object)listener)).configure(this.configuration);
                }
                listener.set_handle(this);
                this.listeners.add(listener);
            }
        }
        Iterator<IDLEntity> i = this.listeners.iterator();
        while (i.hasNext()) {
            ((Listener)i.next()).listen();
        }
    }

    private List<Factories> getListenerFactories() {
        ArrayList<Factories> result = new ArrayList<Factories>();
        List<String> tags = this.configuration.getAttributeList("jacorb.transport.server.listeners");
        if (tags.isEmpty()) {
            result.addAll(this.transport_manager.getFactoriesList());
        } else {
            if (tags.contains("off")) {
                tags.remove("off");
            }
            for (String s : tags) {
                int tag = -1;
                try {
                    tag = Integer.parseInt(s);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("could not parse profile tag for listener: " + s + " (should have been a number)");
                }
                Factories factories = this.transport_manager.getFactories(tag);
                if (factories == null) {
                    throw new IllegalArgumentException("could not find Factories for profile tag: " + tag);
                }
                result.add(factories);
            }
        }
        return result;
    }

    public RequestListener getRequestListener() {
        return this.request_listener;
    }

    public List<Profile> getEndpointProfiles() {
        ArrayList<Profile> result = new ArrayList<Profile>();
        for (Listener listener : this.listeners) {
            result.add(listener.endpoint());
        }
        return result;
    }

    private IIOPListener getIIOPListener() {
        if (this.listeners.size() == 1) {
            Listener listener = this.listeners.get(0);
            if (listener instanceof IIOPListener) {
                return (IIOPListener)listener;
            }
            return null;
        }
        return null;
    }

    @Deprecated
    public int getPort() {
        IIOPListener l = this.getIIOPListener();
        if (l != null) {
            IIOPProfile profile = (IIOPProfile)l.endpoint();
            return ((IIOPAddress)profile.getAddress()).getPort();
        }
        throw new RuntimeException("Cannot find server port for non-IIOP transport");
    }

    @Deprecated
    public int getSSLPort() {
        IIOPListener listener = this.getIIOPListener();
        if (listener != null) {
            return ((IIOPProfile)listener.endpoint()).getSSLPort();
        }
        throw new RuntimeException("Non-IIOP transport does not have an SSL port");
    }

    @Deprecated
    public boolean hasSSLListener() {
        return this.getSSLPort() != -1;
    }

    @Deprecated
    public String getAddress() {
        IIOPListener l = this.getIIOPListener();
        if (l != null) {
            IIOPProfile profile = (IIOPProfile)l.endpoint();
            return ((IIOPAddress)profile.getAddress()).getHostname();
        }
        throw new RuntimeException("Cannot find server address for non-IIOP transport");
    }

    public void deliverRequest(ServerRequest request, POA poa) {
        org.jacorb.poa.POA tmp_poa = (org.jacorb.poa.POA)poa;
        String[] scopes = request.remainingPOAName();
        try {
            for (int i = 0; i < scopes.length && !scopes[i].equals(""); ++i) {
                try {
                    tmp_poa = tmp_poa._getChildPOA(scopes[i]);
                    continue;
                }
                catch (ParentIsHolding p) {
                    String[] rest_of_name = new String[scopes.length - i];
                    for (int j = 0; j < rest_of_name.length; ++j) {
                        rest_of_name[j] = scopes[j + i];
                    }
                    request.setRemainingPOAName(rest_of_name);
                    break;
                }
            }
            if (tmp_poa == null) {
                throw new INTERNAL("Request POA null!");
            }
            tmp_poa._invoke(request);
        }
        catch (WrongAdapter e) {
            request.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            request.reply();
        }
        catch (SystemException e) {
            request.setSystemException(e);
            request.reply();
        }
        catch (RuntimeException e) {
            request.setSystemException(new UNKNOWN(e.toString()));
            request.reply();
            this.logger.warn("unexpected exception", e);
        }
        catch (Throwable e) {
            request.setSystemException(new UNKNOWN(e.toString()));
            request.reply();
            this.logger.error("unexpected exception", e);
        }
    }

    public void return_result(ServerRequest request) {
        request.reply();
    }

    public void stopListeners() {
        Iterator<Listener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
        this.receptor_pool.shutdown();
    }

    public void renewSSLServerSockets() {
        for (Listener o : this.listeners) {
            if (!(o instanceof IIOPListener)) continue;
            ((IIOPListener)o).renewSSLServerSocket();
        }
    }

    @Override
    public boolean add_input(Connection conn) {
        ServerGIOPConnection giopConnection = this.giop_connection_manager.createServerGIOPConnection(conn.get_server_profile(), conn, this.request_listener, this.reply_listener);
        if (giopConnection == null) {
            return false;
        }
        this.receptor_pool.connectionCreated(giopConnection);
        return true;
    }

    @Override
    public void closed_by_peer(Connection conn) {
        throw new NO_IMPLEMENT();
    }

    @Override
    public void signal_data_available(Connection conn) {
        throw new NO_IMPLEMENT();
    }

    public ORB getORB() {
        return this.orb;
    }
}

