/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.etf.FactoriesBase;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.ClientIIOPConnection;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfileHolder;

public class IIOPFactories
extends FactoriesBase {
    @Override
    public ProfileBase demarshal_profile(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder components) {
        IIOPProfile profile = new IIOPProfile();
        this.configureResult(profile);
        profile.demarshal(tagged_profile, components);
        return profile;
    }

    @Override
    protected ProtocolAddressBase create_address_internal() {
        return new IIOPAddress();
    }

    @Override
    protected Connection create_connection_internal() {
        return new ClientIIOPConnection();
    }

    @Override
    protected Listener create_listener_internal() {
        return new IIOPListener();
    }

    @Override
    public int profile_tag() {
        return 0;
    }

    @Override
    public Profile decode_corbaloc(String corbaloc) {
        int colon = corbaloc.indexOf(58);
        String token2 = corbaloc.substring(0, colon).toLowerCase();
        if (token2.length() == 0 || "iiop".equals(token2) || "ssliop".equals(token2)) {
            IIOPProfile result = new IIOPProfile(corbaloc);
            try {
                result.configure(this.configuration);
            }
            catch (ConfigurationException e) {
                throw new INTERNAL("ConfigurationException: " + e);
            }
            return result;
        }
        return null;
    }

    @Override
    public int match_tag(String address) {
        if (address == null) {
            return -1;
        }
        int colon = address.indexOf(58);
        String token2 = address.substring(0, colon).toLowerCase();
        if ("iiop".equals(token2) || "ssliop".equals(token2)) {
            return colon + 1;
        }
        return -1;
    }
}

