/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.browser.AsyncObservable;
import tecgraf.openbus.browser.ConnectionProvider;
import tecgraf.openbus.browser.ManagedConnection;

class ManagedConnectionPool
extends Observable
implements ConnectionProvider {
    private final List<ManagedConnection> conns = new CopyOnWriteArrayList<ManagedConnection>();
    private volatile ManagedConnection preferedConn;
    private final Logger logger = Logger.getLogger(ManagedConnectionPool.class.getName());
    private final OpenBusContext openBusContext;
    private final CallDispatchCallback callDispatchCallback = new CallDispatchCallback(){

        @Override
        public Connection dispatch(OpenBusContext context, String busid, String loginId, byte[] object_id, String operation) {
            ManagedConnection res = ManagedConnectionPool.this.getActiveConnectionsOfBusID(busid);
            if (res != null) {
                res.incrementDispatchesToMeCounter();
                return res.getMyConnection();
            }
            ManagedConnectionPool.this.logger.warning("Requisi\u00e7\u00e3o de entrada para ORB recebida sem nenhuma conex\u00e3o aberta!Detalhes: busid=" + busid + ", loginid=" + loginId + ", operation=" + operation);
            return null;
        }
    };
    private final AsyncObservable.AsyncObserver connectionObserver = new AsyncObservable.AsyncObserver(){

        @Override
        public void event(AsyncObservable src) {
            ManagedConnectionPool.this.setChanged();
            ManagedConnectionPool.this.notifyObservers();
        }
    };

    public ManagedConnectionPool(OpenBusContext openBusContext) {
        this.openBusContext = openBusContext;
        this.openBusContext.onCallDispatch(this.callDispatchCallback);
    }

    private void addConnection(ManagedConnection cnn) {
        this.conns.add(cnn);
        cnn.addObserver(this.connectionObserver);
        this.setChanged();
    }

    public ManagedConnection createAndAddConnection(String host, int port, String entity, String password) {
        ManagedConnection res = new ManagedConnection(this.openBusContext, host, port, entity, password);
        this.addConnection(res);
        return res;
    }

    public ManagedConnection createAndAddConnection(String host, int port, String entity, File keyFile) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        ManagedConnection res = new ManagedConnection(this.openBusContext, host, port, entity, keyFile);
        this.addConnection(res);
        return res;
    }

    public boolean removeConnection(ManagedConnection cnn) {
        if (this.preferedConn == cnn) {
            this.preferedConn = null;
        }
        if (cnn.getState() == ManagedConnection.ConnectionState.AUTENTICATED) {
            try {
                cnn.logout();
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        }
        cnn.removeObserver(this.connectionObserver);
        return this.conns.remove(cnn);
    }

    public final void setPreferredConnection(ManagedConnection cnn) {
        if (!this.conns.remove(cnn)) {
            throw new IllegalStateException("Conex\u00e3o n\u00e3o est\u00e1 no pool!");
        }
        this.preferedConn = cnn;
        this.conns.add(0, cnn);
        this.setChanged();
    }

    public final ManagedConnection getPreferredConnection() {
        ManagedConnection pref = this.preferedConn;
        if (pref != null && pref.getState() == ManagedConnection.ConnectionState.AUTENTICATED) {
            return pref;
        }
        return null;
    }

    @Override
    public ManagedConnection getConnectionToUse() {
        ManagedConnection res = this.getPreferredConnection();
        if (res != null) {
            return res;
        }
        for (ManagedConnection cnn : this.conns) {
            if (cnn.getState() != ManagedConnection.ConnectionState.AUTENTICATED) continue;
            return cnn;
        }
        return null;
    }

    @Override
    public ManagedConnection getManagedConnectionOf(Connection primitiveConnection) {
        for (ManagedConnection cnn : this.conns) {
            if (cnn.getMyConnection() != primitiveConnection) continue;
            return cnn;
        }
        return null;
    }

    @Override
    public int getNumActiveConnectionsOfBusID(String busID) {
        int res = 0;
        for (ManagedConnection cnn : this.conns) {
            if (!cnn.busid().equals(busID) || cnn.getState() != ManagedConnection.ConnectionState.AUTENTICATED && cnn.getState() != ManagedConnection.ConnectionState.DISCONNECTING) continue;
            ++res;
        }
        return res;
    }

    @Override
    public ManagedConnection getActiveConnectionsOfBusID(String busID) {
        ManagedConnection res = this.getPreferredConnection();
        if (res != null && res.busid().equals(busID)) {
            return res;
        }
        for (ManagedConnection cnn : this.conns) {
            if (!cnn.busid().equals(busID) || cnn.getState() != ManagedConnection.ConnectionState.AUTENTICATED && cnn.getState() != ManagedConnection.ConnectionState.DISCONNECTING) continue;
            return cnn;
        }
        return null;
    }

    public synchronized void shutdown() {
        this.preferedConn = null;
        for (ManagedConnection cnn : this.conns) {
            try {
                if (cnn.getState() != ManagedConnection.ConnectionState.DISCONNECTED) {
                    cnn.logout();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            cnn.removeObserver(this.connectionObserver);
        }
        this.conns.clear();
    }

    public OpenBusContext getOpenBusContext() {
        return this.openBusContext;
    }
}

