/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.eclipse.wb.swing.FocusTraversalOnArray;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.browser.AuthPanel;
import tecgraf.openbus.browser.ManagedConnectionPool;
import tecgraf.openbus.browser.SwingUncaughtExceptionHandler;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;
import tecgraf.openbus.core.ORBInitializer;

public class OpenbusBrowser
extends JFrame {
    private final AuthPanel authPanel;
    private final ORB orb;
    private static OpenbusBrowser singletonInstance;
    private final ManagedConnectionPool managedConnectionPool;
    private final Preferences persistedPrefs = Preferences.userNodeForPackage(this.getClass());

    private OpenbusBrowser(String[] args) {
        OpenBusContext ctx;
        Properties jacorbProps = new Properties();
        jacorbProps.put("jacorb.codeset", "on");
        jacorbProps.put("jacorb.retries", "1");
        this.orb = ORBInitializer.initORB(args, jacorbProps);
        try {
            ctx = (OpenBusContext)((Object)this.orb.resolve_initial_references("OpenBusContext"));
        }
        catch (InvalidName e) {
            e.printStackTrace(System.err);
            throw new IllegalStateException(e);
        }
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(640, 480));
        int width = this.persistedPrefs.getInt("width", 800);
        int height = this.persistedPrefs.getInt("height", 600);
        this.setSize(new Dimension(width, height));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.managedConnectionPool = new ManagedConnectionPool(ctx);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerLocation(160);
        splitPane.setOrientation(0);
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        this.getContentPane().add(splitPane);
        this.authPanel = new AuthPanel(this.managedConnectionPool);
        splitPane.setLeftComponent(this.authPanel);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        splitPane.setRightComponent(tabbedPane);
        tabbedPane.addTab("OfferRegistry", new OfferRegistryPanel(this.managedConnectionPool));
        this.getContentPane().setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{splitPane}));
        Thread orbThread = new Thread("ORB Thread"){

            @Override
            public void run() {
                OpenbusBrowser.this.orb.run();
            }
        };
        orbThread.setDaemon(true);
        orbThread.start();
        Properties versionProps = new Properties();
        try {
            versionProps.load(this.getClass().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        String version2 = versionProps.getProperty("version", "v. ?");
        String buildDate = versionProps.getProperty("buildDate", "SNAPSHOT");
        String titleAppend = version2;
        if (version2.contains("SNAPSHOT")) {
            titleAppend = titleAppend.replaceAll("\\-SNAPSHOT", " build " + buildDate.replaceAll("\\$", "\\\\\\$"));
        }
        this.setTitle("Openbus Browser - " + titleAppend);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpenbusBrowser.this.persistedPrefs.putInt("height", OpenbusBrowser.this.getHeight());
                OpenbusBrowser.this.persistedPrefs.putInt("width", OpenbusBrowser.this.getWidth());
                OpenbusBrowser.this.setVisible(false);
                OpenbusBrowser.this.managedConnectionPool.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                OpenbusBrowser.this.managedConnectionPool.shutdown();
            }
        });
        this.setLocationRelativeTo(null);
    }

    public static OpenbusBrowser getSingletonInstance() {
        return singletonInstance;
    }

    public static void main(String[] args) throws SecurityException, IOException {
        LogManager.getLogManager().readConfiguration(OpenbusBrowser.class.getResource("/logging.properties").openStream());
        OpenbusBrowser.migratePrefs("ep/petrobras/openbusmonitor", "tecgraf/openbus/browser");
        OpenbusBrowser.migratePrefs("ep/petrobras/openbusmonitor/scs_offers", "tecgraf/openbus/browser/scs_offers");
        singletonInstance = new OpenbusBrowser(args);
        Thread.setDefaultUncaughtExceptionHandler(new SwingUncaughtExceptionHandler(singletonInstance));
        singletonInstance.setVisible(true);
    }

    private static final void migratePrefs(String fromNode, String toNode) {
        try {
            if (Preferences.userRoot().nodeExists(fromNode)) {
                Preferences fromPrefs = Preferences.userRoot().node(fromNode);
                Preferences toPrefs = Preferences.userRoot().node(toNode);
                for (String key : fromPrefs.keys()) {
                    String val = fromPrefs.get(key, null);
                    if (val == null) continue;
                    toPrefs.put(key, val);
                }
                fromPrefs.removeNode();
                toPrefs.flush();
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace(System.err);
        }
    }
}

