/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DropMode;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.scs_offers.NodeWithDetailsInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithPopupMenuInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithTreeReference;
import tecgraf.openbus.browser.scs_offers.OfferTreeCellRenderer;
import tecgraf.openbus.browser.scs_offers.SCSTreeAndDetailsComponent;
import tecgraf.openbus.browser.scs_offers.SCSTreeHandler;
import tecgraf.openbus.browser.scs_offers.SCSTreeTransferHandle;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ServiceOfferNode;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;

public final class SCSTree
extends JTree {
    private final SCSTreeAndDetailsComponent parentComponent;

    protected SCSTree(SCSTreeAndDetailsComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.setModel(new DefaultTreeModel(null));
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.setExpandsSelectedPaths(true);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(this.getTreeSelectionListener());
        this.addMouseListener(this.getPopupNodesMouseListener());
        this.setCellRenderer(new OfferTreeCellRenderer());
        SCSTreeHandler handler = new SCSTreeHandler(this);
        this.addKeyListener(handler);
        this.setDropTarget(new DropTarget(this, 3, handler, true));
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
        this.setTransferHandler(new SCSTreeTransferHandle());
    }

    private MouseListener getPopupNodesMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu;
                    e.consume();
                    NodeWithPopupMenuInterface popuper = null;
                    if (SCSTree.this.getSelectionPath() != null) {
                        if (SCSTree.this.getSelectionPath().getLastPathComponent() instanceof NodeWithPopupMenuInterface) {
                            popuper = (NodeWithPopupMenuInterface)SCSTree.this.getSelectionPath().getLastPathComponent();
                        } else {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)SCSTree.this.getSelectionPath().getLastPathComponent();
                            if (node.getUserObject() != null && node.getUserObject() instanceof NodeWithPopupMenuInterface) {
                                popuper = (NodeWithPopupMenuInterface)node.getUserObject();
                            }
                        }
                    }
                    if (popuper != null && (menu = popuper.getPopupMenu()) != null) {
                        menu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
    }

    private TreeSelectionListener getTreeSelectionListener() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() == null) {
                    SCSTree.this.parentComponent.setDetails(null);
                    return;
                }
                Object[] path = e.getNewLeadSelectionPath().getPath();
                boolean found = false;
                for (int i = path.length - 1; i >= 0; --i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path[i];
                    if (!(node.getUserObject() instanceof NodeWithDetailsInterface)) continue;
                    NodeWithDetailsInterface nodeWithDetails = (NodeWithDetailsInterface)node.getUserObject();
                    SCSTree.this.parentComponent.setDetails(nodeWithDetails.getDetailsPanel());
                    found = true;
                    break;
                }
                if (!found) {
                    SCSTree.this.parentComponent.setDetails(null);
                }
            }
        };
    }

    public void removeOffer(ServiceOfferNode serviceOfferNode) {
        this.parentComponent.removeOffer(serviceOfferNode);
    }

    protected void addServiceOffer(ManagedConnection cnn, ServiceOfferDesc service, NodeWithTreeReference root) {
        this.parentComponent.addServiceOffer(cnn, service, root);
    }
}

