/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import tecgraf.openbus.browser.scs_offers.NodeWithDropBehaviorInterface;
import tecgraf.openbus.browser.scs_offers.RefreshableNode;

final class SCSTreeHandler
implements KeyListener,
DropTargetListener {
    private final JTree resultTree;

    public SCSTreeHandler(JTree resultTree) {
        this.resultTree = resultTree;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        RefreshableNode refreshable;
        if (e.getKeyCode() == 116 && (refreshable = this.getRefreshable(this.resultTree.getSelectionPath())) != null) {
            e.consume();
            try {
                refreshable.refreshNode();
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.resultTree, ex.getMessage(), ex.getClass().getName(), 0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.getDropTargetContext().getComponent() != this.resultTree) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle newRect;
                boolean scrolled = false;
                Point mouse = MouseInfo.getPointerInfo().getLocation();
                Point topLeft = SCSTreeHandler.this.resultTree.getParent().getLocationOnScreen();
                int width = SCSTreeHandler.this.resultTree.getParent().getWidth();
                int height = SCSTreeHandler.this.resultTree.getParent().getHeight();
                if (mouse.y < topLeft.y + 10) {
                    newRect = SCSTreeHandler.this.resultTree.getVisibleRect();
                    --newRect.y;
                    if (newRect.y >= 0) {
                        SCSTreeHandler.this.resultTree.scrollRectToVisible(newRect);
                        scrolled = true;
                    }
                } else if (mouse.y > topLeft.y + height - 10) {
                    newRect = SCSTreeHandler.this.resultTree.getVisibleRect();
                    ++newRect.y;
                    if (newRect.y <= SCSTreeHandler.this.resultTree.getHeight() - height) {
                        SCSTreeHandler.this.resultTree.scrollRectToVisible(newRect);
                        scrolled = true;
                    }
                }
                if (mouse.x < topLeft.x + 10) {
                    newRect = SCSTreeHandler.this.resultTree.getVisibleRect();
                    --newRect.x;
                    if (newRect.x >= 0) {
                        SCSTreeHandler.this.resultTree.scrollRectToVisible(newRect);
                        scrolled = true;
                    }
                } else if (mouse.x > topLeft.x + width - 10) {
                    newRect = SCSTreeHandler.this.resultTree.getVisibleRect();
                    ++newRect.x;
                    if (newRect.x <= SCSTreeHandler.this.resultTree.getWidth() - width) {
                        SCSTreeHandler.this.resultTree.scrollRectToVisible(newRect);
                        scrolled = true;
                    }
                }
                if (scrolled) {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        this.checkIfCanDrop(dtde);
    }

    private final void checkIfCanDrop(DropTargetDragEvent dtde) {
        NodeWithDropBehaviorInterface droppable;
        TreePath row = this.resultTree.getClosestPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        if (row == null || row.getLastPathComponent() == null) {
            dtde.rejectDrag();
            this.resultTree.setLeadSelectionPath(this.resultTree.getSelectionPath());
            return;
        }
        if (!row.equals(this.resultTree.getLeadSelectionPath())) {
            this.resultTree.setLeadSelectionPath(row);
        }
        if ((droppable = this.getDroppable(row)) == null) {
            dtde.rejectDrag();
            return;
        }
        int accept = 0;
        for (DataFlavor flavor : dtde.getCurrentDataFlavors()) {
            accept |= droppable.accept(flavor);
        }
        if (accept > 0) {
            dtde.acceptDrag(accept);
        } else {
            dtde.rejectDrag();
        }
    }

    private NodeWithDropBehaviorInterface getDroppable(TreePath row) {
        DefaultMutableTreeNode n;
        NodeWithDropBehaviorInterface droppable = null;
        if (row.getLastPathComponent() instanceof NodeWithDropBehaviorInterface) {
            droppable = (NodeWithDropBehaviorInterface)row.getLastPathComponent();
        } else if (row.getLastPathComponent() instanceof DefaultMutableTreeNode && (n = (DefaultMutableTreeNode)row.getLastPathComponent()).getUserObject() != null && n.getUserObject() instanceof NodeWithDropBehaviorInterface) {
            droppable = (NodeWithDropBehaviorInterface)n.getUserObject();
        }
        return droppable;
    }

    private RefreshableNode getRefreshable(TreePath row) {
        DefaultMutableTreeNode n;
        RefreshableNode refreshable = null;
        if (row.getLastPathComponent() instanceof RefreshableNode) {
            refreshable = (RefreshableNode)row.getLastPathComponent();
        } else if (row.getLastPathComponent() instanceof DefaultMutableTreeNode && (n = (DefaultMutableTreeNode)row.getLastPathComponent()).getUserObject() != null && n.getUserObject() instanceof RefreshableNode) {
            refreshable = (RefreshableNode)n.getUserObject();
        }
        return refreshable;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.checkIfCanDrop(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.resultTree.setLeadSelectionPath(this.resultTree.getSelectionPath());
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        TreePath row = this.resultTree.getClosestPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        this.resultTree.setLeadSelectionPath(this.resultTree.getSelectionPath());
        if (row == null || row.getLastPathComponent() == null) {
            dtde.rejectDrop();
            return;
        }
        NodeWithDropBehaviorInterface droppable = this.getDroppable(row);
        if (droppable == null) {
            dtde.rejectDrop();
            return;
        }
        int accept = 0;
        for (DataFlavor flavor : dtde.getCurrentDataFlavors()) {
            accept |= droppable.accept(flavor);
        }
        if (accept > 0) {
            dtde.acceptDrop(accept);
            try {
                droppable.doDrop(dtde.getTransferable());
                dtde.dropComplete(true);
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
    }
}

