/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.util.logging.Level;
import tecgraf.openbus.browser.AsyncObservable;
import tecgraf.openbus.browser.scs_offers.ServiceOfferRegistryObserversPool;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferObserverSubscription;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOffer;

public final class ServiceOfferManagedBean
extends AsyncObservable {
    private final ServiceOfferRegistryObserversPool serviceOfferRegistryObserversPool;
    final ServiceOffer serviceOffer;
    OfferObserverSubscription offerObserverSubscription;
    private final ServiceOfferRegistryObserversPool.BusObserverPoolBean myPool;
    private volatile boolean removed = false;
    private volatile boolean invalid = false;
    private volatile boolean testing = false;

    public ServiceOfferManagedBean(ServiceOfferRegistryObserversPool serviceOfferRegistryObserversPool, ServiceOfferRegistryObserversPool.BusObserverPoolBean myPool, ServiceOffer serviceOffer, OfferObserverSubscription offerObserverSubscription) {
        this.serviceOfferRegistryObserversPool = serviceOfferRegistryObserversPool;
        this.serviceOffer = serviceOffer;
        this.offerObserverSubscription = offerObserverSubscription;
        this.myPool = myPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber() {
        Object object;
        try {
            object = this;
            synchronized (object) {
                if (this.offerObserverSubscription != null && this.myPool != null && this.myPool.busId != null) {
                    this.serviceOfferRegistryObserversPool.connectionProvider.getActiveConnectionsOfBusID(this.myPool.busId).setContextCurrentConnection();
                    ServiceOfferRegistryObserversPool.logger.fine("removeSubscriber(): Removendo listener de oferta.");
                    this.offerObserverSubscription.remove();
                    this.offerObserverSubscription = null;
                }
            }
        }
        catch (Throwable e) {
            ServiceOfferRegistryObserversPool.logger.log(Level.WARNING, "Exce\u00e7\u00e3o ignorada ao remover listener de oferta.", e);
        }
        object = this.myPool.controlledBeans;
        synchronized (object) {
            this.myPool.controlledBeans.remove(this.serviceOffer);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.removeSubscriber();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    protected void notifyChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    protected void notifyRemoved() {
        this.removed = true;
        this.setChanged();
        this.notifyObservers();
    }

    protected void notifyInvalid() {
        this.invalid = true;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isTesting() {
        return this.testing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        if (this.invalid || this.removed) {
            return;
        }
        this.testing = true;
        this.setChanged();
        this.notifyObservers();
        try {
            if (this.serviceOffer._non_existent()) {
                this.removed = true;
            }
            if (this.serviceOffer.service_ref()._non_existent()) {
                this.invalid = true;
            }
        }
        catch (Throwable e) {
            this.invalid = true;
        }
        finally {
            this.testing = false;
            this.setChanged();
            this.notifyObservers();
        }
    }
}

