/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers.data_service;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.browser.scs_offers.data_service.Base64;
import tecgraf.openbus.browser.scs_offers.data_service.DataKeyNodeBean;

final class DataKeyNodeDetailsPanel
extends JPanel {
    private final DataKeyNodeBean bean;
    private final JTextField txtName;
    private final JTable tblMetadata;
    private JTextField txtDataKey;
    private static final Font fontForLabel = new Font("Monospaced", 1, 10);
    private static final Font fontForText = new Font("Monospaced", 0, 10);
    private static final ImageIcon ICON_BASE64 = new ImageIcon(DataKeyNodeDetailsPanel.class.getResource("binary-16.png"));
    private final JToggleButton btnBase64;
    private static boolean representingInBase64 = true;
    private JPanel pnlViews;

    protected DataKeyNodeDetailsPanel(DataKeyNodeBean dataKeyNodeBean) {
        this.bean = dataKeyNodeBean;
        this.setLayout(new MigLayout("", "[grow]", "[][][grow][grow]"));
        JLabel lblDatakey = new JLabel("DataKey:");
        lblDatakey.setFont(fontForLabel);
        this.add((Component)lblDatakey, "flowx,cell 0 0");
        this.txtDataKey = new JTextField();
        this.txtDataKey.setEditable(false);
        this.txtDataKey.setBorder(null);
        this.txtDataKey.setFont(fontForText);
        lblDatakey.setLabelFor(this.txtDataKey);
        this.txtDataKey.setText(this.getDataKeyText());
        this.add((Component)this.txtDataKey, "cell 0 0, grow");
        this.btnBase64 = new JToggleButton(ICON_BASE64);
        this.btnBase64.setMinimumSize(new Dimension(20, 20));
        this.btnBase64.setMaximumSize(new Dimension(20, 20));
        this.btnBase64.setToolTipText("Representar o datakey em base64");
        this.btnBase64.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DataKeyNodeDetailsPanel.this.btnBase64.isSelected()) {
                    DataKeyNodeDetailsPanel.this.txtDataKey.setText(Base64.encodeToString(((DataKeyNodeDetailsPanel)DataKeyNodeDetailsPanel.this).bean.getDataDescription().fKey, false));
                } else {
                    DataKeyNodeDetailsPanel.this.txtDataKey.setText(new String(((DataKeyNodeDetailsPanel)DataKeyNodeDetailsPanel.this).bean.getDataDescription().fKey));
                }
                representingInBase64 = DataKeyNodeDetailsPanel.this.btnBase64.isSelected();
            }
        });
        this.add((Component)this.btnBase64, "cell 0 0");
        JLabel lblName = new JLabel("Nome:");
        lblName.setFont(fontForLabel);
        this.add((Component)lblName, "flowx,cell 0 1");
        this.txtName = new JTextField();
        this.txtName.setEditable(false);
        this.txtName.setBorder(null);
        this.txtName.setFont(fontForText);
        lblName.setLabelFor(this.txtName);
        this.txtName.setText(this.bean.getDataDescription().fName);
        this.add((Component)this.txtName, "cell 0 1,grow");
        JSplitPane splitDetails = new JSplitPane();
        splitDetails.setOrientation(0);
        this.add((Component)splitDetails, "cell 0 2,grow");
        JScrollPane scrMetadata = new JScrollPane();
        splitDetails.setTopComponent(scrMetadata);
        splitDetails.setDividerLocation(100);
        splitDetails.setContinuousLayout(true);
        this.tblMetadata = new JTable();
        scrMetadata.setViewportView(this.tblMetadata);
        this.tblMetadata.setModel(new DefaultTableModel(this.getMetadataForTableModel(), new String[]{"Metadado", "Valor"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        this.pnlViews = new JPanel();
        this.pnlViews.setLayout(new BoxLayout(this.pnlViews, 1));
        splitDetails.setBottomComponent(new JScrollPane(this.pnlViews));
        this.addDataView(this.bean.getDataDescription().fDefaultView.fInterfaceName, true);
        for (String otherView : this.bean.getDataDescription().fOthersViews) {
            this.addDataView(otherView, false);
        }
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                DataKeyNodeDetailsPanel.this.btnBase64.setSelected(representingInBase64);
            }
        });
    }

    private void addDataView(String fInterfaceName, boolean isDefaultView) {
        if (fInterfaceName == null || fInterfaceName.isEmpty()) {
            return;
        }
        JLabel newDataViewLabel = new JLabel(fInterfaceName);
        newDataViewLabel.setFont(new Font("Monospaced", isDefaultView ? 1 : 0, 10));
        this.pnlViews.add(newDataViewLabel);
    }

    private String getDataKeyText() {
        String dataKeyString = new String(this.bean.getDataDescription().fKey);
        if (DataKeyNodeDetailsPanel.isPrintable(dataKeyString)) {
            return dataKeyString;
        }
        return Base64.encodeToString(this.bean.getDataDescription().fKey, false);
    }

    private static final boolean isPrintable(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (fontForText.canDisplay(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Object[][] getMetadataForTableModel() {
        Object[][] res = new Object[this.bean.getDataDescription().fMetadata.length][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Object[]{this.bean.getDataDescription().fMetadata[i].fName, this.bean.getDataDescription().fMetadata[i].fValue};
        }
        return res;
    }
}

