/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Properties;
import tecgraf.openbus.exception.InvalidPropertyValue;

enum OpenBusProperty {
    LEGACY_DISABLE("legacy.disable", "false"),
    LEGACY_DELEGATE("legacy.delegate", "caller");

    private final String key;
    private final String defaultValue;

    private OpenBusProperty(String key, String value) {
        this.key = key;
        this.defaultValue = value;
    }

    String getProperty(Properties props) throws InvalidPropertyValue {
        String value = props.getProperty(this.key, this.defaultValue);
        value = value.toLowerCase();
        switch (this) {
            case LEGACY_DISABLE: {
                if (!value.equals("true") && !value.equals("false")) break;
                return value;
            }
            case LEGACY_DELEGATE: {
                if (!value.equals("caller") && !value.equals("originator")) break;
                return value;
            }
            default: {
                return null;
            }
        }
        throw new InvalidPropertyValue(this.key, value);
    }
}

