/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AsyncObservable {
    private static final ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue(128);
    private final List<AsyncObserver> observers = new CopyOnWriteArrayList<AsyncObserver>();
    private volatile boolean changed;
    private static final Thread asyncEventThread = new Thread(){

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (!this.isInterrupted()) {
                        Runnable r = (Runnable)queue.take();
                        try {
                            r.run();
                            continue block4;
                        }
                        catch (Throwable e) {
                            if (e instanceof InterruptedException) {
                                throw (InterruptedException)e;
                            }
                            e.printStackTrace(System.err);
                        }
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
    };

    protected final void setChanged() {
        this.changed = true;
    }

    public void addObserver(AsyncObserver observer) {
        this.observers.add(observer);
    }

    public boolean removeObserver(AsyncObserver observer) {
        return this.observers.remove(observer);
    }

    public void notifyObserversSync() {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        try {
            ArrayList<AsyncObserver> snapshot = new ArrayList<AsyncObserver>(this.observers);
            final AtomicInteger latch = new AtomicInteger(snapshot.size());
            for (final AsyncObserver o : snapshot) {
                queue.put(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            o.event(AsyncObservable.this);
                        }
                        finally {
                            latch.decrementAndGet();
                        }
                    }
                });
            }
            while (latch.get() > 0) {
                Runnable x;
                Thread.yield();
                if (asyncEventThread != null && !asyncEventThread.isInterrupted() && asyncEventThread.isAlive()) continue;
                while ((x = queue.poll()) != null) {
                    try {
                        x.run();
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                    }
                }
                return;
            }
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException("Thread interrompida durante a notifica\u00e7\u00e3o do AsyncObserver", ie);
        }
    }

    public void notifyObservers() {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        try {
            for (final AsyncObserver o : this.observers) {
                queue.put(new Runnable(){

                    @Override
                    public void run() {
                        o.event(AsyncObservable.this);
                    }
                });
            }
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException("Thread interrompida durante a notifica\u00e7\u00e3o do AsyncObserver", ie);
        }
    }

    static {
        asyncEventThread.setDaemon(false);
        asyncEventThread.setName("AsyncObserver event thread");
        asyncEventThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                asyncEventThread.interrupt();
                try {
                    asyncEventThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread("AsyncObserver terminator thread"){

            @Override
            public void run() {
                Runnable r;
                asyncEventThread.interrupt();
                while ((r = (Runnable)queue.poll()) != null) {
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        });
    }

    public static interface AsyncObserver {
        public void event(AsyncObservable var1);
    }
}

