/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.miginfocom.swing.MigLayout;
import org.eclipse.wb.swing.FocusTraversalOnArray;
import tecgraf.openbus.browser.AuthPanelListItem;
import tecgraf.openbus.browser.IntegerDocument;
import tecgraf.openbus.browser.LRUComboBox;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.ManagedConnectionPool;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.exception.AlreadyLoggedIn;

class AuthPanel
extends JPanel {
    private ManagedConnectionPool managedConnectionPool;
    private final JTextField txtHost;
    private final JTextField txtPort;
    private final JTextField txtEntity;
    private final JPasswordField txtPassword;
    private JComboBox cmbLoginType;
    private final ButtonGroup connectionChooser;
    private final CertificatePanel certificatePanel;
    private LRUComboBox cmbLRU;
    private JScrollPane scrollPane;
    private JPanel pnlLogins;
    private JButton btnDoLogin;
    private final Preferences persistedPrefs = Preferences.userNodeForPackage(this.getClass());
    private final KeyListener focusTransferKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                e.consume();
                ((Component)e.getSource()).transferFocus();
            }
            super.keyTyped(e);
        }
    };
    private final KeyListener doLoginKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                e.consume();
                AuthPanel.this.btnDoLogin.doClick();
            }
            super.keyTyped(e);
        }
    };
    private final DocumentListener lruClearDocumentListener = new DocumentListener(){

        private final void doUpdate() {
            int idxSelected;
            String lruCandidate = AuthPanel.this.getLRUText();
            int idx = ((DefaultComboBoxModel)AuthPanel.this.cmbLRU.getModel()).getIndexOf(lruCandidate);
            if (idx != (idxSelected = AuthPanel.this.cmbLRU.getSelectedIndex())) {
                AuthPanel.this.cmbLRU.setSelectedIndex(idx);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.doUpdate();
        }
    };

    public AuthPanel(ManagedConnectionPool argManagedConnectionPool) {
        this.managedConnectionPool = argManagedConnectionPool;
        this.setLayout(new MigLayout("", "[grow,left]", "[][][][grow]"));
        this.connectionChooser = new ButtonGroup();
        JLabel lblHost = new JLabel("Servidor:");
        this.add((Component)lblHost, "flowx,cell 0 0");
        this.txtHost = new JTextField();
        this.txtHost.setDocument(new ValidLRUPartDocument());
        this.txtHost.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.txtHost.addKeyListener(this.focusTransferKeyListener);
        this.txtHost.getDocument().addDocumentListener(this.lruClearDocumentListener);
        lblHost.setLabelFor(this.txtHost);
        this.add((Component)this.txtHost, "cell 0 0, grow");
        JLabel lblPort = new JLabel("Porta:");
        this.add((Component)lblPort, "cell 0 0");
        this.txtPort = new JTextField();
        this.txtPort.setColumns(5);
        this.txtPort.setMaximumSize(new Dimension(50, 20));
        this.txtPort.setDocument(new IntegerDocument());
        this.txtPort.addKeyListener(this.focusTransferKeyListener);
        this.txtPort.getDocument().addDocumentListener(this.lruClearDocumentListener);
        lblPort.setLabelFor(this.txtPort);
        this.add((Component)this.txtPort, "cell 0 0");
        JLabel lblEntity = new JLabel("Entidade:");
        this.add((Component)lblEntity, "flowx,cell 0 1");
        this.txtEntity = new JTextField();
        this.txtEntity.setDocument(new ValidLRUPartDocument());
        this.txtEntity.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.txtEntity.addKeyListener(this.focusTransferKeyListener);
        this.txtEntity.getDocument().addDocumentListener(this.lruClearDocumentListener);
        lblEntity.setLabelFor(this.txtEntity);
        this.add((Component)this.txtEntity, "cell 0 1,grow");
        this.cmbLoginType = new JComboBox();
        this.cmbLoginType.setModel(new DefaultComboBoxModel<LoginType>(LoginType.values()));
        this.cmbLoginType.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.cmbLoginType.addKeyListener(this.focusTransferKeyListener);
        this.cmbLoginType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AuthPanel.this.cmbLoginType.getModel().getSelectedItem() == null) {
                    AuthPanel.this.txtPassword.setVisible(false);
                    AuthPanel.this.certificatePanel.setVisible(false);
                    return;
                }
                AuthPanel.this.lruClearDocumentListener.changedUpdate(null);
                AuthPanel.this.txtPassword.setEnabled(true);
                switch ((LoginType)((Object)AuthPanel.this.cmbLoginType.getModel().getSelectedItem())) {
                    case PASSWORD: {
                        AuthPanel.this.txtPassword.setVisible(true);
                        AuthPanel.this.certificatePanel.setVisible(false);
                        break;
                    }
                    case PRIVATE_KEY: {
                        AuthPanel.this.txtPassword.setVisible(false);
                        AuthPanel.this.certificatePanel.setVisible(true);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        this.add((Component)this.cmbLoginType, "cell 0 1");
        this.txtPassword = new JPasswordField();
        this.txtPassword.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.txtPassword.addKeyListener(this.doLoginKeyListener);
        this.add((Component)this.txtPassword, "hidemode 3,cell 0 1,grow");
        this.certificatePanel = new CertificatePanel();
        this.certificatePanel.txtKeyFile.getDocument().addDocumentListener(this.lruClearDocumentListener);
        this.add((Component)this.certificatePanel, "cell 0 1, hidemode 3, grow");
        JLabel lblLRU = new JLabel("LRU:");
        lblLRU.setToolTipText("Lista das configura\u00e7\u00f5es recentemente utilizadas");
        this.add((Component)lblLRU, "flowx,cell 0 2");
        this.txtPassword.setVisible(true);
        this.certificatePanel.setVisible(false);
        this.cmbLRU = new LRUComboBox();
        this.cmbLRU.setToolTipText("Ultimas configura\u00e7\u00f5es de login utilizadas");
        this.cmbLRU.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.cmbLRU.addKeyListener(this.focusTransferKeyListener);
        this.cmbLRU.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String lruVal = (String)AuthPanel.this.cmbLRU.getModel().getSelectedItem();
                if (lruVal == null) {
                    return;
                }
                AuthPanel.this.configureByLRUText(lruVal);
            }
        });
        lblLRU.setLabelFor(this.cmbLRU);
        this.add((Component)this.cmbLRU, "cell 0 2, grow");
        this.btnDoLogin = new JButton("Login");
        this.btnDoLogin.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.btnDoLogin.addActionListener(this.getDoLoginActionListener());
        this.add((Component)this.btnDoLogin, "cell 0 2");
        this.btnDoLogin.setToolTipText("Realizar login. Clique com o bot\u00e3o direito para op\u00e7\u00f5es");
        this.btnDoLogin.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.consume();
                    JPopupMenu opt = new JPopupMenu();
                    final JCheckBoxMenuItem mnuAutoLogin = new JCheckBoxMenuItem("Auto-login ao iniciar, se poss\u00edvel");
                    mnuAutoLogin.setSelected(AuthPanel.this.persistedPrefs.getBoolean("autoLogin", true));
                    mnuAutoLogin.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AuthPanel.this.persistedPrefs.putBoolean("autoLogin", mnuAutoLogin.isSelected());
                        }
                    });
                    opt.add(mnuAutoLogin);
                    opt.show(AuthPanel.this.btnDoLogin, 0, AuthPanel.this.btnDoLogin.getHeight() + 2);
                }
            }
        });
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "cell 0 3,grow");
        this.pnlLogins = new JPanel();
        this.pnlLogins.setLayout(new BoxLayout(this.pnlLogins, 1));
        this.pnlLogins.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof AuthPanelListItem) {
                    AuthPanelListItem item = (AuthPanelListItem)e.getChild();
                    AuthPanel.this.managedConnectionPool.removeConnection(item.getConnection());
                    if (AuthPanel.this.managedConnectionPool.getPreferredConnection() == null) {
                        for (Component candidate : e.getContainer().getComponents()) {
                            AuthPanelListItem superCandidate;
                            if (!(candidate instanceof AuthPanelListItem) || (superCandidate = (AuthPanelListItem)candidate).getConnection().getState() != ManagedConnection.ConnectionState.AUTENTICATED) continue;
                            superCandidate.setSelected();
                            break;
                        }
                    }
                }
            }
        });
        this.scrollPane.setViewportView(this.pnlLogins);
        this.setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{this.txtHost, this.txtPort, this.txtEntity, this.cmbLoginType, this.txtPassword, this.certificatePanel, this.btnDoLogin, this.cmbLRU}));
        this.cmbLRU.loadLRUJoinedText(this.persistedPrefs.get("lru", ""));
        this.cmbLRU.getModel().addListDataListener(new ListDataListener(){

            private void save() {
                AuthPanel.this.persistedPrefs.put("lru", AuthPanel.this.cmbLRU.getLRUJoinedText());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.save();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.save();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.save();
            }
        });
        if (this.persistedPrefs.getBoolean("autoLogin", true)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AuthPanel.this.isUserInputValidForLogin(false)) {
                        AuthPanel.this.btnDoLogin.doClick();
                    }
                }
            });
        }
    }

    private String getLRUText() {
        StringBuilder res = new StringBuilder();
        res.append(this.txtEntity.getText());
        res.append("@");
        res.append(this.txtHost.getText());
        res.append(":");
        res.append(this.txtPort.getText());
        if (this.cmbLoginType.getModel().getSelectedItem() == LoginType.PRIVATE_KEY) {
            res.append(":");
            res.append(this.certificatePanel.txtKeyFile.getText());
        }
        return res.toString();
    }

    private File lookForCertificateFile() {
        File d;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Indique a chave privada");
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setApproveButtonText("OK");
        String currentDirFile = this.persistedPrefs.get("pkLookUpDir", System.getenv("user.home"));
        fileChooser.setSelectedFile(null);
        if (currentDirFile != null && (d = new File(currentDirFile)).exists() && d.isDirectory()) {
            fileChooser.setCurrentDirectory(d);
        }
        fileChooser.showDialog(this, "Ok");
        this.persistedPrefs.put("pkLookUpDir", fileChooser.getCurrentDirectory().getAbsolutePath());
        return fileChooser.getSelectedFile();
    }

    private void configureByLRUText(String lruText) {
        Pattern pat = Pattern.compile("([^\\s@]+)@([^\\s@]+)\\:([0-9]+)(?:\\:(.+))?");
        Matcher m = pat.matcher(lruText);
        if (!m.matches()) {
            throw new IllegalStateException("Texto LRU n\u00e3o est\u00e1 no padr\u00e3o correto: \"" + lruText + "\"");
        }
        if (!this.txtEntity.getText().equals(m.group(1))) {
            this.txtEntity.setText(m.group(1));
        }
        if (!this.txtHost.getText().equals(m.group(2))) {
            this.txtHost.setText(m.group(2));
        }
        if (!this.txtPort.getText().equals(m.group(3))) {
            this.txtPort.setText(m.group(3));
        }
        if (m.group(4) != null) {
            if (this.cmbLoginType.getSelectedItem() != LoginType.PRIVATE_KEY) {
                this.cmbLoginType.setSelectedItem((Object)LoginType.PRIVATE_KEY);
            }
            if (!this.certificatePanel.txtKeyFile.getText().equals(m.group(4))) {
                this.certificatePanel.txtKeyFile.setText(m.group(4));
            }
        } else if (this.cmbLoginType.getSelectedItem() != LoginType.PASSWORD) {
            this.cmbLoginType.setSelectedItem((Object)LoginType.PASSWORD);
        }
    }

    private ActionListener getDoLoginActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagedConnection newCnn;
                Component[] actualLogins;
                if (!AuthPanel.this.isUserInputValidForLogin(true)) {
                    return;
                }
                for (Component c : actualLogins = AuthPanel.this.pnlLogins.getComponents()) {
                    AuthPanelListItem a;
                    if (!(c instanceof AuthPanelListItem) || (a = (AuthPanelListItem)c).getConnection().getState() != ManagedConnection.ConnectionState.ERROR && a.getConnection().getState() != ManagedConnection.ConnectionState.DISCONNECTED) continue;
                    AuthPanel.this.pnlLogins.remove(c);
                }
                LoginType loginType = (LoginType)((Object)AuthPanel.this.cmbLoginType.getModel().getSelectedItem());
                switch (loginType) {
                    case PASSWORD: {
                        newCnn = AuthPanel.this.managedConnectionPool.createAndAddConnection(AuthPanel.this.txtHost.getText(), Integer.parseInt(AuthPanel.this.txtPort.getText()), AuthPanel.this.txtEntity.getText(), new String(AuthPanel.this.txtPassword.getPassword()));
                        break;
                    }
                    case PRIVATE_KEY: {
                        try {
                            newCnn = AuthPanel.this.managedConnectionPool.createAndAddConnection(AuthPanel.this.txtHost.getText(), Integer.parseInt(AuthPanel.this.txtPort.getText()), AuthPanel.this.txtEntity.getText(), new File(((AuthPanel)AuthPanel.this).certificatePanel.txtKeyFile.getText()));
                            break;
                        }
                        catch (Throwable t) {
                            JOptionPane.showMessageDialog(AuthPanel.this, "Chave privada inv\u00e1lida: '" + t.getMessage() + "'", t.getClass().getSimpleName() + " na chave privada", 0);
                            return;
                        }
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                final AuthPanelListItem newItem = new AuthPanelListItem(AuthPanel.this.connectionChooser, newCnn, new AuthPanelListItem.SelectedConnectionChangeListener(){

                    @Override
                    public void selectedConnection(ManagedConnection cnn) {
                        AuthPanel.this.managedConnectionPool.setPreferredConnection(cnn);
                    }
                });
                AuthPanel.this.pnlLogins.add((Component)newItem, 0);
                new Thread(){

                    @Override
                    public void run() {
                        boolean ok = false;
                        try {
                            newCnn.autenticate();
                            ok = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    newItem.setSelected();
                                    String lru = AuthPanel.this.getLRUText();
                                    AuthPanel.this.cmbLRU.addLRUItem(lru);
                                    AuthPanel.this.cmbLRU.setSelectedItem(lru);
                                }
                            });
                            AuthPanel.this.managedConnectionPool.notifyObservers();
                        }
                        catch (AlreadyLoggedIn e) {
                        }
                        catch (ServiceFailure e) {
                            JOptionPane.showMessageDialog(AuthPanel.this, e.message, e.getClass().getSimpleName() + " durante a autentica\u00e7\u00e3o!", 0);
                        }
                        catch (Throwable e) {
                            JOptionPane.showMessageDialog(AuthPanel.this, e.getMessage(), e.getClass().getSimpleName() + " durante a autentica\u00e7\u00e3o!", 0);
                        }
                        if (!ok) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AuthPanel.this.pnlLogins.remove(newItem);
                                }
                            });
                        }
                    }
                }.start();
            }
        };
    }

    private boolean validateTextFieldNotEmpty(boolean messageBox, JTextField txt, String fieldName) {
        if (txt.getText() == null || txt.getText().trim().isEmpty()) {
            if (messageBox) {
                JOptionPane.showMessageDialog(this, fieldName + " est\u00e1 em branco.", "Ops!", 0);
                txt.requestFocus();
            }
            return false;
        }
        return true;
    }

    private boolean isUserInputValidForLogin(boolean messageBox) {
        if (!this.validateTextFieldNotEmpty(messageBox, this.txtHost, "Host")) {
            return false;
        }
        if (!this.validateTextFieldNotEmpty(messageBox, this.txtPort, "Porta")) {
            return false;
        }
        if (!this.validateTextFieldNotEmpty(messageBox, this.txtEntity, "Entidade")) {
            return false;
        }
        LoginType loginType = (LoginType)((Object)this.cmbLoginType.getModel().getSelectedItem());
        switch (loginType) {
            case PASSWORD: {
                if (this.validateTextFieldNotEmpty(messageBox, this.txtPassword, "Senha")) break;
                return false;
            }
            case PRIVATE_KEY: {
                if (this.validateTextFieldNotEmpty(messageBox, this.certificatePanel.txtKeyFile, "Chave privada")) break;
                return false;
            }
        }
        return true;
    }

    private final class CertificatePanel
    extends JPanel {
        final JTextField txtKeyFile;
        final JButton btnFindCertificate;

        public CertificatePanel() {
            this.setLayout(new MigLayout("", "0[grow,fill]0", "0[grow, fill]0"));
            this.txtKeyFile = new JTextField();
            this.txtKeyFile.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
            this.txtKeyFile.addKeyListener(AuthPanel.this.doLoginKeyListener);
            this.add((Component)this.txtKeyFile, "cell 0 0, grow");
            this.btnFindCertificate = new JButton("...");
            this.btnFindCertificate.setMaximumSize(new Dimension(18, 18));
            this.add((Component)this.btnFindCertificate, "cell 0 0");
            this.btnFindCertificate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = AuthPanel.this.lookForCertificateFile();
                    if (f != null && f.exists() && f.isFile()) {
                        CertificatePanel.this.txtKeyFile.setText(f.getAbsolutePath());
                    }
                }
            });
        }
    }

    private final class ValidLRUPartDocument
    extends PlainDocument {
        private ValidLRUPartDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str.indexOf(64) == -1 && str.indexOf(58) == -1) {
                super.insertString(offs, str, a);
            }
        }
    }

    public static enum LoginType {
        PASSWORD("Senha"),
        PRIVATE_KEY("Chave");

        private final String label;

        private LoginType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

