/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import tecgraf.openbus.browser.AsyncObservable;
import tecgraf.openbus.browser.AsyncSwingObserver;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.OpenbusBrowser;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;

class AuthPanelListItem
extends JPanel {
    private final SelectedConnectionChangeListener changeListener;
    private final ManagedConnection cnn;
    private final Timer animationTimer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AuthPanelListItem.this.isVisible() || AuthPanelListItem.this.getParent() == null) {
                AuthPanelListItem.this.animationTimer.stop();
                return;
            }
            int cnnCounter = AuthPanelListItem.this.cnn.getDispatchesToMeCounter();
            if (AuthPanelListItem.this.myDispatchCounter != cnnCounter) {
                AuthPanelListItem.this.signalingDispatch = 10;
            } else if (AuthPanelListItem.this.signalingDispatch > 0) {
                AuthPanelListItem.this.signalingDispatch = AuthPanelListItem.this.signalingDispatch - 1;
            }
            AuthPanelListItem.this.myDispatchCounter = cnnCounter;
            if (AuthPanelListItem.this.signalingDispatch == 0) {
                AuthPanelListItem.this.animationTimer.stop();
            } else if (!AuthPanelListItem.this.animationTimer.isRunning()) {
                AuthPanelListItem.this.animationTimer.start();
            }
            AuthPanelListItem.this.lblIcon.repaint();
        }
    });
    private static final ImageIcon ICON_DISCONNECTED = new ImageIcon(AuthPanelListItem.class.getResource("login_disconnected_32.png"));
    private static final ImageIcon ICON_CONNECTED = new ImageIcon(AuthPanelListItem.class.getResource("login_connected_32.png"));
    private static final ImageIcon ICON_CONNECTING = new ImageIcon(AuthPanelListItem.class.getResource("login_connecting_32.gif"));
    private static final ImageIcon ICON_ERROR = new ImageIcon(AuthPanelListItem.class.getResource("login_error_32.png"));
    private static final ImageIcon ICON_RECONNECTING = new ImageIcon(AuthPanelListItem.class.getResource("login_reconnecting_32.gif"));
    private static final ImageIcon ICON_TRASH = new ImageIcon(AuthPanelListItem.class.getResource("trashicon-12.png"));
    private static final BufferedImage ICON_LISTEN = new BufferedImage(16, 16, 6);
    private final AsyncSwingObserver myObserver = new AsyncSwingObserver(){

        @Override
        public void eventInEDT(AsyncObservable src) {
            AuthPanelListItem.this.updateController();
        }
    };
    private final JTextField txtBusID;
    private final JTextField txtLoginID;
    private final JTextField txtHostAndCredential;
    private final JLabel lblLoginType;
    private final JLabel lblIcon;
    private final JRadioButton rdbCnnSelector;
    private final JButton btnLogoff;
    private volatile int myDispatchCounter = 0;
    private volatile int signalingDispatch = 0;
    private final Icon connectedIcon = new Icon(){
        BufferedImage canvas = new BufferedImage(32, 32, 6);

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = this.canvas.createGraphics();
            g2.setBackground(new Color(0, 0, 0, 0));
            g2.clearRect(0, 0, 32, 32);
            ICON_CONNECTED.paintIcon(c, g2, x, y);
            if (AuthPanelListItem.this.signalingDispatch > 0) {
                float[] scales = new float[]{1.0f, 1.0f, 1.0f, (float)AuthPanelListItem.this.signalingDispatch / 10.0f};
                float[] offsets = new float[4];
                RescaleOp rop = new RescaleOp(scales, offsets, null);
                g2.drawImage(ICON_LISTEN, rop, 16, 16);
            }
            g2.dispose();
            g.drawImage(this.canvas, 0, 0, null);
        }

        @Override
        public int getIconWidth() {
            return 32;
        }

        @Override
        public int getIconHeight() {
            return 32;
        }
    };

    public AuthPanelListItem(final ButtonGroup buttonGroup, ManagedConnection argCnn, SelectedConnectionChangeListener argChangeListener) {
        this.cnn = argCnn;
        this.changeListener = argChangeListener;
        this.setLayout(new MigLayout("", "[20px:20px:20px,center][20px:20px:20px,center][32px:32px:32px,fill][grow]", "1[15px:15px:15px,center]2[15px:15px:15px,center]1"));
        this.setMinimumSize(new Dimension(590, 36));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 36));
        Font lblFont = new Font("Dialog", 1, 10);
        Font txtFont = new Font("Monospaced", 0, 10);
        this.btnLogoff = new JButton(ICON_TRASH);
        this.btnLogoff.setMinimumSize(new Dimension(20, 20));
        this.btnLogoff.setMaximumSize(new Dimension(20, 20));
        this.btnLogoff.setFont(txtFont);
        this.btnLogoff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AuthPanelListItem.this.cnn.getState() == ManagedConnection.ConnectionState.ERROR) {
                    this.killMeFromList();
                    return;
                }
                try {
                    if (JOptionPane.showConfirmDialog(AuthPanelListItem.this, "Confirma logoff?!", "Logoff", 0) == 1) {
                        return;
                    }
                    if (AuthPanelListItem.this.cnn.logout()) {
                        this.killMeFromList();
                    }
                }
                catch (ServiceFailure e1) {
                    JOptionPane.showMessageDialog(AuthPanelListItem.this, "Chave privada inv\u00e1lida: '" + e1.message + "'", e1.getClass().getSimpleName() + " no logout", 0);
                }
            }

            private void killMeFromList() {
                Container parent = AuthPanelListItem.this.getParent();
                parent.remove(AuthPanelListItem.this);
                parent.invalidate();
                parent.doLayout();
                parent.repaint();
            }
        });
        this.add((Component)this.btnLogoff, "cell 0 0 1 2");
        this.rdbCnnSelector = new JRadioButton();
        this.rdbCnnSelector.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AuthPanelListItem.this.rdbCnnSelector.isSelected()) {
                    AuthPanelListItem.this.changeListener.selectedConnection(AuthPanelListItem.this.cnn);
                }
            }
        });
        this.add((Component)this.rdbCnnSelector, "cell 1 0 1 2");
        this.lblIcon = new JLabel();
        this.lblIcon.setMinimumSize(new Dimension(32, 32));
        this.lblIcon.setMaximumSize(new Dimension(32, 32));
        this.lblIcon.setPreferredSize(new Dimension(32, 32));
        this.lblIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AuthPanelListItem.this.cnn.getState() == ManagedConnection.ConnectionState.ERROR && AuthPanelListItem.this.cnn.getLastError() != null) {
                    System.err.println("------------------------------------------------");
                    System.err.println("Exce\u00e7\u00e3o na conex\u00e3o com " + AuthPanelListItem.this.txtHostAndCredential.getText() + ":");
                    AuthPanelListItem.this.cnn.getLastError().printStackTrace(System.err);
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.add((Component)this.lblIcon, "cell 2 0 1 2");
        JLabel lblBusid = new JLabel("BusID:");
        lblBusid.setFont(lblFont);
        this.add((Component)lblBusid, "flowx,cell 3 0");
        this.txtBusID = new JTextField();
        this.txtBusID.setOpaque(false);
        this.txtBusID.setEditable(false);
        this.txtBusID.setBorder(null);
        this.txtBusID.setFont(txtFont);
        this.txtBusID.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.txtBusID, "cell 3 0,grow");
        JLabel lblLoginID = new JLabel("LoginID:");
        lblLoginID.setFont(lblFont);
        this.add((Component)lblLoginID, "flowx,cell 3 0");
        this.txtLoginID = new JTextField();
        this.txtLoginID.setOpaque(false);
        this.txtLoginID.setEditable(false);
        this.txtLoginID.setBorder(null);
        this.txtLoginID.setFont(txtFont);
        this.txtLoginID.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.txtLoginID, "cell 3 0,grow");
        this.lblLoginType = new JLabel("Login por senha:");
        this.lblLoginType.setFont(lblFont);
        this.add((Component)this.lblLoginType, "flowx,cell 3 1");
        this.txtHostAndCredential = new JTextField();
        this.txtHostAndCredential.setOpaque(false);
        this.txtHostAndCredential.setEditable(false);
        this.txtHostAndCredential.setBorder(null);
        this.txtHostAndCredential.setFont(txtFont);
        this.txtHostAndCredential.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.txtHostAndCredential, "cell 3 1,grow");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                buttonGroup.remove(AuthPanelListItem.this.rdbCnnSelector);
                AuthPanelListItem.this.cnn.removeObserver(AuthPanelListItem.this.myObserver);
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                AuthPanelListItem.this.cnn.addObserver(AuthPanelListItem.this.myObserver);
                buttonGroup.add(AuthPanelListItem.this.rdbCnnSelector);
                AuthPanelListItem.this.myObserver.event(AuthPanelListItem.this.cnn);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private final void updateController() {
        String tooltip;
        String loginType;
        String iconTooltip;
        Icon icon = null;
        boolean selectable = false;
        boolean logoffable = false;
        switch (this.cnn.getState()) {
            case CONNECTED: {
                icon = ICON_CONNECTED;
                selectable = false;
                logoffable = false;
                iconTooltip = "Conectado, sem autentica\u00e7\u00e3o.";
                break;
            }
            case CONNECTING: {
                icon = ICON_CONNECTING;
                selectable = false;
                logoffable = false;
                iconTooltip = "Aguarde conex\u00e3o...";
                break;
            }
            case DISCONNECTED: {
                icon = ICON_DISCONNECTED;
                selectable = false;
                logoffable = false;
                iconTooltip = "Desconectado.";
                break;
            }
            case ERROR: {
                icon = ICON_ERROR;
                selectable = false;
                logoffable = true;
                iconTooltip = this.getErrorTooltip();
                break;
            }
            case AUTENTICATING: {
                icon = ICON_CONNECTING;
                selectable = false;
                logoffable = false;
                iconTooltip = "Autenticando no Openbus...";
                break;
            }
            case AUTENTICATED: {
                icon = this.connectedIcon;
                selectable = true;
                logoffable = true;
                iconTooltip = "Conectado e autenticado";
                break;
            }
            case REAUTENTICATING: {
                icon = ICON_RECONNECTING;
                selectable = false;
                logoffable = false;
                iconTooltip = "Renovando conex\u00e3o e autentica\u00e7\u00e3o...";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (selectable != this.rdbCnnSelector.isEnabled()) {
            if (!selectable) {
                this.rdbCnnSelector.setSelected(false);
            }
            this.rdbCnnSelector.setEnabled(selectable);
        }
        if (logoffable != this.btnLogoff.isEnabled()) {
            this.btnLogoff.setEnabled(logoffable);
        }
        if (this.lblIcon.getIcon() != icon) {
            this.lblIcon.setIcon(icon);
        }
        if (!iconTooltip.equals(this.lblIcon.getToolTipText())) {
            this.lblIcon.setToolTipText(iconTooltip);
        }
        String busid = this.cnn.busid();
        if (!this.txtBusID.getText().equals(busid)) {
            this.txtBusID.setText(busid);
        }
        String loginId = "N/A";
        if (this.cnn.login() != null && this.cnn.login().id != null && !this.cnn.login().id.isEmpty()) {
            loginId = this.cnn.login().id;
        }
        if (!this.txtLoginID.getText().equals(loginId)) {
            this.txtLoginID.setText(loginId);
        }
        switch (this.cnn.getLoginType()) {
            case PASSWORD: {
                loginType = "Login por senha:";
                tooltip = "";
                break;
            }
            case PRIVATE_KEY: {
                loginType = "Login por chave:";
                tooltip = "Chave privada: " + this.cnn.getKeyFile().getAbsolutePath();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (!this.lblLoginType.getText().equals(loginType)) {
            this.lblLoginType.setText(loginType);
        }
        if (this.lblLoginType.getToolTipText() == null) {
            this.lblLoginType.setToolTipText("");
        }
        if (!this.lblLoginType.getToolTipText().equals(tooltip)) {
            this.lblLoginType.setToolTipText(tooltip);
        }
        StringBuilder hostCred = new StringBuilder();
        hostCred.append(this.cnn.getEntity());
        hostCred.append("@");
        hostCred.append(this.cnn.getHost());
        hostCred.append(":");
        hostCred.append(this.cnn.getPort());
        String hostCredStr = hostCred.toString();
        if (this.txtHostAndCredential.getToolTipText() == null) {
            this.txtHostAndCredential.setToolTipText("");
        }
        if (!this.txtHostAndCredential.equals(hostCredStr)) {
            this.txtHostAndCredential.setText(hostCredStr);
        }
        if (!this.txtHostAndCredential.getToolTipText().equals(tooltip)) {
            this.txtHostAndCredential.setToolTipText(tooltip);
        }
        if (this.signalingDispatch > 0 || this.cnn.getDispatchesToMeCounter() != this.myDispatchCounter) {
            this.animationTimer.getActionListeners()[0].actionPerformed(null);
        }
    }

    private String getErrorTooltip() {
        if (this.cnn.getLastError() == null) {
            return "N\u00e3o sei o que houve. :-(";
        }
        StringBuilder res = new StringBuilder();
        res.append("<html>");
        int count = 0;
        for (Throwable e = this.cnn.getLastError(); e != null; e = e.getCause()) {
            String msg;
            if (++count > 1) {
                res.append("<br><br>causada por ");
            }
            res.append("<b>" + e.getClass().getName() + "</b><br>");
            if (e instanceof ServiceFailure) {
                msg = ((ServiceFailure)e).message;
                if (msg == null || msg.isEmpty()) {
                    msg = e.getMessage();
                }
            } else {
                msg = e.getMessage();
            }
            if (e instanceof SystemException) {
                SystemException se = (SystemException)e;
                msg = msg + " (completed=" + this.getCompletionStatusString(se.completed) + "; minor=" + se.minor + ")";
            }
            if (msg == null || msg.isEmpty()) continue;
            res.append("<small><i><pre>" + msg + "</pre></i></small>");
        }
        res.append("</html>");
        return res.toString();
    }

    private String getCompletionStatusString(CompletionStatus completed) {
        switch (completed.value()) {
            case 2: {
                return "maybe";
            }
            case 1: {
                return "no";
            }
            case 0: {
                return "yes";
            }
        }
        return "Status " + completed.value();
    }

    public void setSelected() {
        this.rdbCnnSelector.setSelected(true);
    }

    public boolean isSelected() {
        return this.rdbCnnSelector.isSelected();
    }

    public ManagedConnection getConnection() {
        return this.cnn;
    }

    static {
        Graphics2D g2 = ICON_LISTEN.createGraphics();
        g2.drawImage(new ImageIcon(OpenbusBrowser.class.getResource("ear-listen-16.png")).getImage(), 0, 0, null);
        g2.dispose();
    }

    public static interface SelectedConnectionChangeListener {
        public void selectedConnection(ManagedConnection var1);
    }
}

