/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class LRUComboBox
extends JComboBox {
    private final DefaultComboBoxModel model = new DefaultComboBoxModel();
    private static final char DIV_CHAR = '\u00ac';
    private int maxSize = 30;
    private Runnable saveHandler;

    public LRUComboBox() {
        super.setModel(this.model);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    JPopupMenu lruMenu = new JPopupMenu("Lista de itens recentes");
                    JMenuItem clearLRUItem = new JMenuItem("Limpar lista");
                    clearLRUItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LRUComboBox.this.model.removeAllElements();
                            if (LRUComboBox.this.saveHandler != null) {
                                LRUComboBox.this.saveHandler.run();
                            }
                        }
                    });
                    lruMenu.add(clearLRUItem);
                    lruMenu.show(LRUComboBox.this, e.getX(), e.getY());
                }
            }
        });
    }

    public String[] getLRUList() {
        String[] res = new String[this.model.getSize()];
        for (int i = 0; i < this.model.getSize(); ++i) {
            res[i] = this.model.getElementAt(i).toString();
        }
        return res;
    }

    public void addLRUItem(String value) {
        this.model.removeElement(value);
        this.model.insertElementAt(value, 0);
        while (this.model.getSize() > this.maxSize) {
            this.model.removeElementAt(this.maxSize);
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public String getLRUJoinedText() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.model.getSize(); ++i) {
            if (res.length() > 0) {
                res.append('\u00ac');
            }
            res.append(this.model.getElementAt(i).toString());
        }
        return res.toString();
    }

    public void loadLRUJoinedText(String joinedText) {
        String[] parts;
        this.model.removeAllElements();
        if (joinedText == null || joinedText.isEmpty()) {
            return;
        }
        for (String p : parts = joinedText.split(Pattern.quote(new String(new char[]{'\u00ac'})))) {
            this.model.addElement(p);
        }
    }

    public Runnable getSaveHandler() {
        return this.saveHandler;
    }

    public void setSaveHandler(Runnable saveHandler) {
        this.saveHandler = saveHandler;
    }
}

