/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.Object;
import scs.core.IComponent;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.OpenbusBrowser;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.data_service.core.v1_01.ServiceFailure;

public final class SingleServiceFinder {
    private SingleServiceFinder() {
    }

    public static ServiceOfferDesc findFirstOffer(final Connection cnn, ServiceProperty[] properties) throws InterruptedException, tecgraf.openbus.core.v2_0.services.ServiceFailure {
        ManagedConnection.setContextCurrentConnection(cnn);
        ServiceOfferDesc[] offers = ManagedConnection.getContext(cnn).getOfferRegistry().findServices(properties);
        final ArrayList res = new ArrayList();
        final AtomicInteger offersCountDown = new AtomicInteger(offers.length);
        final AtomicBoolean validOfferFound = new AtomicBoolean(false);
        ArrayList<1> threads = new ArrayList<1>();
        for (final ServiceOfferDesc offer : offers) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        ManagedConnection.setContextCurrentConnection(cnn);
                        IComponent o = offer.service_ref;
                        if (!o._non_existent()) {
                            res.add(new FindResult(cnn, offer, o));
                            validOfferFound.set(true);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        offersCountDown.decrementAndGet();
                    }
                }
            };
            t.start();
            threads.add(t);
        }
        while (!validOfferFound.get() && offersCountDown.get() != 0) {
            Thread.sleep(10L);
        }
        for (Thread thread : threads) {
            thread.interrupt();
        }
        if (res.isEmpty()) {
            return null;
        }
        return ((FindResult)res.get((int)0)).desc;
    }

    public static ServiceOfferDesc findSingleOffer(ManagedConnection cnn, ServiceProperty[] properties, boolean mayFindNothing) throws tecgraf.openbus.core.v2_0.services.ServiceFailure, InterruptedException {
        return SingleServiceFinder.findSingleOffer(null, cnn, properties, mayFindNothing);
    }

    public static ServiceOfferDesc findSingleOffer(Component parentForUI, final ManagedConnection cnn, ServiceProperty[] properties, boolean mayFindNothing) throws tecgraf.openbus.core.v2_0.services.ServiceFailure, InterruptedException {
        String message;
        FindResult findResult;
        if (parentForUI == null) {
            parentForUI = OpenbusBrowser.getSingletonInstance();
        }
        cnn.setContextCurrentConnection();
        ServiceOfferDesc[] offers = cnn.getContext().getOfferRegistry().findServices(properties);
        if (offers == null || offers.length == 0) {
            if (!mayFindNothing) {
                JOptionPane.showMessageDialog(parentForUI, "Servi\u00e7o de ofertas da conex\u00e3o n\u00e3o identificou nenhuma oferta com o crit\u00e9rio: \n" + SingleServiceFinder.getPropertiesToString(properties), "Erro", 0);
            }
            return null;
        }
        final ArrayList res = new ArrayList();
        final HashSet exceptions = new HashSet();
        final AtomicInteger offersCountDown = new AtomicInteger(offers.length);
        final AtomicBoolean validOfferFound = new AtomicBoolean(false);
        ArrayList<2> threads = new ArrayList<2>();
        for (final ServiceOfferDesc offer : offers) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        IComponent o = offer.service_ref;
                        if (!o._non_existent()) {
                            res.add(new FindResult(cnn, offer, o));
                            validOfferFound.set(true);
                        }
                    }
                    catch (Throwable e) {
                        String desc = e.getClass().getName();
                        desc = e instanceof tecgraf.openbus.core.v2_0.services.ServiceFailure ? desc + ": " + ((tecgraf.openbus.core.v2_0.services.ServiceFailure)e).message : (e instanceof ServiceFailure ? desc + ": " + ((tecgraf.openbus.core.v2_0.services.ServiceFailure)e).message : desc + ": " + e.getMessage());
                        exceptions.add(desc);
                    }
                    finally {
                        offersCountDown.decrementAndGet();
                    }
                }
            };
            t.start();
            threads.add(t);
        }
        while (!validOfferFound.get() && offersCountDown.get() != 0) {
            Thread.sleep(10L);
        }
        if (offersCountDown.get() > 0 && validOfferFound.get()) {
            Thread.sleep(1000L);
        }
        for (Thread thread : threads) {
            thread.interrupt();
        }
        if (res.size() == 0) {
            String exceptionsDesc = ".";
            if (!exceptions.isEmpty()) {
                exceptionsDesc = " pelas seguintes causas:";
                for (String e : exceptions.toArray(new String[0])) {
                    exceptionsDesc = exceptionsDesc + "\n" + e;
                }
            }
            JOptionPane.showMessageDialog(parentForUI, "Servi\u00e7o de ofertas da conex\u00e3o identificou " + offers.length + " oferta(s) com o crit\u00e9rio: \n" + SingleServiceFinder.getPropertiesToString(properties) + "\nPor\u00e9m nenhuma delas \u00e9 v\u00e1lida" + exceptionsDesc, "Erro", 0);
            return null;
        }
        if (res.size() == 1) {
            return ((FindResult)res.get((int)0)).desc;
        }
        if (res.size() > 1 && (findResult = (FindResult)JOptionPane.showInputDialog(parentForUI, message = "Servi\u00e7o de ofertas da conex\u00e3o identificou " + res.size() + " ofertas v\u00e1lidas com o crit\u00e9rio: \n" + SingleServiceFinder.getPropertiesToString(properties) + "\n Voc\u00ea dever\u00e1 escolher uma.", "Ambiguidade detectada", 3, null, res.toArray(new FindResult[0]), null)) != null) {
            return findResult.desc;
        }
        return null;
    }

    private static final String getPropertiesToString(ServiceProperty[] properties) {
        StringBuilder res = new StringBuilder();
        for (ServiceProperty p : properties) {
            if (res.length() > 0) {
                res.append("\n");
            }
            res.append(p.name + "=" + p.value);
        }
        return res.toString();
    }

    private static final class FindResult {
        final ServiceOfferDesc desc;
        final Object ref;
        final Connection cnn;

        public FindResult(Connection cnn, ServiceOfferDesc desc, Object ref) {
            this.cnn = cnn;
            this.desc = desc;
            this.ref = ref;
        }

        public String toString() {
            String host = "";
            try {
                ParsedIOR ior = new ParsedIOR((ORB)this.cnn.orb(), this.ref.toString());
                IIOPProfile profile = (IIOPProfile)ior.getProfiles().get(0);
                String ip = ((IIOPAddress)profile.getAddress()).getIP();
                String hostname = ((IIOPAddress)profile.getAddress()).getHostname();
                if (hostname != null && !hostname.isEmpty() && !ip.equals(hostname)) {
                    ip = ip + "(" + hostname + ")";
                }
                host = " do host " + ip;
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            String res = "Oferta " + host + " feita ou renovada em " + this.getProperty("openbus.offer.day") + "/" + this.getProperty("openbus.offer.month") + "/" + this.getProperty("openbus.offer.year") + " " + this.getProperty("openbus.offer.hour") + ":" + this.getProperty("openbus.offer.minute") + ":" + this.getProperty("openbus.offer.second") + " por " + this.getProperty("openbus.offer.entity");
            return res;
        }

        private final String getProperty(String propName) {
            if (this.desc.properties != null) {
                for (ServiceProperty p : this.desc.properties) {
                    if (!propName.equals(p.name)) continue;
                    return p.value;
                }
            }
            return "";
        }
    }
}

