/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers;

import java.util.Enumeration;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.omg.CORBA.Object;
import scs.core.ComponentId;
import scs.core.FacetDescription;
import scs.core.IMetaInterface;
import scs.core.IMetaInterfaceHelper;
import scs.core.IReceptacles;
import scs.core.IReceptaclesHelper;
import scs.core.ReceptacleDescription;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.scs_offers.FacetNodeBeanFactory;
import tecgraf.openbus.browser.scs_offers.FindServicesQueryControlInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithHelpTipInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithTreeReference;
import tecgraf.openbus.browser.scs_offers.SCSTree;
import tecgraf.openbus.browser.scs_offers.ServiceOfferManagedBean;
import tecgraf.openbus.browser.scs_offers.ServiceOfferRegistryObserversPool;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ComponentNodeBean;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ComponentVersionNodeBean;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ErrorNodeBean;
import tecgraf.openbus.browser.scs_offers.basic_nodes.FacetNodeBean;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ReceptacleNodeBean;
import tecgraf.openbus.browser.scs_offers.basic_nodes.ServiceOfferNode;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

final class TreeStructureBuilder {
    private static final String INVALID_OFFERS_LABEL = "[OFERTAS INV\u00c1LIDAS]";
    private final ExecutorService threadPool = Executors.newFixedThreadPool(80);
    private final FindServicesQueryControlInterface queryControl;
    private final SCSTree tree;
    private final TreeLoadStatusListener status;
    private final AtomicInteger serialQuery = new AtomicInteger(0);
    private final WeakHashMap<ServiceOfferDesc, IReceptacles> receptaclesCache = new WeakHashMap();

    protected TreeStructureBuilder(FindServicesQueryControlInterface queryControl, SCSTree treeComponents, TreeLoadStatusListener status) {
        this.tree = treeComponents;
        this.status = status;
        this.queryControl = queryControl;
    }

    protected void startLoadingTree(final Connection cnn, final ServiceProperty[] properties) {
        new Thread(){

            @Override
            public void run() {
                TreeStructureBuilder.this.status.startedQuery();
                try {
                    ManagedConnection.setContextCurrentConnection(cnn);
                    OfferRegistry registryService = ManagedConnection.getContext(cnn).getOfferRegistry();
                    ServiceOfferDesc[] services = properties == null || properties.length == 0 ? registryService.getAllServices() : registryService.findServices(properties);
                    TreeStructureBuilder.this.status.startedProcessing(services.length);
                    AtomicInteger queryCounter = new AtomicInteger(0);
                    NodeWithTreeReference root = (NodeWithTreeReference)TreeStructureBuilder.this.tree.getModel().getRoot();
                    int serial = TreeStructureBuilder.this.serialQuery.incrementAndGet();
                    for (ServiceOfferDesc service : services) {
                        TreeStructureBuilder.this.processServiceOffer(cnn, serial, service, queryCounter, root);
                    }
                }
                catch (Throwable e) {
                    TreeStructureBuilder.this.status.error(e);
                }
            }
        }.start();
    }

    public void addServiceOffer(Connection cnn, ServiceOfferDesc service, NodeWithTreeReference root) {
        this.processServiceOffer(cnn, this.serialQuery.get(), service, null, root);
    }

    private void processServiceOffer(final Connection cnn, final int serial, final ServiceOfferDesc service, final AtomicInteger queryCounter, final NodeWithTreeReference root) {
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ManagedConnection.setContextCurrentConnection(cnn);
                    Throwable error = null;
                    ServiceOfferManagedBean offerBean = null;
                    try {
                        offerBean = ServiceOfferRegistryObserversPool.getSingleton().addNewServiceOfferBean(cnn, service.ref);
                    }
                    catch (Throwable e) {
                        error = e;
                    }
                    ComponentId componentId = service.service_ref.getComponentId();
                    java.lang.Object offerObserverBean = offerBean != null ? offerBean : error;
                    Object metaInterfaceObject = service.service_ref.getFacetByName("IMetaInterface");
                    IMetaInterface metaInterface = IMetaInterfaceHelper.narrow(metaInterfaceObject);
                    FacetDescription[] facets = null;
                    if (metaInterface != null) {
                        facets = metaInterface.getFacets();
                    }
                    if (facets != null) {
                        if (serial != TreeStructureBuilder.this.serialQuery.get()) {
                            return;
                        }
                        for (FacetDescription facet : facets) {
                            TreeStructureBuilder.this.processFacet(cnn, serial, service, offerObserverBean, componentId, facet, root);
                        }
                    }
                    ReceptacleDescription[] receptacles = null;
                    if (metaInterface != null) {
                        receptacles = metaInterface.getReceptacles();
                    }
                    if (receptacles != null) {
                        if (serial != TreeStructureBuilder.this.serialQuery.get()) {
                            return;
                        }
                        for (ReceptacleDescription receptacle : receptacles) {
                            TreeStructureBuilder.this.processFacet(cnn, serial, service, offerObserverBean, componentId, receptacle, root);
                        }
                    }
                }
                catch (Throwable e) {
                    if (serial != TreeStructureBuilder.this.serialQuery.get()) {
                        return;
                    }
                    TreeStructureBuilder.this.processInvalidOffer(cnn, serial, service, e, root);
                }
                finally {
                    if (serial != TreeStructureBuilder.this.serialQuery.get()) {
                        return;
                    }
                    if (queryCounter != null) {
                        int counter = queryCounter.incrementAndGet();
                        TreeStructureBuilder.this.status.setProgress(counter);
                    } else {
                        TreeStructureBuilder.this.status.outOfQueryNewOffer();
                    }
                }
            }
        });
    }

    private void processInvalidOffer(final Connection cnn, final int serial, final ServiceOfferDesc service, final Throwable e, final NodeWithTreeReference root) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ServiceOfferNode serviceBean;
                NodeWithTreeReference serviceNode;
                ManagedConnection.setContextCurrentConnection(cnn);
                if (serial != TreeStructureBuilder.this.serialQuery.get()) {
                    return;
                }
                DefaultTreeModel model = (DefaultTreeModel)TreeStructureBuilder.this.tree.getModel();
                NodeWithTreeReference componentNode = TreeStructureBuilder.this.findChildNode(root, TreeStructureBuilder.INVALID_OFFERS_LABEL);
                if (componentNode == null) {
                    componentNode = new NodeWithTreeReference(TreeStructureBuilder.this.tree, TreeStructureBuilder.INVALID_OFFERS_LABEL);
                    TreeStructureBuilder.this.insertNodeSorted(model, componentNode, root);
                }
                if ((serviceNode = TreeStructureBuilder.this.findChildNode(componentNode, serviceBean = new ServiceOfferNode(TreeStructureBuilder.this.tree, TreeStructureBuilder.this.queryControl, cnn, service))) == null) {
                    serviceNode = serviceBean;
                    TreeStructureBuilder.this.insertNodeSorted(model, serviceNode, componentNode);
                }
                Throwable error = e;
                NodeWithTreeReference parent = serviceNode;
                while (error != null) {
                    NodeWithTreeReference newChild = new NodeWithTreeReference(TreeStructureBuilder.this.tree, new ErrorNodeBean(error));
                    model.insertNodeInto(newChild, parent, 0);
                    parent = newChild;
                    error = e.getCause();
                }
                if (TreeStructureBuilder.this.queryControl.isOffersDefaultExpanded()) {
                    TreeStructureBuilder.this.tree.expandPath(new TreePath(componentNode.getPath()));
                } else {
                    TreeStructureBuilder.this.tree.expandPath(new TreePath(root.getPath()));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    private void processFacet(final Connection cnn, final int serial, final ServiceOfferDesc service, final java.lang.Object offerObserverBeanOrThrowable, final ComponentId componentId, final java.lang.Object facetOrReceptacleDescription, final NodeWithTreeReference root) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NodeWithHelpTipInterface facetBean;
                ServiceOfferNode serviceBean;
                NodeWithTreeReference serviceNode;
                ComponentVersionNodeBean versionBean;
                NodeWithTreeReference versionNode;
                ManagedConnection.setContextCurrentConnection(cnn);
                if (serial != TreeStructureBuilder.this.serialQuery.get()) {
                    return;
                }
                DefaultTreeModel model = (DefaultTreeModel)TreeStructureBuilder.this.tree.getModel();
                ComponentNodeBean componentBean = new ComponentNodeBean(componentId);
                NodeWithTreeReference componentNode = TreeStructureBuilder.this.findChildNode(root, componentBean);
                if (componentNode == null) {
                    componentNode = new NodeWithTreeReference(TreeStructureBuilder.this.tree, componentBean);
                    TreeStructureBuilder.this.insertNodeSorted(model, componentNode, root);
                }
                if ((versionNode = TreeStructureBuilder.this.findChildNode(componentNode, versionBean = new ComponentVersionNodeBean(componentId, service.service_ref))) == null) {
                    versionNode = new NodeWithTreeReference(TreeStructureBuilder.this.tree, versionBean, true);
                    TreeStructureBuilder.this.insertNodeSorted(model, versionNode, componentNode);
                }
                if ((serviceNode = TreeStructureBuilder.this.findChildNode(versionNode, serviceBean = new ServiceOfferNode(TreeStructureBuilder.this.tree, TreeStructureBuilder.this.queryControl, cnn, service))) == null) {
                    if (offerObserverBeanOrThrowable != null && offerObserverBeanOrThrowable instanceof ServiceOfferManagedBean) {
                        serviceBean.setOfferPoolBean((ServiceOfferManagedBean)offerObserverBeanOrThrowable);
                    }
                    serviceNode = serviceBean;
                    TreeStructureBuilder.this.insertNodeSorted(model, serviceNode, versionNode);
                    if (offerObserverBeanOrThrowable != null && offerObserverBeanOrThrowable instanceof Throwable) {
                        serviceNode.add(new NodeWithTreeReference(TreeStructureBuilder.this.tree, new ErrorNodeBean((Throwable)offerObserverBeanOrThrowable)));
                    }
                }
                if (facetOrReceptacleDescription instanceof FacetDescription) {
                    FacetDescription facetDescription = (FacetDescription)facetOrReceptacleDescription;
                    facetBean = new FacetNodeBean(cnn, facetDescription);
                } else {
                    IReceptacles iReceptacles = TreeStructureBuilder.this.getIReceptacle(service);
                    ReceptacleDescription receptacleDescription = (ReceptacleDescription)facetOrReceptacleDescription;
                    facetBean = new ReceptacleNodeBean(cnn, service, receptacleDescription, iReceptacles);
                }
                NodeWithTreeReference facetNode = TreeStructureBuilder.this.findChildNode(serviceNode, facetBean);
                if (facetNode == null) {
                    facetNode = FacetNodeBeanFactory.getBeanNode(TreeStructureBuilder.this.tree, cnn, facetBean);
                    facetNode.setUserObject(facetBean);
                    TreeStructureBuilder.this.insertNodeSorted(model, facetNode, serviceNode);
                }
                if (TreeStructureBuilder.this.queryControl.isOffersDefaultExpanded()) {
                    TreeStructureBuilder.this.tree.expandPath(new TreePath(versionNode.getPath()));
                } else {
                    TreeStructureBuilder.this.tree.expandPath(new TreePath(root.getPath()));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    public void removeOffer(final NodeWithTreeReference offerNode) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                NodeWithTreeReference parent;
                NodeWithTreeReference rootNode = (NodeWithTreeReference)offerNode.getRoot();
                if (rootNode == null) {
                    return;
                }
                SCSTree tree = offerNode.getMyTree();
                if (tree.getModel().getRoot() != rootNode) {
                    return;
                }
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                NodeWithTreeReference removedParent = parent = (NodeWithTreeReference)offerNode.getParent();
                if (parent != null) {
                    NodeWithTreeReference grandParent;
                    int idxRemovedFromParent = parent.getIndex(offerNode);
                    parent.remove(offerNode);
                    model.nodesWereRemoved(parent, new int[]{idxRemovedFromParent}, new java.lang.Object[]{offerNode});
                    while (parent != null && (grandParent = (NodeWithTreeReference)parent.getParent()) != null && parent.getChildCount() == 0) {
                        removedParent = grandParent;
                        idxRemovedFromParent = removedParent.getIndex(parent);
                        grandParent.remove(parent);
                        model.nodesWereRemoved(grandParent, new int[]{idxRemovedFromParent}, new java.lang.Object[]{parent});
                        parent = grandParent;
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
        if (offerNode instanceof ServiceOfferNode) {
            this.status.outOfQueryRemovedOffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IReceptacles getIReceptacle(ServiceOfferDesc service) {
        WeakHashMap<ServiceOfferDesc, IReceptacles> weakHashMap = this.receptaclesCache;
        synchronized (weakHashMap) {
            IReceptacles res = this.receptaclesCache.get(service);
            if (res != null) {
                return res;
            }
            res = IReceptaclesHelper.narrow(service.service_ref.getFacet(IReceptaclesHelper.id()));
            this.receptaclesCache.put(service, res);
            return res;
        }
    }

    private final void insertNodeSorted(DefaultTreeModel model, NodeWithTreeReference newChild, NodeWithTreeReference parent) {
        int pos = 0;
        String myLbl = newChild.getUserObject().toString();
        if (!myLbl.equals(INVALID_OFFERS_LABEL)) {
            NodeWithTreeReference node;
            String otherLbl;
            Enumeration<TreeNode> enumChild = parent.children();
            while (enumChild.hasMoreElements() && (myLbl.compareTo(otherLbl = (node = (NodeWithTreeReference)enumChild.nextElement()).getUserObject().toString()) >= 0 || otherLbl.equals(INVALID_OFFERS_LABEL))) {
                ++pos;
            }
        }
        model.insertNodeInto(newChild, parent, pos);
    }

    private NodeWithTreeReference findChildNode(NodeWithTreeReference parentNode, java.lang.Object textNode) {
        int childCount = parentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeWithTreeReference node = (NodeWithTreeReference)parentNode.getChildAt(i);
            if (!node.getUserObject().equals(textNode)) continue;
            return node;
        }
        return null;
    }

    protected static interface TreeLoadStatusListener {
        public void startedQuery();

        public void startedProcessing(int var1);

        public void setProgress(int var1);

        public void error(Throwable var1);

        public void outOfQueryNewOffer();

        public void outOfQueryRemovedOffer();
    }
}

