/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers.basic_nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.omg.CORBA.ORB;
import scs.core.FacetDescription;
import scs.core.FacetDescriptionHelper;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.TipPanelInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithHelpTipInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.OfferRegistryPanel;

public final class FacetNodeBean
implements NodeWithIconsInterface,
Transferable,
NodeWithHelpTipInterface {
    private final FacetDescription facetDescription;
    private final Connection cnn;
    private final DataFlavor myInterfaceFlavor;
    private static final ImageIcon icon = new ImageIcon(OfferRegistryPanel.class.getResource("port.png"));
    public static final DataFlavor FACET_DESCRIPTION_DATA_FLAVOR = new DataFlavor(TransferableFacetDescription.class, FacetDescriptionHelper.id());

    public FacetNodeBean(Connection cnn, FacetDescription facetDescription) {
        this.cnn = cnn;
        this.facetDescription = facetDescription;
        this.myInterfaceFlavor = new DataFlavor(TransferableFacetDescription.class, facetDescription.interface_name);
    }

    public final FacetDescription getFacetDescription() {
        return this.facetDescription;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.facetDescription == null ? 0 : this.facetDescription.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetNodeBean)) {
            return false;
        }
        FacetNodeBean other = (FacetNodeBean)obj;
        if (this.facetDescription == null) {
            if (other.facetDescription != null) {
                return false;
            }
        } else {
            if (!this.facetDescription.interface_name.equals(other.facetDescription.interface_name)) {
                return false;
            }
            if (!this.facetDescription.name.equals(other.facetDescription.name)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.facetDescription.name + "(" + this.facetDescription.interface_name + ")";
    }

    @Override
    public Icon getClosedIcon() {
        return icon;
    }

    @Override
    public Icon getLeafIcon() {
        return icon;
    }

    @Override
    public Icon getOpenedIcon() {
        return icon;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (FACET_DESCRIPTION_DATA_FLAVOR.equals(flavor) || this.myInterfaceFlavor.equals(flavor)) {
            ManagedConnection.setContextCurrentConnection(this.cnn);
            return new TransferableFacetDescription(this.cnn.orb(), this.facetDescription);
        }
        if (DataFlavor.getTextPlainUnicodeFlavor().equals(flavor)) {
            ManagedConnection.setContextCurrentConnection(this.cnn);
            return new ByteArrayInputStream(this.cnn.orb().object_to_string(this.facetDescription.facet_ref).getBytes(Charset.forName(DataFlavor.getTextPlainUnicodeFlavor().getParameter("charset"))));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{FACET_DESCRIPTION_DATA_FLAVOR, this.myInterfaceFlavor, DataFlavor.getTextPlainUnicodeFlavor()};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return FACET_DESCRIPTION_DATA_FLAVOR.equals(flavor) || this.myInterfaceFlavor.equals(flavor) || DataFlavor.getTextPlainUnicodeFlavor().equals(flavor);
    }

    @Override
    public void configureHelpTip(TipPanelInterface tipPanel) {
        tipPanel.setTips(new String[]{"Para conectar uma faceta a um recept\u00e1culo, voc\u00ea pode arrastar o n\u00f3 da \u00e1rvore da faceta desejada at\u00e9 o n\u00f3 deste recept\u00e1culo.", "Para conectar uma faceta \u00e0 este recept\u00e1culo, voc\u00ea pode \"copiar e colar\" n\u00f3 da \u00e1rvore da faceta desejada no n\u00f3 deste recept\u00e1culo.", "Para desconectar uma faceta, selecione-a na lista de conex\u00f5es acima e digite [DEL].", "Para desconectar uma faceta, selecione-a na lista de conex\u00f5es acima e clique com o bot\u00e3o direito.", "Tecle [F5] para recarregar a lista de conex\u00f5es deste recept\u00e1culo do componente.", "Se voc\u00ea copiar (ctrl+c) o n\u00f3 da faceta e col\u00e1-lo em uma caixa de texto, voc\u00ea obter\u00e1 o IOR do objeto remoto."}, new String[0]);
    }

    public static final class TransferableFacetDescription
    implements Serializable {
        private static final long serialVersionUID = 820908851647708819L;
        public final String name;
        public final String interface_name;
        public final String ior;

        public TransferableFacetDescription(ORB orb, FacetDescription facetDescription) {
            this.name = facetDescription.name;
            this.interface_name = facetDescription.interface_name;
            this.ior = orb.object_to_string(facetDescription.facet_ref);
        }
    }
}

