/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.browser.scs_offers.data_service;

import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import tecgraf.openbus.Connection;
import tecgraf.openbus.browser.ManagedConnection;
import tecgraf.openbus.browser.OpenbusBrowser;
import tecgraf.openbus.browser.SlowRequester;
import tecgraf.openbus.browser.TipPanelInterface;
import tecgraf.openbus.browser.scs_offers.AsyncExpandableTreeNode;
import tecgraf.openbus.browser.scs_offers.NodeWithDetailsInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithDropBehaviorInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithHelpTipInterface;
import tecgraf.openbus.browser.scs_offers.NodeWithIconsInterface;
import tecgraf.openbus.browser.scs_offers.SCSTree;
import tecgraf.openbus.browser.scs_offers.basic_nodes.FacetNodeBean;
import tecgraf.openbus.browser.scs_offers.data_service.DataKeyNodeDetailsPanel;
import tecgraf.openbus.browser.scs_offers.data_service.DataServiceUtils;
import tecgraf.openbus.data_service.core.v1_01.DataDescription;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalManagementDataService;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalNavigationDataService;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalNavigationDataServiceHelper;

final class DataKeyNodeBean
extends AsyncExpandableTreeNode
implements NodeWithDetailsInterface,
NodeWithIconsInterface,
Transferable,
NodeWithDropBehaviorInterface,
NodeWithHelpTipInterface {
    private final FacetNodeBean myFacetBean;
    private final DataDescription dataDescription;
    private final Connection cnn;
    private WeakReference<DataKeyNodeDetailsPanel> detailsPanel = null;
    private static final ImageIcon iconFolderEmpty = new ImageIcon(DataKeyNodeBean.class.getResource("folder.png"));
    private static final ImageIcon iconFolderFilled = new ImageIcon(DataKeyNodeBean.class.getResource("folder_page_white.png"));
    private static final ImageIcon iconLeafOneDataView = new ImageIcon(DataKeyNodeBean.class.getResource("page_white.png"));
    private static final ImageIcon iconLeafMoreDataViews = new ImageIcon(DataKeyNodeBean.class.getResource("page_white_stack.png"));
    private static final ImageIcon iconLeafNoDataViews = new ImageIcon(DataKeyNodeBean.class.getResource("document_empty.png"));

    protected DataKeyNodeBean(SCSTree tree, Connection cnn, FacetNodeBean myFacetBean, DataDescription dataDescription) {
        super(tree);
        this.myFacetBean = myFacetBean;
        this.dataDescription = dataDescription;
        this.cnn = cnn;
    }

    @Override
    protected String getLoadingDescription() {
        return "Aguardando retorno de IHierarchicalNavigationDataService.getChildren()...";
    }

    @Override
    protected List<DefaultMutableTreeNode> loadChildren() throws Exception {
        ManagedConnection.setContextCurrentConnection(this.cnn);
        IHierarchicalNavigationDataService hdsn = IHierarchicalNavigationDataServiceHelper.narrow(this.myFacetBean.getFacetDescription().facet_ref);
        DataDescription[] roots = hdsn.getChildren(this.dataDescription.fKey);
        LinkedList<DefaultMutableTreeNode> res = new LinkedList<DefaultMutableTreeNode>();
        if (roots != null) {
            for (DataDescription ds : roots) {
                res.add(new DataKeyNodeBean(this.getMyTree(), this.cnn, this.myFacetBean, ds));
            }
        }
        return res;
    }

    @Override
    public String toString() {
        return this.dataDescription.fName;
    }

    @Override
    public JPanel getDetailsPanel() {
        DataKeyNodeDetailsPanel res = null;
        if (this.detailsPanel != null) {
            res = (DataKeyNodeDetailsPanel)this.detailsPanel.get();
        }
        if (res == null) {
            res = new DataKeyNodeDetailsPanel(this);
            this.detailsPanel = new WeakReference<DataKeyNodeDetailsPanel>(res);
        }
        return res;
    }

    public FacetNodeBean getMyFacetBean() {
        return this.myFacetBean;
    }

    public DataDescription getDataDescription() {
        return this.dataDescription;
    }

    public Connection getCnn() {
        return this.cnn;
    }

    @Override
    public Object getUserObject() {
        return this;
    }

    private final int getNumDataViews() {
        if (this.dataDescription == null) {
            return 0;
        }
        int c = 0;
        if (this.dataDescription.fDefaultView != null && this.dataDescription.fDefaultView.fInterfaceName != null && !this.dataDescription.fDefaultView.fInterfaceName.trim().isEmpty()) {
            ++c;
        }
        if (this.dataDescription.fOthersViews != null) {
            for (String v : this.dataDescription.fOthersViews) {
                if (v == null || v.trim().isEmpty()) continue;
                ++c;
            }
        }
        return c;
    }

    @Override
    public Icon getClosedIcon() {
        return this.getOpenedIcon();
    }

    @Override
    public Icon getLeafIcon() {
        switch (this.getNumDataViews()) {
            case 0: {
                return iconLeafNoDataViews;
            }
            case 1: {
                return iconLeafOneDataView;
            }
        }
        return iconLeafMoreDataViews;
    }

    @Override
    public Icon getOpenedIcon() {
        switch (this.getNumDataViews()) {
            case 0: {
                return iconFolderEmpty;
            }
        }
        return iconFolderFilled;
    }

    @Override
    public int accept(DataFlavor dataFlavor) {
        return DataServiceUtils.DATAKEY_FLAVOR_BIN.equals(dataFlavor) ? 3 : 0;
    }

    @Override
    public boolean doDrop(final Transferable transferable) throws Exception {
        if (!transferable.isDataFlavorSupported(DataServiceUtils.DATAKEY_FLAVOR_BIN)) {
            throw new UnsupportedFlavorException(DataServiceUtils.DATAKEY_FLAVOR_BIN);
        }
        SlowRequester.run(new SlowRequester.SlowRunnable(){

            @Override
            public void run() throws Exception {
                this.setProgress("Lendo DataDescription do objeto trazido");
                DataDescription theirDS = DataServiceUtils.getDataDescription(DataKeyNodeBean.this.cnn, transferable);
                if (theirDS == null) {
                    JOptionPane.showMessageDialog(OpenbusBrowser.getSingletonInstance(), "N\u00e3o foi poss\u00edvel localizar o servi\u00e7o DataService respons\u00e1vel pelo Datakey arrastado at\u00e9 aqui. Nada a fazer", "Erro", 0);
                    return;
                }
                this.setProgress("Procurando IHierarchicalManagementDataService de " + ((DataKeyNodeBean)DataKeyNodeBean.this).dataDescription.fName);
                IHierarchicalManagementDataService myManagement = DataServiceUtils.getHManagementDataServiceFor(DataKeyNodeBean.this.cnn, ((DataKeyNodeBean)DataKeyNodeBean.this).dataDescription.fKey);
                this.setProgress("Procurando IHierarchicalManagementDataService de " + theirDS.fName);
                IHierarchicalManagementDataService theirManagement = DataServiceUtils.getHManagementDataServiceFor(DataKeyNodeBean.this.cnn, theirDS.fKey);
                JPopupMenu popup = new JPopupMenu(((DataKeyNodeBean)DataKeyNodeBean.this).dataDescription.fName + "->" + theirDS.fName);
                if (myManagement != null && theirManagement != null && myManagement._is_equivalent(theirManagement)) {
                    popup.add(DataKeyNodeBean.this.getMenuForHManagementDataService("IHierarchicalManagementDataService", myManagement, DataKeyNodeBean.this.dataDescription, theirDS));
                } else {
                    if (myManagement != null) {
                        popup.add(DataKeyNodeBean.this.getMenuForHManagementDataService("IHierarchicalManagementDataService de " + ((DataKeyNodeBean)DataKeyNodeBean.this).dataDescription.fName, myManagement, DataKeyNodeBean.this.dataDescription, theirDS));
                    }
                    if (theirManagement != null) {
                        popup.add(DataKeyNodeBean.this.getMenuForHManagementDataService("IHierarchicalManagementDataService de " + theirDS.fName, theirManagement, DataKeyNodeBean.this.dataDescription, theirDS));
                    }
                }
                if (popup.getSubElements() == null || popup.getSubElements().length == 0) {
                    JOptionPane.showMessageDialog(OpenbusBrowser.getSingletonInstance(), "Nenhuma opera\u00e7\u00e3o eleg\u00edvel encontrada.\nN\u00e3o h\u00e1 IHierarchicalManagementDataService dispon\u00edvel para os DataKeys selecionados.", "Nada a fazer", 1);
                } else {
                    int y;
                    int x;
                    if (DataKeyNodeBean.this.getMyTree().getSelectionRows() == null || DataKeyNodeBean.this.getMyTree().getSelectionRows().length != 1) {
                        x = DataKeyNodeBean.this.getMyTree().getMousePosition().x;
                        y = DataKeyNodeBean.this.getMyTree().getMousePosition().y;
                    } else {
                        int sel = DataKeyNodeBean.this.getMyTree().getSelectionRows()[0];
                        Rectangle bounds = DataKeyNodeBean.this.getMyTree().getRowBounds(sel);
                        x = (int)bounds.getCenterX();
                        y = (int)bounds.getMaxY();
                    }
                    popup.show(DataKeyNodeBean.this.getMyTree(), x, y);
                }
            }
        }, false);
        return true;
    }

    private JMenu getMenuForHManagementDataService(String label, IHierarchicalManagementDataService management, DataDescription ds1, DataDescription ds2) {
        JMenu res = new JMenu(label);
        res.add(this.getPopupItemForHMDSCopy(management, ds1, ds2));
        res.add(this.getPopupItemForHMDSMove(management, ds1, ds2));
        return res;
    }

    private JMenuItem getPopupItemForHMDSCopy(final IHierarchicalManagementDataService management, final DataDescription ds1, final DataDescription ds2) {
        JMenuItem res = new JMenuItem("copyData(" + ds1.fName + ", " + ds2.fName + ")");
        res.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlowRequester.run(new SlowRequester.SlowRunnable(){

                    @Override
                    public void run() throws Exception {
                        ManagedConnection.setContextCurrentConnection(DataKeyNodeBean.this.cnn);
                        if (management.copyData(ds1.fKey, ds2.fKey) != null) {
                            DataKeyNodeBean.this.refreshNode();
                        }
                        JOptionPane.showMessageDialog(DataKeyNodeBean.this.getMyTree(), "copyData() executado sem lan\u00e7amento de exce\u00e7\u00e3o.", "DataService", 1);
                    }
                }, true);
            }
        });
        return res;
    }

    private JMenuItem getPopupItemForHMDSMove(final IHierarchicalManagementDataService management, final DataDescription ds1, final DataDescription ds2) {
        JMenuItem res = new JMenuItem("moveData(" + ds1.fName + ", " + ds2.fName + ")");
        res.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlowRequester.run(new SlowRequester.SlowRunnable(){

                    @Override
                    public void run() throws Exception {
                        ManagedConnection.setContextCurrentConnection(DataKeyNodeBean.this.cnn);
                        management.moveData(ds1.fKey, ds2.fKey);
                        JOptionPane.showMessageDialog(DataKeyNodeBean.this.getMyTree(), "moveData() executado sem lan\u00e7amento de exce\u00e7\u00e3o.", "DataService", 1);
                    }
                }, true);
            }
        });
        return res;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataServiceUtils.DATAKEY_FLAVOR_BIN, DataFlavor.getTextPlainUnicodeFlavor()};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataServiceUtils.DATAKEY_FLAVOR_BIN.equals(flavor) || DataFlavor.getTextPlainUnicodeFlavor().equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DataServiceUtils.DATAKEY_FLAVOR_BIN.equals(flavor)) {
            return this.dataDescription.fKey;
        }
        if (DataFlavor.getTextPlainUnicodeFlavor().equals(flavor)) {
            return new ByteArrayInputStream(this.dataDescription.fName.getBytes(Charset.forName(DataFlavor.getTextPlainUnicodeFlavor().getParameter("charset"))));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void configureHelpTip(TipPanelInterface tipPanel) {
        tipPanel.setTips(new String[]{"Para usar os servi\u00e7os do IHierarchicalManagementDataService, voc\u00ea pode arrastar um n\u00f3 de DataService para outro.", "Para usar os servi\u00e7os do IHierarchicalManagementDataService, voc\u00ea pode copiar e colar n\u00f3s de DataService entre si.", "Se voc\u00ea quiser recarregar algum n\u00f3 (reexecutar a chamada getChildren), basta clicar sobre o n\u00f3 e teclar F5."}, new String[0]);
    }
}

