/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Arrays;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.core.LegacySupport;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;

final class CallerChainImpl
implements CallerChain {
    private String busid;
    private String target;
    private LoginInfo[] originators;
    private LoginInfo caller;
    private SignedCallChain signedChain;
    private ChainType type;

    public CallerChainImpl(String busid, CallChain chain, SignedCallChain signedChain) {
        this(busid, chain.target, chain.caller, chain.originators, signedChain);
    }

    CallerChainImpl(String busid, String target, LoginInfo caller, LoginInfo[] originators, SignedCallChain signedChain) {
        this.busid = busid;
        this.target = target;
        this.caller = caller;
        this.originators = originators;
        this.signedChain = signedChain;
        this.type = !Arrays.equals(LegacySupport.LEGACY_ENCRYPTED_BLOCK, signedChain.signature) ? ChainType.CHAIN_2_0 : ChainType.CHAIN_1_5;
    }

    @Override
    public String busid() {
        return this.busid;
    }

    @Override
    public String target() {
        return this.target;
    }

    @Override
    public LoginInfo[] originators() {
        return this.originators;
    }

    @Override
    public LoginInfo caller() {
        return this.caller;
    }

    protected SignedCallChain signedCallChain() {
        return this.signedChain;
    }

    protected ChainType type() {
        return this.type;
    }

    static enum ChainType {
        CHAIN_2_0,
        CHAIN_1_5;

    }
}

