/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.CredentialWrapper;
import tecgraf.openbus.core.InterceptorImpl;
import tecgraf.openbus.core.LegacySupport;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.Session;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.CredentialHelper;
import tecgraf.openbus.core.v2_0.OctetSeqHolder;
import tecgraf.openbus.core.v2_0.credential.CredentialData;
import tecgraf.openbus.core.v2_0.credential.CredentialDataHelper;
import tecgraf.openbus.core.v2_0.credential.CredentialReset;
import tecgraf.openbus.core.v2_0.credential.CredentialResetHelper;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.credential.SignedCallChainHelper;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.security.Cryptography;

final class ServerRequestInterceptorImpl
extends InterceptorImpl
implements ServerRequestInterceptor {
    private static final Logger logger = Logger.getLogger(ServerRequestInterceptorImpl.class.getName());
    private static final String UNKNOWN_BUS = "";

    ServerRequestInterceptorImpl(String name, ORBMediator mediator) {
        super(name, mediator);
    }

    @Override
    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        logger.finest(String.format("[inout] receive_request_service_contexts: %s", ri.operation()));
    }

    private CredentialWrapper retrieveCredential(ServerRequestInfo ri) {
        ORB orb = this.mediator().getORB();
        Codec codec = this.mediator().getCodec();
        byte[] encodedCredential = null;
        try {
            ServiceContext requestServiceContext = ri.get_request_service_context(1112888064);
            encodedCredential = requestServiceContext.context_data;
        }
        catch (BAD_PARAM e) {
            switch (e.minor) {
                case 23: 
                case 26: {
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        if (encodedCredential != null) {
            try {
                Any any = codec.decode_value(encodedCredential, CredentialDataHelper.type());
                CredentialData credential = CredentialDataHelper.extract(any);
                return new CredentialWrapper(false, credential, null);
            }
            catch (TypeMismatch e) {
                String message = "Falha inesperada ao decodificar a credencial";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
            catch (FormatMismatch e) {
                String message = "Falha inesperada ao decodificar a credencial";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
        }
        int legacyContextId = 1234;
        byte[] encodedLegacyCredential = null;
        try {
            ServiceContext serviceContext = ri.get_request_service_context(legacyContextId);
            encodedLegacyCredential = serviceContext.context_data;
        }
        catch (BAD_PARAM e) {
            switch (e.minor) {
                case 23: 
                case 26: {
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        if (encodedLegacyCredential != null) {
            CredentialWrapper wrapper = new CredentialWrapper();
            try {
                Any anyLegacy = codec.decode_value(encodedLegacyCredential, CredentialHelper.type());
                Credential legacyCredential = CredentialHelper.extract(anyLegacy);
                String loginId = legacyCredential.identifier;
                String entity = legacyCredential.owner;
                LoginInfo[] originators = !legacyCredential.delegate.equals(UNKNOWN_BUS) ? new LoginInfo[]{new LoginInfo("<unknown>", legacyCredential.delegate)} : new LoginInfo[]{};
                CallChain callChain = new CallChain(UNKNOWN_BUS, originators, new LoginInfo(loginId, entity));
                Any anyCallChain = orb.create_any();
                CallChainHelper.insert(anyCallChain, callChain);
                byte[] encodedCallChain = codec.encode_value(anyCallChain);
                CredentialData credential = new CredentialData();
                credential.bus = UNKNOWN_BUS;
                credential.login = loginId;
                credential.session = -1;
                credential.ticket = -1;
                credential.hash = LegacySupport.LEGACY_HASH;
                credential.chain = new SignedCallChain(LegacySupport.LEGACY_ENCRYPTED_BLOCK, encodedCallChain);
                wrapper.isLegacy = true;
                wrapper.credential = credential;
                wrapper.legacyCredential = legacyCredential;
                return wrapper;
            }
            catch (TypeMismatch e) {
                String message = String.format("Falha ao decodificar a credencial 1.5: %s", e.getClass().getSimpleName());
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message, 0, CompletionStatus.COMPLETED_NO);
            }
            catch (FormatMismatch e) {
                String message = String.format("Falha ao decodificar a credencial 1.5: %s", e.getClass().getSimpleName());
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message, 0, CompletionStatus.COMPLETED_NO);
            }
            catch (InvalidTypeForEncoding e) {
                String message = String.format("Falha ao construir credencial 2.0 a partir da 1.5: %s", e.getClass().getSimpleName());
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message, 0, CompletionStatus.COMPLETED_NO);
            }
        }
        String message = "Nenhuma credencial suportada encontrada";
        logger.info(message);
        throw new NO_PERMISSION(message, 1112888070, CompletionStatus.COMPLETED_NO);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void receive_request(ServerRequestInfo ri) {
        String operation;
        block25: {
            operation = ri.operation();
            logger.finest(String.format("[in] receive_request: %s", operation));
            int requestId = ri.request_id();
            byte[] object_id = ri.object_id();
            ORB orb = this.mediator().getORB();
            OpenBusContextImpl context = this.mediator().getContext();
            CredentialWrapper wrapper = this.retrieveCredential(ri);
            try {
                CredentialData credential = wrapper.credential;
                if (credential != null) {
                    String entity;
                    String busId = credential.bus;
                    String loginId = credential.login;
                    ConnectionImpl conn = this.getConnForDispatch(context, busId, loginId, object_id, operation);
                    logger.finest(String.format("Conex\u00e3o para o dispatch: conex\u00e3o (%s) login (%s) opera\u00e7\u00e3o (%s) requestId (%s)", conn.connId(), conn.login().id, operation, requestId));
                    context.setCurrentConnection(conn);
                    boolean valid = false;
                    if (!wrapper.isLegacy) {
                        try {
                            valid = conn.cache.logins.validateLogin(loginId);
                        }
                        catch (NO_PERMISSION e) {
                            if (e.minor == 1112888319) {
                                String message = "Erro ao validar o login. Conex\u00e3o dispatcher est\u00e1 deslogada. opera\u00e7\u00e3o (%s) requestId (%d)";
                                logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                                throw new NO_PERMISSION(1112888068, CompletionStatus.COMPLETED_NO);
                            }
                            String message = "Erro ao validar o login. opera\u00e7\u00e3o (%s) requestId (%d)";
                            logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                            throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
                        }
                        catch (Exception e) {
                            String message = "Erro ao validar o login.";
                            logger.log(Level.SEVERE, message, e);
                            throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
                        }
                        if (!valid) {
                            throw new NO_PERMISSION(1112888066, CompletionStatus.COMPLETED_NO);
                        }
                    } else {
                        try {
                            if (conn.cache.logins.validateLogin(loginId) && conn.cache.valids.isValid(wrapper.legacyCredential)) {
                                valid = true;
                            }
                        }
                        catch (Exception e) {
                            String message = "Erro ao validar o login 1.5  opera\u00e7\u00e3o (%s) requestId (%d)";
                            logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
                        }
                        if (!valid) {
                            String msg = "Login de credencial 1.5 n\u00e3o \u00e9 v\u00e1lido: login (%s) opera\u00e7\u00e3o (%s) requestId (%d)";
                            logger.fine(String.format(msg, loginId, operation, requestId));
                            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
                        }
                    }
                    OctetSeqHolder pubkey = new OctetSeqHolder();
                    try {
                        entity = conn.cache.logins.getLoginEntity(loginId, pubkey);
                    }
                    catch (InvalidLogins e) {
                        String message = "Erro ao verificar o login. opera\u00e7\u00e3o (%s) requestId (%d)";
                        logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                        throw new NO_PERMISSION(1112888066, CompletionStatus.COMPLETED_NO);
                    }
                    catch (ServiceFailure e) {
                        String message = "Erro ao verificar o login. opera\u00e7\u00e3o (%s) requestId (%d)";
                        logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                        throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
                    }
                    catch (NO_PERMISSION e) {
                        if (e.minor == 1112888319) {
                            String message = "Erro ao verificar o login. Conex\u00e3o dispatcher est\u00e1 deslogada. opera\u00e7\u00e3o (%s) requestId (%d)";
                            logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                            throw new NO_PERMISSION(1112888068, CompletionStatus.COMPLETED_NO);
                        }
                        String message = "Erro ao verificar o login. opera\u00e7\u00e3o (%s) requestId (%d)";
                        logger.log(Level.SEVERE, String.format(message, operation, requestId), e);
                        throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
                    }
                    catch (Exception e) {
                        String message = "Erro ao verificar o login.";
                        logger.log(Level.SEVERE, message, e);
                        throw new NO_PERMISSION(1112888067, CompletionStatus.COMPLETED_NO);
                    }
                    if (!this.validateCredential(credential, ri, conn)) {
                        logger.finest(String.format("Recebeu chamada sem sess\u00e3o associda: opera\u00e7\u00e3o (%s) requestId (%d)", operation, requestId));
                        this.doResetCredential(ri, orb, conn, loginId, pubkey.value);
                        throw new NO_PERMISSION(1112888064, CompletionStatus.COMPLETED_NO);
                    }
                    if (!this.validateChain(credential, pubkey, ri, conn)) {
                        logger.finest(String.format("Recebeu chamada com cadeia inv\u00e1lida: opera\u00e7\u00e3o (%s) requestId (%d)", operation, requestId));
                        throw new NO_PERMISSION(1112888065, CompletionStatus.COMPLETED_NO);
                    }
                    Any any = orb.create_any();
                    any.insert_string(conn.busid());
                    ri.set_slot(this.mediator().getBusSlotId(), any);
                    String msg = "Recebendo chamada pelo barramento: login (%s) entidade (%s) opera\u00e7\u00e3o (%s) requestId (%d)";
                    logger.fine(String.format(msg, loginId, entity, operation, requestId));
                    this.setCurrentConnection(ri, conn);
                    break block25;
                }
                logger.fine(String.format("Recebeu chamada fora do barramento: opera\u00e7\u00e3o (%s) requestId (%d)", operation, requestId));
            }
            catch (InvalidSlot e) {
                try {
                    String message = "Falha inesperada ao acessar o slot da credencial";
                    logger.log(Level.SEVERE, message, e);
                    throw new INTERNAL(message);
                    catch (CryptographyException e2) {
                        message = "Falha ao criptografar com chave p\u00fablica";
                        logger.log(Level.SEVERE, message, e2);
                        throw new NO_PERMISSION(1112888069, CompletionStatus.COMPLETED_NO);
                    }
                }
                catch (Throwable throwable) {
                    logger.finest(String.format("[out] receive_request: %s", operation));
                    throw throwable;
                }
            }
        }
        logger.finest(String.format("[out] receive_request: %s", operation));
    }

    private ConnectionImpl getConnForDispatch(OpenBusContextImpl context, String busId, String loginId, byte[] object_id, String operation) {
        ConnectionImpl conn = null;
        CallDispatchCallback onCallDispatch = context.onCallDispatch();
        if (onCallDispatch != null) {
            try {
                conn = (ConnectionImpl)onCallDispatch.dispatch(context, busId, loginId, object_id, operation);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Callback 'onCallDispatch' gerou um erro durante execu\u00e7\u00e3o.", e);
            }
        }
        if (conn == null && (conn = (ConnectionImpl)context.getDefaultConnection()) == null) {
            throw new NO_PERMISSION(1112888068, CompletionStatus.COMPLETED_NO);
        }
        if (conn.login() == null || !conn.busid().equals(busId) && !UNKNOWN_BUS.equals(busId)) {
            throw new NO_PERMISSION(1112888068, CompletionStatus.COMPLETED_NO);
        }
        return conn;
    }

    private void doResetCredential(ServerRequestInfo ri, ORB orb, ConnectionImpl conn, String caller, byte[] publicKey) throws CryptographyException {
        byte[] encodedCredential;
        byte[] newSecret = this.newSecret();
        Cryptography crypto = Cryptography.getInstance();
        byte[] encriptedSecret = crypto.encrypt(newSecret, crypto.generateRSAPublicKeyFromX509EncodedKey(publicKey));
        int sessionId = conn.nextAvailableSessionId();
        Session.ServerSideSession newSession = new Session.ServerSideSession(sessionId, newSecret, caller);
        conn.cache.srvSessions.put(newSession.getSession(), newSession);
        CredentialReset reset = new CredentialReset(conn.login().id, sessionId, encriptedSecret);
        Any any = orb.create_any();
        CredentialResetHelper.insert(any, reset);
        try {
            encodedCredential = this.mediator().getCodec().encode_value(any);
        }
        catch (InvalidTypeForEncoding e) {
            String message = String.format("Falha inesperada ao codificar a credencial: opera\u00e7\u00e3o (%s) requestId (%d)", ri.operation(), ri.request_id());
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        logger.finest(String.format("Resetando a credencial: opera\u00e7\u00e3o (%s) requestId (%d)", ri.operation(), ri.request_id()));
        ServiceContext requestServiceContext = new ServiceContext(1112888064, encodedCredential);
        ri.add_reply_service_context(requestServiceContext, false);
    }

    private boolean validateCredential(CredentialData credential, ServerRequestInfo ri, ConnectionImpl conn) {
        if (Arrays.equals(credential.hash, LegacySupport.LEGACY_HASH)) {
            logger.finest("Credencial OpenBus 1.5");
            return true;
        }
        Session.ServerSideSession session = conn.cache.srvSessions.get(credential.session);
        if (session != null && session.getCaller().equals(credential.login)) {
            logger.finest(String.format("sess\u00e3o utilizada: id = %d ticket = %d", session.getSession(), credential.ticket));
            byte[] hash = this.generateCredentialDataHash(ri, session.getSecret(), credential.ticket);
            if (Arrays.equals(hash, credential.hash) && session.checkTicket(credential.ticket)) {
                return true;
            }
            logger.finest("Falha na valida\u00e7\u00e3o do hash da credencial");
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateChain(CredentialData credential, OctetSeqHolder pubkey, ServerRequestInfo ri, ConnectionImpl conn) {
        crypto = Cryptography.getInstance();
        busPubKey = conn.getBusPublicKey();
        chain = credential.chain;
        isValid = false;
        if (chain != null) {
            callChain = this.unmarshallSignedChain(chain, ServerRequestInterceptorImpl.logger);
            if (!Arrays.equals(chain.signature, LegacySupport.LEGACY_ENCRYPTED_BLOCK)) {
                try {
                    verified = crypto.verifySignature(busPubKey, chain.encoded, chain.signature);
                    if (!verified) ** GOTO lbl28
                    loginInfo = conn.login();
                    if (callChain.target.equals(loginInfo.entity)) {
                        caller = callChain.caller;
                        if (!caller.id.equals(credential.login)) ** GOTO lbl28
                        isValid = true;
                    }
                    orb = this.mediator().getORB();
                    ServerRequestInterceptorImpl.logger.finest(String.format("O login n\u00e3o \u00e9 o mesmo do alvo da cadeia. \u00c9 necess\u00e1rio refazer a sess\u00e3o de credencial atrav\u00e9s de um reset. Opera\u00e7\u00e3o: %s", new Object[]{ri.operation()}));
                    this.doResetCredential(ri, orb, conn, credential.login, pubkey.value);
                    throw new NO_PERMISSION(1112888064, CompletionStatus.COMPLETED_NO);
                }
                catch (CryptographyException e) {
                    message = "Falha inesperada ao verificar assinatura da cadeia.";
                    ServerRequestInterceptorImpl.logger.log(Level.SEVERE, message, e);
                    throw new INTERNAL(message);
                }
            } else {
                ServerRequestInterceptorImpl.logger.finest("Cadeia OpenBus 1.5");
                callChain.target = conn.login().entity;
                isValid = true;
            }
lbl28:
            // 4 sources

            if (isValid) {
                try {
                    orb = this.mediator().getORB();
                    singnedAny = orb.create_any();
                    SignedCallChainHelper.insert(singnedAny, chain);
                    ri.set_slot(this.mediator().getSignedChainSlotId(), singnedAny);
                }
                catch (InvalidSlot e) {
                    message = "Falha inesperada ao armazenar o dados no slot de contexto";
                    ServerRequestInterceptorImpl.logger.log(Level.SEVERE, message, e);
                    throw new INTERNAL(message);
                }
            }
        }
        return isValid;
    }

    @Override
    public void send_reply(ServerRequestInfo ri) {
        String operation = ri.operation();
        logger.finest(String.format("[in] send_reply: %s", operation));
        this.removeCurrentConnection(ri);
        Any any = this.mediator().getORB().create_any();
        try {
            ri.set_slot(this.mediator().getSignedChainSlotId(), any);
            ri.set_slot(this.mediator().getBusSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao limpar informa\u00e7\u00f5es nos slots";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        String msg = "Chamada atendida: opera\u00e7\u00e3o (%s) requestId (%d)";
        logger.fine(String.format(msg, operation, ri.request_id()));
        logger.finest(String.format("[out] send_reply: %s", operation));
    }

    @Override
    public void send_exception(ServerRequestInfo ri) {
        logger.finest(String.format("[inout] send_exception: %s", ri.operation()));
    }

    @Override
    public void send_other(ServerRequestInfo ri) {
        logger.finest(String.format("[inout] send_other: %s", ri.operation()));
    }

    private byte[] newSecret() {
        int size = 16;
        byte[] secret = new byte[size];
        Random random = new Random();
        random.nextBytes(secret);
        return secret;
    }

    private void setCurrentConnection(ServerRequestInfo ri, ConnectionImpl conn) {
        try {
            ORBMediator mediator = this.mediator();
            int id = mediator.getUniqueId();
            OpenBusContextImpl context = this.mediator().getContext();
            Any any = mediator.getORB().create_any();
            any.insert_long(id);
            ri.set_slot(context.getCurrentConnectionSlotId(), any);
            context.setConnectionById(id, conn);
            logger.finest(String.format("Salvando conex\u00e3o que realiza o dispatch: conex\u00e3o (%s) login (%s) opera\u00e7\u00e3o (%s) requestId (%s)", conn.connId(), conn.login().id, ri.operation(), ri.request_id()));
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }

    private void removeCurrentConnection(ServerRequestInfo ri) {
        try {
            OpenBusContextImpl context = this.mediator().getContext();
            Any slot = ri.get_slot(context.getCurrentConnectionSlotId());
            if (slot.type().kind().value() == 0) {
                String message = "BUG: Falha inesperada ao acessar o slot da conex\u00e3o corrente";
                logger.log(Level.SEVERE, message);
                throw new INTERNAL(message);
            }
            int id = slot.extract_long();
            context.setConnectionById(id, null);
            Any any = this.mediator().getORB().create_any();
            ri.set_slot(context.getCurrentConnectionSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }
}

