/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Map;
import java.util.Properties;
import org.omg.CORBA.ORB;
import tecgraf.openbus.core.ORBInitializerInfo;

final class ORBBuilder {
    private String[] args;
    private Properties props;

    public ORBBuilder() {
        this(null, null);
    }

    public ORBBuilder(String[] args) {
        this(args, null);
    }

    public ORBBuilder(Properties props) {
        this(null, props);
    }

    public ORBBuilder(String[] args, Properties props) {
        this.args = args;
        this.props = props == null ? this.buildDefaultProperties() : this.buildFromProperties(props);
        this.props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        this.props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
    }

    public void setHost(String host) {
        this.props.put("OAIAddr", host);
    }

    public void setPort(int port) {
        this.props.put("OAPort", String.valueOf(port));
    }

    public void addInitializer(ORBInitializerInfo initializer) {
        this.props.put("org.omg.PortableInterceptor.ORBInitializerClass." + initializer.getId(), initializer.getClassName());
    }

    public ORB build() {
        return ORB.init((String[])this.args, (Properties)this.props);
    }

    private Properties buildDefaultProperties() {
        Properties props = new Properties();
        props.setProperty("jacorb.log.default.verbosity", "1");
        props.setProperty("jacorb.connection.client.pending_reply_timeout", "30000");
        return props;
    }

    private Properties buildFromProperties(Properties props) {
        Properties result = new Properties(this.buildDefaultProperties());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            result.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return result;
    }
}

