package tecgraf.openbus;

import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;

/**
 * Callback de login invlido.
 * <p>
 * Interface a ser implementada pelo objeto de callback a ser chamado quando uma
 * notificao de login invlido  recebida.
 * 
 * @author Tecgraf
 */
public interface InvalidLoginCallback {

  /**
   * Callback de login invlido.
   * <p>
   * Mtodo a ser implementado pelo objeto de callback a ser chamado quando uma
   * notificao de login invlido  recebida. Caso alguma exceo ocorra
   * durante a execuo do mtodo e no seja tratada, o erro ser capturado pelo
   * interceptador e registrado no log.
   * 
   * @param conn Conexo que recebeu a notificao de login invlido.
   * @param login Informaes do login que se tornou invlido.
   */
  void invalidLogin(Connection conn, LoginInfo login);
}
