/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UserException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.CallerChainImpl;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.ORBUtils;
import tecgraf.openbus.core.v2_0.credential.ExportedCallChain;
import tecgraf.openbus.core.v2_0.credential.ExportedCallChainHelper;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.credential.SignedCallChainHelper;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_0.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.exception.InvalidChainStream;
import tecgraf.openbus.exception.InvalidPropertyValue;
import tecgraf.openbus.exception.OpenBusInternalException;

final class OpenBusContextImpl
extends LocalObject
implements OpenBusContext {
    private static final Logger logger = Logger.getLogger(OpenBusContextImpl.class.getName());
    private static final int CHAIN_HEADER_SIZE = 8;
    private final int CURRENT_CONNECTION_SLOT_ID;
    private final int IGNORE_THREAD_SLOT_ID;
    private Map<Integer, Connection> connectedById;
    private Connection defaultConn;
    private CallDispatchCallback dispatchCallback;
    private ORB orb;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwlock.writeLock();

    public OpenBusContextImpl(int currentConnectionSlotId, int ignoreThreadSlotId) {
        this.connectedById = Collections.synchronizedMap(new HashMap());
        this.CURRENT_CONNECTION_SLOT_ID = currentConnectionSlotId;
        this.IGNORE_THREAD_SLOT_ID = ignoreThreadSlotId;
    }

    @Override
    public ORB orb() {
        return this.orb;
    }

    @Override
    public Connection createConnection(String host, int port) {
        ConnectionImpl conn;
        try {
            conn = new ConnectionImpl(host, port, this, this.orb);
        }
        catch (InvalidPropertyValue e) {
            throw new OpenBusInternalException("BUG: Este erro nunca deveria ocorrer.", e);
        }
        return conn;
    }

    @Override
    public Connection createConnection(String host, int port, Properties props) throws InvalidPropertyValue {
        return new ConnectionImpl(host, port, this, this.orb, props);
    }

    int getCurrentConnectionSlotId() {
        return this.CURRENT_CONNECTION_SLOT_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection setDefaultConnection(Connection conn) {
        Connection old;
        this.writeLock.lock();
        try {
            old = this.defaultConn;
            this.defaultConn = conn;
        }
        finally {
            this.writeLock.unlock();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getDefaultConnection() {
        this.readLock.lock();
        try {
            Connection connection = this.defaultConn;
            return connection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Connection setCurrentConnection(Connection conn) {
        int id = ORBUtils.getMediator(this.orb).getUniqueId();
        Any any = this.orb.create_any();
        if (conn != null) {
            any.insert_long(id);
        }
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.CURRENT_CONNECTION_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        return this.setConnectionById(id, conn);
    }

    @Override
    public Connection getCurrentConnection() {
        Any any;
        Connection connection = null;
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            any = current.get_slot(this.CURRENT_CONNECTION_SLOT_ID);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        if (any.type().kind().value() != 0) {
            int id = any.extract_long();
            connection = this.connectedById.get(id);
        }
        if (connection == null) {
            connection = this.getDefaultConnection();
        }
        return connection;
    }

    @Override
    public CallerChain getCallerChain() {
        CallChain callChain;
        SignedCallChain signedChain;
        String busId;
        Current current = ORBUtils.getPICurrent(this.orb);
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        try {
            Any any = current.get_slot(mediator.getBusSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            busId = any.extract_string();
            any = current.get_slot(mediator.getSignedChainSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            signedChain = SignedCallChainHelper.extract(any);
            Any anyChain = mediator.getCodec().decode_value(signedChain.encoded, CallChainHelper.type());
            callChain = CallChainHelper.extract(anyChain);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao recuperar a cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        return new CallerChainImpl(busId, callChain.target, callChain.caller, callChain.originators, signedChain);
    }

    @Override
    public void joinChain() throws OpenBusInternalException {
        this.joinChain(null);
    }

    @Override
    public void joinChain(CallerChain chain) {
        CallerChain callerChain = chain = chain != null ? chain : this.getCallerChain();
        if (chain == null) {
            return;
        }
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            SignedCallChain signedChain = ((CallerChainImpl)chain).signedCallChain();
            Any any = this.orb.create_any();
            SignedCallChainHelper.insert(any, signedChain);
            current.set_slot(mediator.getJoinedChainSlotId(), any);
            Any busAny = this.orb.create_any();
            busAny.insert_string(chain.busid());
            current.set_slot(mediator.getJoinedBusSlotId(), busAny);
            Any targetAny = this.orb.create_any();
            targetAny.insert_string(chain.target());
            current.set_slot(mediator.getJoinedChainTargetSlotId(), targetAny);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public void exitChain() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any any = this.orb.create_any();
            current.set_slot(mediator.getJoinedChainSlotId(), any);
            current.set_slot(mediator.getJoinedChainTargetSlotId(), any);
            current.set_slot(mediator.getJoinedBusSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public CallerChain getJoinedChain() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any any = current.get_slot(mediator.getJoinedBusSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            String busId = any.extract_string();
            any = current.get_slot(mediator.getJoinedChainSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            SignedCallChain signedChain = SignedCallChainHelper.extract(any);
            Any anyChain = mediator.getCodec().decode_value(signedChain.encoded, CallChainHelper.type());
            CallChain callChain = CallChainHelper.extract(anyChain);
            any = current.get_slot(mediator.getJoinedChainTargetSlotId());
            if (any.type().kind().value() == 0) {
                return null;
            }
            String target = any.extract_string();
            return new CallerChainImpl(busId, target, callChain.caller, callChain.originators, signedChain);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao recuperar a cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public CallerChain makeChainFor(String loginId) throws InvalidLogins, ServiceFailure {
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection();
        String busid = conn.busid();
        SignedCallChain signedChain = conn.access().signChainFor(loginId);
        try {
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any anyChain = mediator.getCodec().decode_value(signedChain.encoded, CallChainHelper.type());
            CallChain callChain = CallChainHelper.extract(anyChain);
            return new CallerChainImpl(busid, callChain.target, callChain.caller, callChain.originators, signedChain);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao criar uma nova cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public byte[] encodeChain(CallerChain chain) {
        byte[] encodedId;
        byte[] encodedChain;
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        Any anyChain = this.orb.create_any();
        CallerChainImpl chainImpl = (CallerChainImpl)chain;
        ExportedCallChainHelper.insert(anyChain, new ExportedCallChain(chain.busid(), chainImpl.signedCallChain()));
        Any anyId = this.orb.create_any();
        anyId.insert_long(1112888064);
        try {
            encodedChain = codec.encode_value(anyChain);
            encodedId = codec.encode_value(anyId);
        }
        catch (InvalidTypeForEncoding e) {
            String message = "Falha inesperada ao codificar uma cadeia para exporta\u00e7\u00e3o";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        byte[] fullEnconding = new byte[encodedChain.length + encodedId.length];
        System.arraycopy(encodedId, 0, fullEnconding, 0, encodedId.length);
        System.arraycopy(encodedChain, 0, fullEnconding, encodedId.length, encodedChain.length);
        return fullEnconding;
    }

    @Override
    public CallerChain decodeChain(byte[] encoded) throws InvalidChainStream {
        CallChain callChain;
        ExportedCallChain importedChain;
        if (encoded.length <= 8) {
            String msg = "Stream de bytes n\u00e3o corresponde a uma cadeia de chamadas.";
            throw new InvalidChainStream(msg);
        }
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        byte[] encodedId = new byte[8];
        byte[] encodedChain = new byte[encoded.length - 8];
        System.arraycopy(encoded, 0, encodedId, 0, encodedId.length);
        System.arraycopy(encoded, encodedId.length, encodedChain, 0, encodedChain.length);
        try {
            Any anyId = codec.decode_value(encodedId, this.orb.get_primitive_tc(TCKind.tk_long));
            int id = anyId.extract_long();
            if (1112888064 != id) {
                String msg = String.format("Formato da cadeia \u00e9 de vers\u00e3o incompat\u00edvel.\nFormato recebido = %i\nFormato suportado = %i", id, 1112888064);
                throw new InvalidChainStream(msg);
            }
            Any anyExportedChain = codec.decode_value(encodedChain, ExportedCallChainHelper.type());
            importedChain = ExportedCallChainHelper.extract(anyExportedChain);
            Any anyChain = mediator.getCodec().decode_value(importedChain.signedChain.encoded, CallChainHelper.type());
            callChain = CallChainHelper.extract(anyChain);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao decodificar uma cadeia exportada.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        return new CallerChainImpl(importedChain.bus, callChain.target, callChain.caller, callChain.originators, importedChain.signedChain);
    }

    Connection getConnectionById(int id) {
        return this.connectedById.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection setConnectionById(int id, Connection conn) {
        Map<Integer, Connection> map = this.connectedById;
        synchronized (map) {
            Connection old = this.connectedById.remove(id);
            if (conn != null) {
                this.connectedById.put(id, conn);
            }
            return old;
        }
    }

    void setORB(ORB orb) {
        this.orb = orb;
    }

    void ignoreCurrentThread() {
        Any any = this.orb.create_any();
        any.insert_boolean(true);
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.IGNORE_THREAD_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de intercepta\u00e7\u00e3o ignorada";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    void unignoreCurrentThread() {
        Any any = this.orb.create_any();
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.IGNORE_THREAD_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de intercepta\u00e7\u00e3o ignorada";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    boolean isCurrentThreadIgnored(RequestInfo ri) {
        Any any;
        try {
            any = ri.get_slot(this.IGNORE_THREAD_SLOT_ID);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot de intercepta\u00e7\u00e3o ignorada";
            throw new INTERNAL(message);
        }
        if (any.type().kind().value() != 0) {
            boolean isIgnored = any.extract_boolean();
            return isIgnored;
        }
        return false;
    }

    @Override
    public void onCallDispatch(CallDispatchCallback callback) {
        this.dispatchCallback = callback;
    }

    @Override
    public CallDispatchCallback onCallDispatch() {
        return this.dispatchCallback;
    }

    @Override
    public LoginRegistry getLoginRegistry() {
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection();
        if (conn == null || conn.login() == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        return conn.logins();
    }

    @Override
    public OfferRegistry getOfferRegistry() {
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection();
        if (conn == null || conn.login() == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        return conn.offers();
    }
}

