/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Clock;
import demo.ClockHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class IndependentClockClient {
    private static String host;
    private static int port;
    private static String entity;
    private static String password;
    private static int interval;
    private static ConcurrencyControl options;

    public static void main(String[] args) throws AlreadyLoggedIn, InvalidName, ServiceFailure {
        if (args.length < 3) {
            String params = "[interval]";
            String desc = "\n  - [interval] = Tempo de espera entre tentativas de acesso ao barramento em virtude de falhas. Valor padr\u00e3o \u00e9 '1'";
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> [password] %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - password = senha (opcional) %s", params, desc));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        password = entity = args[2];
        if (args.length > 3) {
            password = args[3];
        }
        if (args.length > 4) {
            try {
                interval = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                System.out.println("Valor de [interval] deve ser um n\u00famero");
                System.exit(1);
                return;
            }
        }
        ORB orb = ORBInitializer.initORB();
        final OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        Thread client = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                for (i = 0; i < 10; ++i) {
                    timestamp = null;
                    clock = null;
                    var4_8 = IndependentClockClient.access$000().lock;
                    synchronized (var4_8) {
                        clock = IndependentClockClient.access$000().found;
                    }
                    if (clock != null) {
                        failed = true;
                        try {
                            timestamp = clock.getTimeInTicks();
                            failed = false;
                        }
                        catch (TRANSIENT e) {
                            System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
                        }
                        catch (COMM_FAILURE e) {
                            System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
                        }
                        catch (NO_PERMISSION e) {
                            switch (e.minor) {
                                case 1112888319: {
                                    System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", new java.lang.Object[]{IndependentClockClient.access$100()}));
                                    ** break;
lbl28:
                                    // 1 sources

                                    break;
                                }
                                case 1112888068: {
                                    System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                                    ** break;
lbl32:
                                    // 1 sources

                                    break;
                                }
                                case 1112888067: {
                                    System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                                    ** break;
lbl36:
                                    // 1 sources

                                    break;
                                }
                                case 1112888318: {
                                    System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                                    break;
                                }
                                ** default:
lbl41:
                                // 1 sources

                                break;
                            }
                        }
                        finally {
                            if (failed) {
                                e = IndependentClockClient.access$000().lock;
                                synchronized (e) {
                                    IndependentClockClient.access$000().found = null;
                                }
                            }
                        }
                    }
                    if (timestamp == null) {
                        failed = IndependentClockClient.access$000().lock;
                        synchronized (failed) {
                            IndependentClockClient.access$300(context, IndependentClockClient.access$200());
                        }
                        timestamp = System.currentTimeMillis();
                    }
                    date = new Date(timestamp);
                    formatter = new SimpleDateFormat("HH:mm:ss:SSS");
                    System.out.println(formatter.format(date));
                    try {
                        Thread.sleep(IndependentClockClient.access$200() * 1000);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                try {
                    context.getCurrentConnection().logout();
                }
                catch (ServiceFailure e) {
                    System.err.println(String.format("falha severa no barramento em %s:%s : %s", new java.lang.Object[]{IndependentClockClient.access$400(), IndependentClockClient.access$500(), e.message}));
                }
                catch (TRANSIENT e) {
                    System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", new java.lang.Object[]{IndependentClockClient.access$400(), IndependentClockClient.access$500()}));
                }
                catch (COMM_FAILURE e) {
                    System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                }
                catch (NO_PERMISSION e) {
                    if (e.minor == 1112888319) {
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", new java.lang.Object[]{IndependentClockClient.access$100()}));
                    }
                }
                finally {
                    System.out.println("cliente deslogado...");
                }
            }
        };
        client.start();
        Connection connection = context.createConnection(host, port);
        context.setDefaultConnection(connection);
        connection.onInvalidLoginCallback(new InvalidLoginCallback(){

            public void invalidLogin(Connection conn, LoginInfo login) {
                this.login(conn, entity, password, host, port);
                IndependentClockClient.activateSearch(context, interval);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void login(Connection conn, String entity, String password, java.lang.Object host, java.lang.Object port) {
                boolean failed;
                do {
                    failed = true;
                    try {
                        conn.loginByPassword(entity, password.getBytes());
                        failed = false;
                    }
                    catch (AlreadyLoggedIn e) {
                        failed = false;
                    }
                    catch (AccessDenied e) {
                        System.err.println(String.format("a senha fornecida para a entidade '%s' foi negada", entity));
                    }
                    catch (ServiceFailure e) {
                        System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
                    }
                    catch (TRANSIENT e) {
                        System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
                    }
                    catch (COMM_FAILURE e) {
                        System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                    }
                    catch (NO_PERMISSION e) {
                        if (e.minor != 1112888319) continue;
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                    }
                    finally {
                        if (failed) {
                            try {
                                Thread.sleep(interval * 1000);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                } while (failed);
            }
        });
        connection.onInvalidLoginCallback().invalidLogin(connection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activateSearch(final OpenBusContext context, final int interval) {
        java.lang.Object object = IndependentClockClient.options.lock;
        synchronized (object) {
            if (IndependentClockClient.options.found == null && !IndependentClockClient.options.active) {
                IndependentClockClient.options.active = true;
                Thread finder = new Thread(){

                    @Override
                    public void run() {
                        IndependentClockClient.find(context, interval);
                    }
                };
                finder.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void find(OpenBusContext context, int interval) {
        while (true) {
            Clock clock;
            ServiceOfferDesc[] services;
            block45: {
                services = null;
                clock = null;
                boolean failed = true;
                try {
                    ServiceProperty[] properties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Independent Clock")};
                    services = context.getOfferRegistry().findServices(properties);
                    failed = false;
                }
                catch (ServiceFailure e) {
                    System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
                }
                catch (TRANSIENT e) {
                    System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
                }
                catch (COMM_FAILURE e) {
                    System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                }
                catch (NO_PERMISSION e) {
                    if (e.minor == 1112888319) {
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                    }
                }
                finally {
                    if (!failed) break block45;
                    try {
                        Thread.sleep(interval * 1000);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
            }
            block42: for (ServiceOfferDesc offerDesc : services) {
                try {
                    Object helloObj = offerDesc.service_ref.getFacet(ClockHelper.id());
                    if (helloObj == null) {
                        System.out.println("o servi\u00e7o encontrado n\u00e3o prov\u00ea a faceta ofertada");
                        continue;
                    }
                    java.lang.Object object = IndependentClockClient.options.lock;
                    synchronized (object) {
                        clock = IndependentClockClient.options.found = ClockHelper.narrow(helloObj);
                        break;
                    }
                }
                catch (TRANSIENT e) {
                    System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
                }
                catch (COMM_FAILURE e) {
                    System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
                }
                catch (NO_PERMISSION e) {
                    switch (e.minor) {
                        case 1112888319: {
                            System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                            continue block42;
                        }
                        case 1112888068: {
                            System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                            continue block42;
                        }
                        case 1112888067: {
                            System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                            continue block42;
                        }
                        case 1112888318: {
                            System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                        }
                    }
                }
            }
            if (clock != null) break;
            System.err.println("servi\u00e7o esperado n\u00e3o foi encontrado.");
            try {
                Thread.sleep(interval * 1000);
            }
            catch (InterruptedException e) {}
        }
        java.lang.Object object = IndependentClockClient.options.lock;
        synchronized (object) {
            IndependentClockClient.options.active = false;
        }
    }

    static /* synthetic */ ConcurrencyControl access$000() {
        return options;
    }

    static {
        interval = 1;
        options = new ConcurrencyControl();
    }

    public static class ConcurrencyControl {
        public volatile boolean active = false;
        public Clock found = null;
        public java.lang.Object lock = new java.lang.Object();
    }
}

