/*
 * Decompiled with CFR 0.152.
 */
package scs.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import scs.core.ComponentId;
import scs.core.Facet;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import scs.core.IComponentServant;
import scs.core.IMetaInterface;
import scs.core.IMetaInterfaceHelper;
import scs.core.IMetaInterfaceServant;
import scs.core.IReceptacles;
import scs.core.IReceptaclesHelper;
import scs.core.IReceptaclesServant;
import scs.core.Receptacle;
import scs.core.exception.FacetAlreadyExists;
import scs.core.exception.FacetDoesNotExist;
import scs.core.exception.ReceptacleAlreadyExistsException;
import scs.core.exception.ReceptacleDoesNotExistException;
import scs.core.exception.SCSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContext {
    public static final String ICOMPONENT_FACET_NAME = "IComponent";
    public static final String IRECEPTACLES_FACET_NAME = "IReceptacles";
    public static final String IMETAINTERFACE_FACET_NAME = "IMetaInterface";
    private ORB orb;
    private POA poa;
    private ComponentId componentId;
    private Map<String, Facet> facets;
    private Map<String, Receptacle> receptacles;
    private int currentConnectionId = 0;
    public final int CONNECTION_LIMIT = 100;

    public ComponentContext(ORB orb, POA poa, ComponentId id) throws SCSException {
        if (orb == null) {
            throw new IllegalArgumentException("The ORB can't be null");
        }
        if (poa == null) {
            throw new IllegalArgumentException("The POA can't be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("The component's id can't be null");
        }
        this.orb = orb;
        this.poa = poa;
        this.componentId = id;
        this.facets = new HashMap<String, Facet>();
        this.receptacles = new HashMap<String, Receptacle>();
        this.addBasicFacets();
    }

    private void addBasicFacets() throws SCSException {
        this.addFacet(IComponent.class.getSimpleName(), IComponentHelper.id(), (Servant)new IComponentServant(this));
        this.addFacet(IReceptacles.class.getSimpleName(), IReceptaclesHelper.id(), (Servant)new IReceptaclesServant(this));
        this.addFacet(IMetaInterface.class.getSimpleName(), IMetaInterfaceHelper.id(), (Servant)new IMetaInterfaceServant(this));
    }

    public ComponentId getComponentId() {
        return this.componentId;
    }

    public void addFacet(String name, String interfaceName, Servant servant) throws SCSException {
        Facet facet = this.facets.get(name);
        if (facet != null) {
            throw new FacetAlreadyExists(name);
        }
        facet = new Facet(this.poa, name, interfaceName, servant);
        this.facets.put(name, facet);
    }

    public void updateFacet(String name, Servant servant) throws SCSException {
        Facet facet = this.facets.get(name);
        if (facet == null) {
            throw new FacetDoesNotExist(name);
        }
        facet.setServant(servant);
    }

    public void addReceptacle(String name, String interfaceName, boolean isMultiplex) throws ReceptacleAlreadyExistsException {
        Receptacle receptacle = this.receptacles.get(name);
        if (receptacle != null) {
            throw new ReceptacleAlreadyExistsException(name);
        }
        receptacle = new Receptacle(this, name, interfaceName, isMultiplex);
        this.receptacles.put(name, receptacle);
    }

    public void removeFacet(String name) throws SCSException {
        Facet facet = this.facets.remove(name);
        if (facet == null) {
            throw new FacetDoesNotExist(name);
        }
        facet.deactivate();
    }

    public void removeReceptacle(String name) throws ReceptacleDoesNotExistException {
        Receptacle receptacle = this.receptacles.remove(name);
        if (receptacle == null) {
            throw new ReceptacleDoesNotExistException(name);
        }
    }

    public Collection<Facet> getFacets() {
        return Collections.unmodifiableCollection(this.facets.values());
    }

    public Facet getFacetByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The facet's name can't be null");
        }
        return this.facets.get(name);
    }

    public Collection<Receptacle> getReceptacles() {
        return Collections.unmodifiableCollection(this.receptacles.values());
    }

    public Receptacle getReceptacleByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The receptacle's name can't be null");
        }
        return this.receptacles.get(name);
    }

    public IComponent getIComponent() {
        Facet facet = this.facets.get(IComponent.class.getSimpleName());
        if (facet == null) {
            return null;
        }
        return IComponentHelper.narrow((Object)facet.getDescription().facet_ref);
    }

    int generateConnectionId() {
        return this.currentConnectionId++;
    }

    public String getComponentIdAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.componentId.name);
        builder.append(this.componentId.major_version);
        builder.append(this.componentId.minor_version);
        builder.append(this.componentId.patch_version);
        builder.append(this.componentId.platform_spec);
        return builder.toString();
    }

    public POA getPOA() {
        return this.poa;
    }

    public ORB getORB() {
        return this.orb;
    }
}

