/*
 * Decompiled with CFR 0.152.
 */
package scs.core;

import org.omg.CORBA.Object;
import scs.core.AlreadyConnected;
import scs.core.ComponentContext;
import scs.core.ConnectionDescription;
import scs.core.ExceededConnectionLimit;
import scs.core.IReceptaclesPOA;
import scs.core.InvalidConnection;
import scs.core.InvalidName;
import scs.core.NoConnection;
import scs.core.Receptacle;

public class IReceptaclesServant
extends IReceptaclesPOA {
    private ComponentContext myComponent;

    public IReceptaclesServant(ComponentContext myComponent) {
        this.myComponent = myComponent;
    }

    public synchronized int connect(String receptacle, Object obj) throws InvalidName, InvalidConnection, AlreadyConnected, ExceededConnectionLimit {
        Receptacle rec = this.myComponent.getReceptacleByName(receptacle);
        if (rec == null) {
            throw new InvalidName();
        }
        return rec.addConnection(obj);
    }

    public synchronized void disconnect(int id) throws InvalidConnection, NoConnection {
        if (id <= 0) {
            throw new InvalidConnection();
        }
        boolean disconnected = false;
        for (Receptacle receptacle : this.myComponent.getReceptacles()) {
            if (!receptacle.removeConnection(id)) continue;
            disconnected = true;
            break;
        }
        if (!disconnected) {
            throw new NoConnection();
        }
    }

    public synchronized ConnectionDescription[] getConnections(String receptacle) throws InvalidName {
        Receptacle rec = this.myComponent.getReceptacleByName(receptacle);
        if (rec == null) {
            throw new InvalidName();
        }
        return rec.getDescription().connections;
    }

    public Object _get_component() {
        return this.myComponent.getIComponent();
    }
}

