/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.Optional;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Make sure SLF4J log statements contain proper placeholders with matching arguments", link="https://error-prone.picnic.tech/bugpatterns/Slf4jLogStatement", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class Slf4jLogStatement
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> MARKER = Matchers.isSubtypeOf((String)"org.slf4j.Marker");
    private static final Matcher<ExpressionTree> THROWABLE = Matchers.isSubtypeOf(Throwable.class);
    private static final Matcher<ExpressionTree> SLF4J_LOGGER_INVOCATION = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"trace", "debug", "info", "warn", "error"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!SLF4J_LOGGER_INVOCATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = Slf4jLogStatement.getTrimmedArguments(tree, state);
        return Slf4jLogStatement.getFormatString(args).map(formatString -> this.validateFormatString((String)formatString, tree, args, state)).orElse(Description.NO_MATCH);
    }

    private static List<? extends ExpressionTree> getTrimmedArguments(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> args = tree.getArguments();
        Verify.verify((!args.isEmpty() ? 1 : 0) != 0, (String)"Unexpected invocation of nullary SLF4J log method", (Object[])new Object[0]);
        int lTrim = MARKER.matches((Tree)args.get(0), state) ? 1 : 0;
        int rTrim = THROWABLE.matches((Tree)args.get(args.size() - 1), state) ? 1 : 0;
        return args.subList(lTrim, args.size() - rTrim);
    }

    private static Optional<String> getFormatString(List<? extends ExpressionTree> args) {
        Verify.verify((!args.isEmpty() ? 1 : 0) != 0, (String)"Failed to identify SLF4J log method format string", (Object[])new Object[0]);
        return Optional.ofNullable((String)ASTHelpers.constValue((Tree)args.get(0), String.class));
    }

    private Description validateFormatString(String formatString, MethodInvocationTree tree, List<? extends ExpressionTree> args, VisitorState state) {
        Description.Builder description = this.buildDescription(tree);
        return Slf4jLogStatement.isFormatString(formatString, args.get(0), state, description) && Slf4jLogStatement.hasValidArguments(formatString, args.subList(1, args.size()), description) ? Description.NO_MATCH : description.build();
    }

    private static boolean isFormatString(String formatString, ExpressionTree tree, VisitorState state, Description.Builder description) {
        String fixed = formatString.replace("%s", "{}");
        if (fixed.equals(formatString)) {
            return true;
        }
        description.setMessage("SLF4J log statement placeholders are of the form `{}`, not `%s`");
        if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
            description.addFix((Fix)SuggestedFix.replace((Tree)tree, (String)SourceCode.treeToString(tree, state).replace("%s", "{}")));
        }
        return false;
    }

    private static boolean hasValidArguments(CharSequence formatString, List<? extends ExpressionTree> args, Description.Builder description) {
        int placeholders = Splitter.on((String)"{}").splitToList(formatString).size() - 1;
        if (placeholders == args.size()) {
            return true;
        }
        description.setMessage(String.format("Log statement contains %s placeholders, but specifies %s matching argument(s)", placeholders, args.size()));
        return false;
    }
}

