/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Convert;
import java.util.Formattable;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Prefer `String#join` over `String#format`", link="https://error-prone.picnic.tech/bugpatterns/StringJoin", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class StringJoin
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Splitter FORMAT_SPECIFIER_SPLITTER = Splitter.on((String)"%s");
    private static final Matcher<ExpressionTree> STRING_FORMAT_INVOCATION = MethodMatchers.staticMethod().onClass(String.class.getName()).named("format");
    private static final Supplier<Type> CHAR_SEQUENCE_TYPE = Suppliers.typeFromClass(CharSequence.class);
    private static final Supplier<Type> FORMATTABLE_TYPE = Suppliers.typeFromClass(Formattable.class);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!STRING_FORMAT_INVOCATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String formatString = (String)ASTHelpers.constValue((Tree)tree.getArguments().get(0), String.class);
        if (formatString == null) {
            return Description.NO_MATCH;
        }
        List separators = FORMAT_SPECIFIER_SPLITTER.splitToList((CharSequence)formatString);
        if (separators.size() < 2) {
            return Description.NO_MATCH;
        }
        if (separators.size() != tree.getArguments().size()) {
            return Description.NO_MATCH;
        }
        int lastIndex = separators.size() - 1;
        if (!((String)separators.get(0)).isEmpty() || !((String)separators.get(lastIndex)).isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableSet innerSeparators = ImmutableSet.copyOf(separators.subList(1, lastIndex));
        if (innerSeparators.size() > 1) {
            return Description.NO_MATCH;
        }
        if (innerSeparators.isEmpty()) {
            return this.trySuggestExplicitStringConversion(tree, state);
        }
        String separator = (String)Iterables.getOnlyElement((Iterable)innerSeparators);
        if (separator.indexOf(37) >= 0) {
            return Description.NO_MATCH;
        }
        return this.trySuggestExplicitJoin(tree, separator, state);
    }

    private Description trySuggestExplicitStringConversion(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree argument = tree.getArguments().get(1);
        if (StringJoin.isSubtype(ASTHelpers.getType((Tree)argument), FORMATTABLE_TYPE, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Prefer `String#valueOf` over `String#format`").addFix((Fix)SuggestedFix.replace((Tree)tree, (String)StringJoin.withStringConversionExpression(argument, state))).build();
    }

    private Description trySuggestExplicitJoin(MethodInvocationTree tree, String separator, VisitorState state) {
        Iterator<? extends ExpressionTree> arguments = tree.getArguments().iterator();
        SuggestedFix.Builder fix = SuggestedFix.builder().replace((Tree)tree.getMethodSelect(), "String.join").replace((Tree)arguments.next(), String.format("\"%s\"", Convert.quote(separator)));
        while (arguments.hasNext()) {
            ExpressionTree argument = arguments.next();
            Type argumentType = ASTHelpers.getType((Tree)argument);
            if (StringJoin.isSubtype(argumentType, FORMATTABLE_TYPE, state)) {
                return Description.NO_MATCH;
            }
            if (StringJoin.isSubtype(argumentType, CHAR_SEQUENCE_TYPE, state)) continue;
            fix.replace((Tree)argument, StringJoin.withStringConversionExpression(argument, state));
        }
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private static boolean isSubtype(@Nullable Type subType, Supplier<Type> superType, VisitorState state) {
        return ASTHelpers.isSubtype((Type)subType, (Type)((Type)superType.get(state)), (VisitorState)state);
    }

    private static String withStringConversionExpression(ExpressionTree argument, VisitorState state) {
        return String.format("String.valueOf(%s)", SourceCode.treeToString(argument, state));
    }
}

