/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns.util;

import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.util.Optional;
import tech.picnic.errorprone.bugpatterns.util.JavaKeywords;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

public final class ConflictDetection {
    private ConflictDetection() {
    }

    public static Optional<String> findMethodRenameBlocker(Symbol.MethodSymbol method, String newName, VisitorState state) {
        if (ConflictDetection.isExistingMethodName(method.owner.type, newName, state)) {
            return Optional.of(String.format("a method named `%s` is already defined in this class or a supertype", newName));
        }
        if (ConflictDetection.isSimpleNameStaticallyImported(newName, state)) {
            return Optional.of(String.format("`%s` is already statically imported", newName));
        }
        if (!JavaKeywords.isValidIdentifier(newName)) {
            return Optional.of(String.format("`%s` is not a valid identifier", newName));
        }
        return Optional.empty();
    }

    private static boolean isExistingMethodName(Type clazz, String name, VisitorState state) {
        return ASTHelpers.matchingMethods((Name)state.getName(name), method -> true, (Type)clazz, (Types)state.getTypes()).findAny().isPresent();
    }

    private static boolean isSimpleNameStaticallyImported(String simpleName, VisitorState state) {
        return state.getPath().getCompilationUnit().getImports().stream().filter(ImportTree::isStatic).map(ImportTree::getQualifiedIdentifier).map(tree -> ConflictDetection.getStaticImportSimpleName(tree, state)).anyMatch(simpleName::contentEquals);
    }

    private static CharSequence getStaticImportSimpleName(Tree tree, VisitorState state) {
        String source = SourceCode.treeToString(tree, state);
        return source.subSequence(source.lastIndexOf(46) + 1, source.length());
    }
}

