/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;

final class AssertJDoubleRules {
    private AssertJDoubleRules() {
    }

    static final class AbstractDoubleAssertIsOne {
        AbstractDoubleAssertIsOne() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isOne();
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isEqualTo(1.0);
        }
    }

    static final class AbstractDoubleAssertIsNotZero {
        AbstractDoubleAssertIsNotZero() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isNotZero();
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isNotEqualTo(0.0);
        }
    }

    static final class AbstractDoubleAssertIsZero {
        AbstractDoubleAssertIsZero() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isZero();
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isEqualTo(0.0);
        }
    }

    static final class AbstractDoubleAssertIsNotEqualTo {
        AbstractDoubleAssertIsNotEqualTo() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n) {
            return (AbstractDoubleAssert)Refaster.anyOf((Object[])new AbstractDoubleAssert[]{doubleAssert.isNotCloseTo(n, Offset.offset((Number)0.0)), doubleAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n) {
            return doubleAssert.isNotEqualTo(n);
        }
    }

    static final class AbstractDoubleAssertIsEqualTo {
        AbstractDoubleAssertIsEqualTo() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n) {
            return (AbstractDoubleAssert)Refaster.anyOf((Object[])new AbstractDoubleAssert[]{doubleAssert.isCloseTo(n, Offset.offset((Number)0.0)), doubleAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n) {
            return doubleAssert.isEqualTo(n);
        }
    }

    static final class AbstractDoubleAssertIsCloseToWithOffset {
        AbstractDoubleAssertIsCloseToWithOffset() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n, Offset<Double> offset) {
            return doubleAssert.isEqualTo(n, offset);
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, Double n, Offset<Double> offset) {
            return doubleAssert.isEqualTo(n, offset);
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n, Offset<Double> offset) {
            return doubleAssert.isCloseTo(n, offset);
        }
    }
}

